/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Compat.JEI.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mowmaster.mowlib.Compat.JEI.JEIRecipeTypes;
import com.mowmaster.mowlib.Recipes.InWorldDualHandedCrafting;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DualHandedCraftingRecipeCategory
implements IRecipeCategory<InWorldDualHandedCrafting> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((ItemLike)DeferredRegisterItems.ICON_HAND.get());

    public DualHandedCraftingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("mowlib", "textures/gui/jei/dual_handed_crafting.png"), 0, 0, 196, 128);
        this.localizedName = Component.m_237115_((String)"mowlib.jei.dual_handed_crafting");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.renderStack);
    }

    public RecipeType<InWorldDualHandedCrafting> getRecipeType() {
        return JEIRecipeTypes.DUAL_HANDED_CRAFING;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InWorldDualHandedCrafting recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 25).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 57).addIngredients((Ingredient)recipe.m_7527_().get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 102, 41).addIngredients((Ingredient)recipe.m_7527_().get(0));
        if (recipe.getResultModificationName() != "") {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 102, 75).addItemStack(recipe.modifyMainHand() != false ? ((Ingredient)recipe.m_7527_().get(1)).m_43908_()[0].m_41714_((Component)Component.m_237115_((String)"mowlib.dual_handed.warning")) : ((Ingredient)recipe.m_7527_().get(2)).m_43908_()[0].m_41714_((Component)Component.m_237115_((String)"mowlib.dual_handed.warning")));
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 102, 75).addItemStack(recipe.getResultItem());
        }
    }

    public void draw(InWorldDualHandedCrafting recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.getResultModificationName() != "") {
            RenderSystem.enableBlend();
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            MutableComponent modType = Component.m_237115_((String)("dual_handed." + recipe.getResultModificationName()));
            int width1 = fontRenderer.m_92895_(modType.getString());
            guiGraphics.m_280430_(fontRenderer, (Component)modType, 98 - Math.floorDiv(width1, 2), 4, -1);
            MutableComponent separator1 = Component.m_237115_((String)"mowlib.text.separator.plus");
            MutableComponent spaceText = Component.m_237115_((String)"mowlib.text.separator.space");
            MutableComponent minText = Component.m_237115_((String)"mowlib.text.separator.min");
            MutableComponent maxText = Component.m_237115_((String)"mowlib.text.separator.max");
            MutableComponent increaseAmount = Component.m_237113_((String)("" + recipe.getResultModificationAmount()));
            MutableComponent minAmount = Component.m_237113_((String)("" + recipe.getResultModificationMinAmount()));
            MutableComponent maxAmount = Component.m_237113_((String)("" + recipe.getResultModificationMaxAmount()));
            separator1.m_7220_((Component)increaseAmount);
            separator1.m_7220_((Component)spaceText);
            separator1.m_7220_((Component)minText);
            separator1.m_7220_((Component)minAmount);
            separator1.m_7220_((Component)spaceText);
            separator1.m_7220_((Component)maxText);
            separator1.m_7220_((Component)maxAmount);
            int width = fontRenderer.m_92895_(separator1.getString());
            guiGraphics.m_280430_(fontRenderer, (Component)separator1, 98 - Math.floorDiv(width, 2), 100, -1);
        }
    }
}

