/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.BlockEntities;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseFilterableBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.CapabilityDust;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.Capabilities.Experience.CapabilityExperience;
import com.mowmaster.mowlib.Capabilities.Experience.IExperienceStorage;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MowLibBaseOmniStorageBlockEntity
extends MowLibBaseFilterableBlockEntity {
    private ItemStackHandler itemHandler = this.createItemHandlerPedestal();
    private LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private IEnergyStorage energyHandler = this.createEnergyHandler();
    private LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyHandler);
    private IFluidHandler fluidHandler = this.createFluidHandler();
    private LazyOptional<IFluidHandler> fluidCapability = LazyOptional.of(() -> this.fluidHandler);
    private IExperienceStorage experienceHandler = this.createExperienceHandler();
    private LazyOptional<IExperienceStorage> experienceCapability = LazyOptional.of(() -> this.experienceHandler);
    private IDustHandler dustHandler = this.createDustHandler();
    private LazyOptional<IDustHandler> dustCapability = LazyOptional.of(() -> this.dustHandler);
    private List<ItemStack> stacksList = new ArrayList<ItemStack>();
    private MobEffectInstance storedPotionEffect = null;
    private int storedPotionEffectDuration = 0;
    private int storedEnergy = 0;
    private FluidStack storedFluid = FluidStack.EMPTY;
    private int storedExperience = 0;
    private DustMagic storedDust = DustMagic.EMPTY;

    public MowLibBaseOmniStorageBlockEntity getOmniStorage() {
        return this;
    }

    public MowLibBaseOmniStorageBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public ItemStackHandler createItemHandlerPedestal() {
        return new ItemStackHandler(64){

            public void onLoad() {
                super.onLoad();
            }

            public void onContentsChanged(int slot) {
                MowLibBaseOmniStorageBlockEntity.this.update();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().insert()) {
                    return true;
                }
                return filter.canAcceptItems(MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), stack);
            }

            public int getSlots() {
                return super.getSlots();
            }

            public int getStackLimit(int slot, @Nonnull ItemStack stack) {
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().insert()) {
                    return super.getStackLimit(slot, stack);
                }
                return filter.canAcceptCountItems(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), stack.m_41741_(), MowLibBaseOmniStorageBlockEntity.this.getSlotSizeLimit(), stack);
            }

            public int getSlotLimit(int slot) {
                return super.getSlotLimit(slot);
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return super.getStackInSlot(slot > this.getSlots() ? 0 : slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot > this.getSlots() ? 0 : slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().extract()) {
                    return super.extractItem(slot > this.getSlots() ? 0 : slot, amount, simulate);
                }
                return super.extractItem(slot > this.getSlots() ? 0 : slot, Math.min(amount, filter == null ? amount : (!filter.getFilterDirection().extract() ? amount : filter.canAcceptCountItems(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), this.getStackInSlot(slot > this.getSlots() ? 0 : slot).m_41741_(), MowLibBaseOmniStorageBlockEntity.this.getSlotSizeLimit(), this.getStackInSlot(slot > this.getSlots() ? 0 : slot)))), simulate);
            }
        };
    }

    public IFluidHandler createFluidHandler() {
        return new IFluidHandler(){

            @Nonnull
            public FluidStack getFluidInTank(int i) {
                return MowLibBaseOmniStorageBlockEntity.this.storedFluid;
            }

            public int getTankCapacity(int tank) {
                return 0;
            }

            public int getTanks() {
                return 1;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (resource.isEmpty() || !resource.isFluidEqual(MowLibBaseOmniStorageBlockEntity.this.storedFluid)) {
                    return FluidStack.EMPTY;
                }
                return this.drain(resource.getAmount(), action);
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fluidAction) {
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                int maxDrainPostFilter = filter != null && filter.getFilterDirection().extract() ? Math.min(filter.canAcceptCountFluids(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), MowLibBaseOmniStorageBlockEntity.this.getFluidCapacity(), MowLibBaseOmniStorageBlockEntity.this.spaceForFluid(), MowLibBaseOmniStorageBlockEntity.this.storedFluid), maxDrain) : maxDrain;
                int fluidDrained = Math.min(maxDrainPostFilter, MowLibBaseOmniStorageBlockEntity.this.storedFluid.getAmount());
                FluidStack returnFluidStack = new FluidStack(MowLibBaseOmniStorageBlockEntity.this.storedFluid, fluidDrained);
                if (fluidAction.execute() && fluidDrained > 0) {
                    MowLibBaseOmniStorageBlockEntity.this.storedFluid.shrink(fluidDrained);
                    MowLibBaseOmniStorageBlockEntity.this.update();
                }
                return returnFluidStack;
            }

            public boolean isFluidValid(int i, @Nonnull FluidStack fluidStack) {
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().insert()) {
                    return MowLibBaseOmniStorageBlockEntity.this.storedFluid.isEmpty() || MowLibBaseOmniStorageBlockEntity.this.storedFluid.isFluidEqual(fluidStack);
                }
                return filter.canAcceptFluids(MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), fluidStack);
            }

            public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                if (fluidStack.isEmpty() || !this.isFluidValid(0, fluidStack) || !MowLibBaseOmniStorageBlockEntity.this.storedFluid.isEmpty() && !MowLibBaseOmniStorageBlockEntity.this.storedFluid.isFluidEqual(fluidStack)) {
                    return 0;
                }
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                int fluidAmountPostFilter = filter != null && filter.getFilterDirection().insert() ? Math.min(filter.canAcceptCountFluids(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), MowLibBaseOmniStorageBlockEntity.this.getFluidCapacity(), MowLibBaseOmniStorageBlockEntity.this.spaceForFluid(), fluidStack), fluidStack.getAmount()) : fluidStack.getAmount();
                int amountFilled = Math.min(this.getTankCapacity(0) - MowLibBaseOmniStorageBlockEntity.this.storedFluid.getAmount(), fluidAmountPostFilter);
                if (fluidAction.execute()) {
                    if (MowLibBaseOmniStorageBlockEntity.this.storedFluid.isEmpty()) {
                        MowLibBaseOmniStorageBlockEntity.this.storedFluid = new FluidStack(fluidStack, amountFilled);
                    } else {
                        MowLibBaseOmniStorageBlockEntity.this.storedFluid.grow(amountFilled);
                    }
                    MowLibBaseOmniStorageBlockEntity.this.update();
                }
                return amountFilled;
            }
        };
    }

    public IEnergyStorage createEnergyHandler() {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                if (!this.canReceive()) {
                    return 0;
                }
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                int maxReceivePostFilter = filter != null && filter.getFilterDirection().insert() ? filter.canAcceptCountEnergy(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), MowLibBaseOmniStorageBlockEntity.this.getEnergyCapacity(), MowLibBaseOmniStorageBlockEntity.this.spaceForEnergy(), maxReceive) : maxReceive;
                int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), maxReceivePostFilter);
                if (!simulate) {
                    MowLibBaseOmniStorageBlockEntity.this.storedEnergy += energyReceived;
                }
                MowLibBaseOmniStorageBlockEntity.this.update();
                return energyReceived;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                if (!this.canExtract()) {
                    return 0;
                }
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                int maxExtractPostFilter = filter != null && filter.getFilterDirection().extract() ? filter.canAcceptCountEnergy(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), MowLibBaseOmniStorageBlockEntity.this.getEnergyCapacity(), MowLibBaseOmniStorageBlockEntity.this.spaceForEnergy(), maxExtract) : maxExtract;
                int energyExtracted = Math.min(MowLibBaseOmniStorageBlockEntity.this.storedEnergy, maxExtractPostFilter);
                if (!simulate) {
                    MowLibBaseOmniStorageBlockEntity.this.storedEnergy -= energyExtracted;
                }
                return energyExtracted;
            }

            public int getEnergyStored() {
                return MowLibBaseOmniStorageBlockEntity.this.storedEnergy;
            }

            public int getMaxEnergyStored() {
                return 0;
            }

            public boolean canExtract() {
                if (MowLibBaseOmniStorageBlockEntity.this.hasEnergy()) {
                    IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                    if (filter == null || !filter.getFilterDirection().extract()) {
                        return true;
                    }
                    return filter.canAcceptEnergy(MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), 1);
                }
                return false;
            }

            public boolean canReceive() {
                if (MowLibBaseOmniStorageBlockEntity.this.hasSpaceForEnergy()) {
                    IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                    if (filter == null || !filter.getFilterDirection().insert()) {
                        return true;
                    }
                    return filter.canAcceptEnergy(MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), 1);
                }
                return false;
            }
        };
    }

    public IExperienceStorage createExperienceHandler() {
        return new IExperienceStorage(){

            @Override
            public int receiveExperience(int maxReceive, boolean simulate) {
                if (!this.canReceive()) {
                    return 0;
                }
                int spaceAvailable = this.getMaxExperienceStored() - this.getExperienceStored();
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                int maxReceivePostFilter = filter != null && filter.getFilterDirection().insert() ? filter.canAcceptCountExperience(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), MowLibBaseOmniStorageBlockEntity.this.getExperienceCapacity(), MowLibBaseOmniStorageBlockEntity.this.spaceForExperience(), maxReceive) : maxReceive;
                int experienceReceived = Math.min(spaceAvailable, maxReceivePostFilter);
                if (!simulate) {
                    MowLibBaseOmniStorageBlockEntity.this.storedExperience += experienceReceived;
                }
                MowLibBaseOmniStorageBlockEntity.this.update();
                return experienceReceived;
            }

            @Override
            public int extractExperience(int maxExtract, boolean simulate) {
                if (!this.canExtract()) {
                    return 0;
                }
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                int maxExtractPostFilter = filter != null && filter.getFilterDirection().extract() ? filter.canAcceptCountExperience(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), MowLibBaseOmniStorageBlockEntity.this.getExperienceCapacity(), MowLibBaseOmniStorageBlockEntity.this.spaceForExperience(), maxExtract) : maxExtract;
                int experienceExtracted = Math.min(MowLibBaseOmniStorageBlockEntity.this.storedExperience, maxExtractPostFilter);
                if (!simulate) {
                    MowLibBaseOmniStorageBlockEntity.this.storedExperience -= experienceExtracted;
                }
                return experienceExtracted;
            }

            @Override
            public int getExperienceStored() {
                return MowLibBaseOmniStorageBlockEntity.this.storedExperience;
            }

            @Override
            public int getMaxExperienceStored() {
                return 0;
            }

            @Override
            public boolean canExtract() {
                if (MowLibBaseOmniStorageBlockEntity.this.hasExperience()) {
                    IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                    if (filter == null || !filter.getFilterDirection().extract()) {
                        return true;
                    }
                    return filter.canAcceptExperience(MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), 1);
                }
                return false;
            }

            @Override
            public boolean canReceive() {
                if (MowLibBaseOmniStorageBlockEntity.this.hasSpaceForExperience()) {
                    IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                    if (filter == null || !filter.getFilterDirection().insert()) {
                        return true;
                    }
                    return filter.canAcceptExperience(MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), 1);
                }
                return false;
            }
        };
    }

    public IDustHandler createDustHandler() {
        return new IDustHandler(){

            protected void onContentsChanged() {
                MowLibBaseOmniStorageBlockEntity.this.update();
            }

            @Override
            public int getTanks() {
                return 1;
            }

            @Override
            @NotNull
            public DustMagic getDustMagicInTank(int tank) {
                return MowLibBaseOmniStorageBlockEntity.this.storedDust;
            }

            @Override
            public int getTankCapacity(int tank) {
                return 0;
            }

            @Override
            public boolean isDustValid(int tank, @NotNull DustMagic dustIn) {
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().insert()) {
                    return MowLibBaseOmniStorageBlockEntity.this.storedDust.isDustEqualOrEmpty(dustIn);
                }
                return filter.canAcceptDust(MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), dustIn);
            }

            @Override
            public int fill(DustMagic dust, IDustHandler.DustAction action) {
                int dustAmountPostFilter;
                if (dust.isEmpty() || !this.isDustValid(0, dust) || !MowLibBaseOmniStorageBlockEntity.this.storedDust.isDustEqual(dust)) {
                    return 0;
                }
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                int n = dustAmountPostFilter = filter != null && filter.getFilterDirection().insert() ? Math.min(filter.canAcceptCountDust(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), MowLibBaseOmniStorageBlockEntity.this.getDustCapacity(), MowLibBaseOmniStorageBlockEntity.this.spaceForDust(), dust), dust.getDustAmount()) : dust.getDustAmount();
                if (MowLibBaseOmniStorageBlockEntity.this.storedDust.isEmpty()) {
                    int amountFilled = Math.min(this.getTankCapacity(0), dustAmountPostFilter);
                    if (!action.simulate()) {
                        MowLibBaseOmniStorageBlockEntity.this.storedDust = new DustMagic(dust.getDustColor(), amountFilled);
                        this.onContentsChanged();
                    }
                    return amountFilled;
                }
                int amountFilled = Math.min(Math.min(this.getTankCapacity(0) - MowLibBaseOmniStorageBlockEntity.this.storedDust.getDustAmount(), dustAmountPostFilter), dust.getDustAmount());
                if (!action.simulate() && amountFilled > 0) {
                    MowLibBaseOmniStorageBlockEntity.this.storedDust.grow(amountFilled);
                    this.onContentsChanged();
                }
                return amountFilled;
            }

            @Override
            @NotNull
            public DustMagic drain(DustMagic dust, IDustHandler.DustAction action) {
                if (dust.isEmpty() || !dust.isDustEqual(MowLibBaseOmniStorageBlockEntity.this.storedDust)) {
                    return new DustMagic(-1, 0);
                }
                return this.drain(dust.getDustAmount(), action);
            }

            @Override
            @NotNull
            public DustMagic drain(int maxDrain, IDustHandler.DustAction action) {
                IFilterItem filter = MowLibBaseOmniStorageBlockEntity.this.getIFilterItem();
                int maxDrainPostFilter = filter != null && filter.getFilterDirection().extract() ? Math.min(filter.canAcceptCountDust(MowLibBaseOmniStorageBlockEntity.this.getOmniStorage(), MowLibBaseOmniStorageBlockEntity.this.getFilterInBlockEntity(), MowLibBaseOmniStorageBlockEntity.this.getDustCapacity(), MowLibBaseOmniStorageBlockEntity.this.spaceForDust(), MowLibBaseOmniStorageBlockEntity.this.storedDust), maxDrain) : maxDrain;
                int amountDrained = Math.min(MowLibBaseOmniStorageBlockEntity.this.storedDust.getDustAmount(), maxDrainPostFilter);
                DustMagic magic = new DustMagic(MowLibBaseOmniStorageBlockEntity.this.storedDust.getDustColor(), amountDrained);
                if (action.execute() && amountDrained > 0) {
                    if (amountDrained >= MowLibBaseOmniStorageBlockEntity.this.storedDust.getDustAmount()) {
                        MowLibBaseOmniStorageBlockEntity.this.storedDust.setDustAmount(0);
                        MowLibBaseOmniStorageBlockEntity.this.storedDust.setDustColor(-1);
                    } else {
                        MowLibBaseOmniStorageBlockEntity.this.storedDust.shrink(amountDrained);
                    }
                    this.onContentsChanged();
                }
                return magic;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        if (cap == CapabilityExperience.EXPERIENCE) {
            return this.experienceCapability.cast();
        }
        if (cap == CapabilityDust.DUST_HANDLER) {
            return this.dustCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void dropInventoryItems(Level worldIn, BlockPos pos) {
        MowLibItemUtils.dropInventoryItems(worldIn, pos, (IItemHandler)this.itemHandler);
    }

    public List<ItemStack> dropInventoryItemsList() {
        ArrayList<ItemStack> returner = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            returner.add(this.itemHandler.getStackInSlot(i));
        }
        return returner;
    }

    public void dropLiquidsInWorld(Level worldIn, BlockPos pos) {
        FluidStack inTank = this.fluidHandler.getFluidInTank(0);
        if (inTank.getAmount() > 0) {
            // empty if block
        }
    }

    public void removeEnergyFromBrokenPedestal(Level worldIn, BlockPos pos) {
        if (this.energyHandler.getEnergyStored() > 0) {
            // empty if block
        }
    }

    public void dropXPInWorld(Level worldIn, BlockPos pos) {
        if (this.experienceHandler.getExperienceStored() > 0) {
            // empty if block
        }
    }

    public void dropDustInWorld(Level worldIn, BlockPos pos) {
        if (!this.dustHandler.getDustMagicInTank(0).isEmpty()) {
            // empty if block
        }
    }

    public boolean hasItem() {
        int firstPartialOrNonEmptySlot = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41613_() >= stackInSlot.m_41741_() && !stackInSlot.m_41619_()) continue;
            firstPartialOrNonEmptySlot = i;
            break;
        }
        return !this.itemHandler.getStackInSlot(firstPartialOrNonEmptySlot).m_41619_();
    }

    public Optional<Integer> maybeFirstNonEmptySlot() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public boolean hasItemFirst() {
        return this.maybeFirstNonEmptySlot().isPresent();
    }

    public Optional<Integer> maybeLastNonEmptySlot() {
        for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public Optional<Integer> maybeFirstSlotWithSpaceForMatchingItem(ItemStack stackToMatch) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_() && (stackInSlot.m_41613_() >= stackInSlot.m_41741_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackToMatch))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public boolean hasSpaceForItem(ItemStack stackToMatch) {
        return this.maybeFirstSlotWithSpaceForMatchingItem(stackToMatch).isPresent();
    }

    public ItemStack getItemInPedestal() {
        return this.maybeFirstNonEmptySlot().map(slot -> this.itemHandler.getStackInSlot(slot.intValue())).orElse(ItemStack.f_41583_);
    }

    public ItemStack getMatchingItemInPedestalOrEmptySlot(ItemStack stackToMatch) {
        return this.maybeFirstSlotWithSpaceForMatchingItem(stackToMatch).map(slot -> this.itemHandler.getStackInSlot(slot.intValue())).orElse(ItemStack.f_41583_);
    }

    public ItemStack getItemInPedestalFirst() {
        return this.maybeFirstNonEmptySlot().map(slot -> this.itemHandler.getStackInSlot(slot.intValue())).orElse(ItemStack.f_41583_);
    }

    public int getPedestalSlots() {
        return this.itemHandler.getSlots();
    }

    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> listed = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            listed.add(this.itemHandler.getStackInSlot(i));
        }
        return listed;
    }

    public ItemStack getItemInPedestal(int slot) {
        if (this.itemHandler.getSlots() > slot) {
            return this.itemHandler.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack removeItem(int numToRemove, boolean simulate) {
        return this.maybeLastNonEmptySlot().map(slot -> this.itemHandler.extractItem(slot.intValue(), numToRemove, simulate)).orElse(ItemStack.f_41583_);
    }

    public ItemStack removeItemStack(ItemStack stackToRemove, boolean simulate) {
        int matchingSlotNumber = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.itemHandler.getStackInSlot(i), (ItemStack)stackToRemove)) continue;
            matchingSlotNumber = i;
            break;
        }
        return this.itemHandler.extractItem(matchingSlotNumber, stackToRemove.m_41613_(), simulate);
    }

    public ItemStack removeItem(boolean simulate) {
        return this.maybeLastNonEmptySlot().map(slot -> {
            ItemStack stack = this.itemHandler.extractItem(slot.intValue(), this.itemHandler.getStackInSlot(slot.intValue()).m_41613_(), simulate);
            return stack;
        }).orElse(ItemStack.f_41583_);
    }

    public boolean addItem(ItemStack itemFromBlock, boolean simulate) {
        return this.addItemStack(itemFromBlock, simulate).m_41619_();
    }

    public ItemStack addItemStack(ItemStack itemFromBlock, boolean simulate) {
        return this.maybeFirstSlotWithSpaceForMatchingItem(itemFromBlock).map(slot -> {
            if (this.itemHandler.isItemValid(slot.intValue(), itemFromBlock)) {
                ItemStack returner = this.itemHandler.insertItem(slot.intValue(), itemFromBlock.m_41777_(), simulate);
                if (!simulate) {
                    this.update();
                }
                return returner;
            }
            return itemFromBlock;
        }).orElse(itemFromBlock);
    }

    public int getSlotSizeLimit() {
        return this.maybeFirstNonEmptySlot().map(slot -> this.itemHandler.getSlotLimit(slot.intValue())).orElse(this.itemHandler.getSlotLimit(0));
    }

    public boolean hasFluid() {
        return !this.fluidHandler.getFluidInTank(0).isEmpty();
    }

    public FluidStack getStoredFluid() {
        return this.fluidHandler.getFluidInTank(0);
    }

    public int getFluidCapacity() {
        return this.fluidHandler.getTankCapacity(0);
    }

    public int spaceForFluid() {
        return this.getFluidCapacity() - this.getStoredFluid().getAmount();
    }

    public boolean canAcceptFluid(FluidStack fluidStackIn) {
        return this.fluidHandler.isFluidValid(0, fluidStackIn);
    }

    public FluidStack removeFluid(FluidStack fluidToRemove, IFluidHandler.FluidAction action) {
        return this.fluidHandler.drain(fluidToRemove, action);
    }

    public FluidStack removeFluid(int fluidAmountToRemove, IFluidHandler.FluidAction action) {
        return this.fluidHandler.drain(new FluidStack(this.getStoredFluid().getFluid(), fluidAmountToRemove, this.getStoredFluid().getTag()), action);
    }

    public int addFluid(FluidStack fluidStackIn, IFluidHandler.FluidAction fluidAction) {
        return this.fluidHandler.fill(fluidStackIn, fluidAction);
    }

    public boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    public boolean hasSpaceForEnergy() {
        return this.spaceForEnergy() > 0;
    }

    public int spaceForEnergy() {
        return this.getEnergyCapacity() - this.getStoredEnergy();
    }

    public int getEnergyCapacity() {
        return this.energyHandler.getMaxEnergyStored();
    }

    public int getStoredEnergy() {
        return this.energyHandler.getEnergyStored();
    }

    public int addEnergy(int amountIn, boolean simulate) {
        return this.energyHandler.receiveEnergy(amountIn, simulate);
    }

    public int removeEnergy(int amountOut, boolean simulate) {
        return this.energyHandler.extractEnergy(amountOut, simulate);
    }

    public boolean canAcceptEnergy() {
        return this.energyHandler.canReceive();
    }

    public boolean canSendEnergy() {
        return this.energyHandler.canExtract();
    }

    public boolean hasExperience() {
        return this.experienceHandler.getExperienceStored() > 0;
    }

    public boolean hasSpaceForExperience() {
        return this.spaceForExperience() > 0;
    }

    public int spaceForExperience() {
        return this.getExperienceCapacity() - this.getStoredExperience();
    }

    public int getExperienceCapacity() {
        return this.experienceHandler.getMaxExperienceStored();
    }

    public int getStoredExperience() {
        return this.experienceHandler.getExperienceStored();
    }

    public int addExperience(int amountIn, boolean simulate) {
        return this.experienceHandler.receiveExperience(amountIn, simulate);
    }

    public int removeExperience(int amountOut, boolean simulate) {
        return this.experienceHandler.extractExperience(amountOut, simulate);
    }

    public boolean canAcceptExperience() {
        return this.experienceHandler.canReceive();
    }

    public boolean canSendExperience() {
        return this.experienceHandler.canExtract();
    }

    public boolean hasDust() {
        return !this.dustHandler.getDustMagicInTank(0).isEmpty();
    }

    public DustMagic getStoredDust() {
        if (this.hasDust()) {
            return this.dustHandler.getDustMagicInTank(0);
        }
        return DustMagic.EMPTY;
    }

    public int getDustCapacity() {
        return this.dustHandler.getTankCapacity(0);
    }

    public int spaceForDust() {
        return this.getDustCapacity() - this.getStoredDust().getDustAmount();
    }

    public boolean canAcceptDust(DustMagic dustMagicIn) {
        return this.dustHandler.isDustValid(0, dustMagicIn);
    }

    public DustMagic removeDust(DustMagic dustMagicToRemove, IDustHandler.DustAction action) {
        this.update();
        return this.dustHandler.drain(dustMagicToRemove, action);
    }

    public DustMagic removeDust(int dustAmountToRemove, IDustHandler.DustAction action) {
        this.update();
        return this.dustHandler.drain(new DustMagic(this.getStoredDust().getDustColor(), dustAmountToRemove), action);
    }

    public int addDust(DustMagic dustMagicIn, IDustHandler.DustAction action) {
        this.update();
        return this.dustHandler.fill(dustMagicIn, action);
    }

    @Override
    public void m_142466_(CompoundTag p_155245_) {
        super.m_142466_(p_155245_);
        CompoundTag invTag = p_155245_.m_128469_("inv");
        this.itemHandler.deserializeNBT(invTag);
        this.storedEnergy = p_155245_.m_128451_("storedEnergy");
        this.storedFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)p_155245_.m_128469_("storedFluid"));
        this.storedExperience = p_155245_.m_128451_("storedExperience");
        this.storedDust = DustMagic.getDustMagicInTag(p_155245_);
        this.storedPotionEffect = MobEffectInstance.m_19560_((CompoundTag)p_155245_) != null ? MobEffectInstance.m_19560_((CompoundTag)p_155245_) : null;
        this.storedPotionEffectDuration = p_155245_.m_128451_("storedEffectDuration");
    }

    @Override
    public CompoundTag save(CompoundTag p_58888_) {
        super.save(p_58888_);
        p_58888_.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        p_58888_.m_128405_("storedEnergy", this.storedEnergy);
        p_58888_.m_128365_("storedFluid", (Tag)this.storedFluid.writeToNBT(new CompoundTag()));
        p_58888_.m_128405_("storedExperience", this.storedExperience);
        if (this.storedPotionEffect != null) {
            this.storedPotionEffect.m_19555_(p_58888_);
        }
        p_58888_.m_128405_("storedEffectDuration", this.storedPotionEffectDuration);
        return DustMagic.setDustMagicInTag(p_58888_, this.storedDust);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.itemCapability.invalidate();
        this.energyCapability.invalidate();
        this.fluidCapability.invalidate();
        this.experienceCapability.invalidate();
        this.dustCapability.invalidate();
    }
}

