/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.BlockEntities;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import com.mowmaster.mowlib.api.DefineLocations.IWorkCard;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MowLibBaseFilterableBlockEntity
extends MowLibBaseBlockEntity {
    private ItemStackHandler baseInsertablesHandler = this.createPrivateInsertableItemHandler();
    private List<ItemStack> baseInsertablesStacksList = new ArrayList<ItemStack>();
    private static int insertableHandlerSize = 4;

    public MowLibBaseFilterableBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    private ItemStackHandler createPrivateInsertableItemHandler() {
        return new ItemStackHandler(insertableHandlerSize){

            protected void onLoad() {
                if (this.getSlots() < insertableHandlerSize) {
                    for (int i = 0; i < this.getSlots(); ++i) {
                        MowLibBaseFilterableBlockEntity.this.baseInsertablesStacksList.add(i, this.getStackInSlot(i));
                    }
                    this.setSize(insertableHandlerSize);
                    for (int j = 0; j < MowLibBaseFilterableBlockEntity.this.baseInsertablesStacksList.size(); ++j) {
                        this.setStackInSlot(j, MowLibBaseFilterableBlockEntity.this.baseInsertablesStacksList.get(j));
                    }
                }
                super.onLoad();
            }

            protected void onContentsChanged(int slot) {
                if (MowLibBaseFilterableBlockEntity.this.baseInsertablesStacksList.size() <= 0) {
                    MowLibBaseFilterableBlockEntity.this.update();
                }
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (stack.m_41720_() instanceof IFilterItem && !stack.m_41720_().equals(DeferredRegisterItems.FILTER_BASE.get()) && !MowLibBaseFilterableBlockEntity.this.hasFilter()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (stack.m_41720_() instanceof IWorkCard && !MowLibBaseFilterableBlockEntity.this.hasWorkCard()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> {
                        if (stack.m_150930_(Items.f_42451_) && MowLibBaseFilterableBlockEntity.this.getRedstonePowerNeeded() < 15) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> {
                        if (stack.m_150930_(Items.f_42054_) && !MowLibBaseFilterableBlockEntity.this.hasLight()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }
        };
    }

    public void dropInventoryItemsPrivate(Level worldIn, BlockPos pos) {
        MowLibItemUtils.dropInventoryItems(worldIn, pos, (IItemHandler)this.baseInsertablesHandler);
    }

    public List<ItemStack> dropInventoryItemsPrivateList() {
        ArrayList<ItemStack> returner = new ArrayList<ItemStack>();
        for (int i = 0; i < this.baseInsertablesHandler.getSlots(); ++i) {
            returner.add(this.baseInsertablesHandler.getStackInSlot(i));
        }
        return returner;
    }

    public boolean attemptAddLight(ItemStack stack, @Nullable BlockState newState) {
        if (this.baseInsertablesHandler.isItemValid(3, stack)) {
            this.baseInsertablesHandler.insertItem(3, stack.m_41620_(1), false);
            if (newState != null) {
                this.f_58857_.m_7731_(this.getPos(), newState, 3);
            }
            this.update();
            return true;
        }
        return false;
    }

    public ItemStack removeLight(@Nullable BlockState newState) {
        if (this.hasLight()) {
            ItemStack retItemStack = this.baseInsertablesHandler.extractItem(3, 1, false);
            if (newState != null) {
                this.f_58857_.m_7731_(this.getPos(), newState, 3);
            }
            this.update();
            return retItemStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean hasLight() {
        return !this.baseInsertablesHandler.getStackInSlot(3).m_41619_();
    }

    public void actionOnLightRemovedFromBlockEntity(int type) {
    }

    public boolean hasFilter() {
        return !this.baseInsertablesHandler.getStackInSlot(0).m_41619_();
    }

    public ItemStack getFilterInBlockEntity() {
        return this.baseInsertablesHandler.getStackInSlot(0);
    }

    public IFilterItem getIFilterItem() {
        if (this.hasFilter()) {
            return (IFilterItem)this.getFilterInBlockEntity().m_41720_();
        }
        return null;
    }

    public ItemStack removeFilter(@Nullable BlockState newState) {
        if (newState != null) {
            this.f_58857_.m_7731_(this.getPos(), newState, 3);
            this.update();
        }
        return this.baseInsertablesHandler.extractItem(0, 1, false);
    }

    public boolean attemptAddFilter(ItemStack stack, @Nullable BlockState newState) {
        if (this.baseInsertablesHandler.isItemValid(0, stack)) {
            ItemStack toInsert = stack.m_41620_(1);
            this.baseInsertablesHandler.insertItem(0, toInsert, false);
            if (newState != null) {
                this.f_58857_.m_7731_(this.getPos(), newState, 3);
            }
            this.update();
            return true;
        }
        return false;
    }

    public void actionOnFilterRemovedFromBlockEntity(int type) {
    }

    public boolean hasWorkCard() {
        return !this.baseInsertablesHandler.getStackInSlot(1).m_41619_();
    }

    @Override
    public ItemStack getWorkCard() {
        return this.getWorkCardInPedestal();
    }

    public ItemStack getWorkCardInPedestal() {
        return this.baseInsertablesHandler.getStackInSlot(1);
    }

    public IWorkCard getIWorkCard() {
        if (this.hasWorkCard()) {
            return (IWorkCard)this.getWorkCardInPedestal().m_41720_();
        }
        return null;
    }

    public ItemStack removeWorkCard(@Nullable BlockState newState) {
        if (newState != null) {
            this.f_58857_.m_7731_(this.getPos(), newState, 3);
            this.update();
        }
        return this.baseInsertablesHandler.extractItem(1, 1, false);
    }

    public boolean attemptAddWorkCard(ItemStack stack, @Nullable BlockState newState) {
        if (this.baseInsertablesHandler.isItemValid(1, stack)) {
            this.baseInsertablesHandler.insertItem(1, stack.m_41620_(1), false);
            if (newState != null) {
                this.f_58857_.m_7731_(this.getPos(), newState, 3);
            }
            this.update();
            return true;
        }
        return false;
    }

    public void actionOnWorkCardRemovedFromBlockEntity(int type) {
    }

    public boolean hasRedstone() {
        return !this.baseInsertablesHandler.getStackInSlot(2).m_41619_();
    }

    public boolean attemptAddRedstone(ItemStack stack, @Nullable BlockState newState) {
        if (!this.hasRedstone() || this.getRedstonePowerNeeded() < 15) {
            if (newState != null) {
                this.f_58857_.m_7731_(this.getPos(), newState, 3);
            }
            this.baseInsertablesHandler.insertItem(2, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeRedstone(@Nullable BlockState newState) {
        if (newState != null) {
            this.f_58857_.m_7731_(this.getPos(), newState, 3);
            this.update();
        }
        return this.baseInsertablesHandler.extractItem(2, 1, false);
    }

    public ItemStack removeAllRedstone(@Nullable BlockState newState) {
        if (newState != null) {
            this.f_58857_.m_7731_(this.getPos(), newState, 3);
            this.update();
        }
        return this.baseInsertablesHandler.extractItem(2, this.getRedstonePowerNeeded(), false);
    }

    public int getRedstonePowerNeeded() {
        return this.baseInsertablesHandler.getStackInSlot(2).m_41613_();
    }

    public boolean isPedestalBlockPowered(MowLibBaseFilterableBlockEntity baseFilterableBlockEntity) {
        if (baseFilterableBlockEntity.hasRedstone()) {
            return this.m_58904_().m_276867_(baseFilterableBlockEntity.m_58899_()) ? baseFilterableBlockEntity.getRedstonePower() < baseFilterableBlockEntity.getRedstonePowerNeeded() : true;
        }
        return baseFilterableBlockEntity.getRedstonePower() > 0;
    }

    public int getRedstonePower() {
        return this.m_58904_().m_277086_(this.m_58899_());
    }

    public void actionOnRedstoneRemovedFromBlockEntity(int type) {
    }

    @Override
    public void m_142466_(CompoundTag p_155245_) {
        super.m_142466_(p_155245_);
        CompoundTag invPrivateTag = p_155245_.m_128469_("inv_mowlibfilterable_private");
        this.baseInsertablesHandler.deserializeNBT(invPrivateTag);
    }

    @Override
    public CompoundTag save(CompoundTag p_58888_) {
        p_58888_.m_128365_("inv_mowlibfilterable_private", (Tag)this.baseInsertablesHandler.serializeNBT());
        return super.save(p_58888_);
    }

    private static class PrivateInventorySlot {
        static final int FILTER = 0;
        static final int WORK_CARD = 1;
        static final int REDSTONE = 2;
        static final int LIGHT = 3;

        private PrivateInventorySlot() {
        }
    }
}

