/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.BlockEntities;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlock;
import com.mowmaster.mowlib.BlockEntities.MowLibBaseFilterableBlockEntity;
import com.mowmaster.mowlib.Items.ColorApplicator;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardBE;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import com.mowmaster.mowlib.api.DefineLocations.IWorkCard;
import com.mowmaster.mowlib.api.Tools.IMowLibTool;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class MowLibBaseFilterableBlock
extends MowLibBaseBlock {
    public static final IntegerProperty FILTER_STATUS = IntegerProperty.m_61631_((String)"filter_status", (int)0, (int)2);
    public static final BooleanProperty WORKCARD_STATUS = BooleanProperty.m_61465_((String)"workcard_status");
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final IntegerProperty REDSTONE_STATUS = IntegerProperty.m_61631_((String)"redstone_status", (int)0, (int)15);

    public MowLibBaseFilterableBlock(BlockBehaviour.Properties p_152915_) {
        super(p_152915_);
    }

    public void m_6256_(BlockState p_60499_, Level p_60500_, BlockPos p_60501_, Player p_60502_) {
        if (!p_60500_.m_5776_()) {
            BlockEntity blockEntity;
            if (p_60502_ instanceof FakePlayer) {
                super.m_6256_(p_60499_, p_60500_, p_60501_, p_60502_);
            }
            if ((blockEntity = p_60500_.m_7702_(p_60501_)) instanceof MowLibBaseFilterableBlockEntity) {
                MowLibBaseFilterableBlockEntity baseFilterableBlockEntity = (MowLibBaseFilterableBlockEntity)blockEntity;
                ItemStack itemInHand = p_60502_.m_21205_();
                ItemStack itemInOffHand = p_60502_.m_21206_();
                if (baseFilterableBlockEntity.hasFilter() && itemInOffHand.m_150930_((Item)DeferredRegisterItems.TOOL_FILTERTOOL.get())) {
                    ItemHandlerHelper.giveItemToPlayer((Player)p_60502_, (ItemStack)baseFilterableBlockEntity.removeFilter(null));
                    baseFilterableBlockEntity.actionOnFilterRemovedFromBlockEntity(1);
                } else if (baseFilterableBlockEntity.hasLight() && itemInOffHand.m_150930_(Items.f_42054_)) {
                    ItemHandlerHelper.giveItemToPlayer((Player)p_60502_, (ItemStack)baseFilterableBlockEntity.removeLight(null));
                    baseFilterableBlockEntity.actionOnLightRemovedFromBlockEntity(1);
                } else if (baseFilterableBlockEntity.hasRedstone() && itemInOffHand.m_150930_(Items.f_42451_)) {
                    if (p_60502_.m_6144_()) {
                        ItemHandlerHelper.giveItemToPlayer((Player)p_60502_, (ItemStack)baseFilterableBlockEntity.removeAllRedstone(null));
                    } else {
                        ItemHandlerHelper.giveItemToPlayer((Player)p_60502_, (ItemStack)baseFilterableBlockEntity.removeRedstone(null));
                    }
                    baseFilterableBlockEntity.actionOnRedstoneRemovedFromBlockEntity(1);
                } else if (baseFilterableBlockEntity.hasWorkCard() && itemInOffHand.m_150930_((Item)DeferredRegisterItems.TOOL_WORKTOOL.get())) {
                    baseFilterableBlockEntity.actionOnWorkCardRemovedFromBlockEntity(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)p_60502_, (ItemStack)baseFilterableBlockEntity.removeWorkCard(null));
                }
            }
        }
        super.m_6256_(p_60499_, p_60500_, p_60501_, p_60502_);
    }

    @Override
    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (p_60504_.m_5776_()) {
            ItemStack itemInHand = p_60506_.m_21205_();
            if (itemInHand.m_41720_() instanceof WorkCardBE) {
                return InteractionResult.FAIL;
            }
        } else {
            BlockEntity blockEntity = p_60504_.m_7702_(p_60505_);
            if (blockEntity instanceof MowLibBaseFilterableBlockEntity) {
                MowLibBaseFilterableBlockEntity baseFilterableBlockEntity = (MowLibBaseFilterableBlockEntity)blockEntity;
                ItemStack itemInHand = p_60506_.m_21205_();
                ItemStack itemInOffHand = p_60506_.m_21206_();
                List DYES = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes"))).stream().toList();
                if (itemInHand.m_41720_() instanceof IMowLibTool) {
                    return InteractionResult.FAIL;
                }
                if (p_60506_.m_21120_(p_60507_).m_41720_() instanceof ColorApplicator) {
                    int getColor = MowLibColorReference.getColorFromItemStackInt(p_60506_.m_21120_(p_60507_));
                    int currentColor = MowLibColorReference.getColorFromStateInt(p_60503_);
                    if (currentColor != getColor) {
                        BlockState newState = MowLibColorReference.addColorToBlockState(p_60503_, getColor);
                        p_60504_.m_7731_(p_60505_, newState, 3);
                        return InteractionResult.SUCCESS;
                    }
                    MowLibMessageUtils.messagePlayerChat(p_60506_, ChatFormatting.RED, "mowlib.recolor.message_sameColor");
                    return InteractionResult.FAIL;
                }
                if (itemInOffHand.m_41720_() instanceof IFilterItem) {
                    if (baseFilterableBlockEntity.attemptAddFilter(itemInOffHand, null)) {
                        return InteractionResult.SUCCESS;
                    }
                } else if (itemInOffHand.m_41720_() instanceof IWorkCard) {
                    if (baseFilterableBlockEntity.attemptAddWorkCard(itemInOffHand, null)) {
                        return InteractionResult.SUCCESS;
                    }
                } else if (itemInOffHand.m_41720_().equals(Items.f_42054_)) {
                    if (baseFilterableBlockEntity.attemptAddLight(itemInOffHand, null)) {
                        return InteractionResult.SUCCESS;
                    }
                } else if (itemInOffHand.m_41720_().equals(Items.f_42451_)) {
                    if (baseFilterableBlockEntity.attemptAddRedstone(itemInOffHand, null)) {
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    if (DYES.contains(itemInOffHand.m_41720_())) {
                        int getColor = MowLibColorReference.getColorFromDyeInt(itemInOffHand);
                        int currentColor = MowLibColorReference.getColorFromStateInt(p_60503_);
                        if (currentColor != getColor) {
                            BlockState newState = MowLibColorReference.addColorToBlockState(p_60503_, getColor);
                            p_60504_.m_7731_(p_60505_, newState, 3);
                            return InteractionResult.SUCCESS;
                        }
                        MowLibMessageUtils.messagePlayerChat(p_60506_, ChatFormatting.RED, "mowlib.recolor.message_sameColor");
                        return InteractionResult.FAIL;
                    }
                    if (!itemInHand.m_41619_()) {
                        if (itemInHand.m_41720_() instanceof WorkCardBE) {
                            return InteractionResult.FAIL;
                        }
                    } else {
                        return InteractionResult.FAIL;
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return true;
    }

    public boolean m_7278_(BlockState p_60457_) {
        return true;
    }

    public int m_6782_(BlockState p_60487_, Level p_60488_, BlockPos p_60489_) {
        return super.m_6782_(p_60487_, p_60488_, p_60489_);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void m_6810_(BlockState p_60515_, Level p_60516_, BlockPos p_60517_, BlockState p_60518_, boolean p_60519_) {
        if (p_60515_.m_60734_() != p_60518_.m_60734_()) {
            BlockEntity blockEntity = p_60516_.m_7702_(p_60517_);
            if (blockEntity instanceof MowLibBaseFilterableBlockEntity) {
                MowLibBaseFilterableBlockEntity baseFilterableBlockEntity = (MowLibBaseFilterableBlockEntity)blockEntity;
                baseFilterableBlockEntity.dropInventoryItemsPrivate(p_60516_, p_60517_);
                p_60516_.m_46717_(p_60517_, p_60518_.m_60734_());
            }
            p_60516_.m_7471_(p_60517_, false);
            super.m_6810_(p_60515_, p_60516_, p_60517_, p_60518_, p_60519_);
        }
    }
}

