/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.turtleUpgrades;

import com.hakimen.peripherals.config.Config;
import com.hakimen.peripherals.peripherals.turtle.MagnetTurtlePeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class SolarTurtleUpgrade
implements ITurtleUpgrade {
    ResourceLocation id;
    long lastTime = System.currentTimeMillis();

    public SolarTurtleUpgrade(ResourceLocation id) {
        this.id = id;
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.PERIPHERAL;
    }

    @Nullable
    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new MagnetTurtlePeripheral(turtle, side);
    }

    public ResourceLocation getUpgradeID() {
        return this.id;
    }

    public String getUnlocalisedAdjective() {
        return "upgrade.peripherals.solar.adjective";
    }

    public ItemStack getCraftingItem() {
        return Items.f_42152_.m_7968_();
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
        CompoundTag tag = turtle.getUpgradeNBTData(side);
        if (!turtle.isFuelNeeded()) {
            return;
        }
        if (!turtle.getLevel().f_46443_) {
            boolean isOpenToSky = turtle.getLevel().m_45527_(turtle.getPosition());
            boolean isSunny = !turtle.getLevel().m_46471_() && !turtle.getLevel().m_46470_() && !turtle.getLevel().m_46462_();
            tag.m_128379_("collecting", true);
            if (isSunny && isOpenToSky) {
                if ((double)System.currentTimeMillis() - 1000.0 * (Double)Config.solarChargeRate.get() >= (double)this.lastTime) {
                    turtle.addFuel(1);
                    this.lastTime = System.currentTimeMillis();
                }
            } else {
                tag.m_128379_("collecting", false);
            }
            turtle.updateUpgradeNBTData(side);
        }
    }
}

