/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.peripherals.XPCollectorPeripheral;
import com.hakimen.peripherals.registry.BlockRegister;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPBottlerPeripheral
implements IPeripheral,
IPeripheralProvider {
    @NotNull
    public String getType() {
        return "xp_bottler";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof XPBottlerPeripheral;
    }

    @LuaFunction(mainThread=true)
    public MethodResult bottleXP(IComputerAccess computer, String from, String to, String xp_collector) {
        IPeripheral inputPeripheral = computer.getAvailablePeripheral(from);
        if (inputPeripheral == null) {
            return MethodResult.of((Object[])new Object[]{false, "the input " + from + " was not found"});
        }
        IItemHandler input = XPBottlerPeripheral.extractHandler(inputPeripheral.getTarget());
        IPeripheral xpCollectorPeripheral = computer.getAvailablePeripheral(xp_collector);
        if (xpCollectorPeripheral == null) {
            return MethodResult.of((Object[])new Object[]{false, "the xp collector " + xp_collector + " was not found"});
        }
        IPeripheral outPeripheral = computer.getAvailablePeripheral(to);
        if (outPeripheral == null) {
            return MethodResult.of((Object[])new Object[]{false, "the output " + outPeripheral + " was not found"});
        }
        IItemHandler output = XPBottlerPeripheral.extractHandler(outPeripheral.getTarget());
        XPCollectorPeripheral collector = (XPCollectorPeripheral)xpCollectorPeripheral;
        int xp = collector.tileEntity.xpPoints;
        int bottles = xp / 8;
        if (bottles == 0) {
            return MethodResult.of((Object[])new Object[]{false, "not enough experience in collector"});
        }
        boolean hasSpace = false;
        for (int i = 0; i < output.getSlots(); ++i) {
            if ((output.getStackInSlot(i).m_41613_() >= output.getSlotLimit(i) || !output.getStackInSlot(i).m_41720_().equals(Items.f_42612_.m_7968_().m_41720_())) && !output.getStackInSlot(i).m_41619_()) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            return MethodResult.of((Object[])new Object[]{false, "target inventory doesn't have enough space"});
        }
        block1: for (int bottle = 0; bottle < bottles; ++bottle) {
            int i;
            boolean hasBottle = false;
            for (i = 0; i < input.getSlots(); ++i) {
                if (input.getStackInSlot(i).m_41720_() != Items.f_42590_) continue;
                input.extractItem(i, 1, false);
                hasBottle = true;
                break;
            }
            if (hasBottle) {
                for (i = 0; i < output.getSlots(); ++i) {
                    if ((output.getStackInSlot(i).m_41613_() >= output.getSlotLimit(i) || !output.getStackInSlot(i).m_41720_().equals(Items.f_42612_.m_7968_().m_41720_())) && !output.getStackInSlot(i).m_41619_()) continue;
                    output.insertItem(i, Items.f_42612_.m_7968_(), false);
                    collector.tileEntity.xpPoints -= 8;
                    collector.tileEntity.m_6596_();
                    continue block1;
                }
                continue;
            }
            return MethodResult.of((Object[])new Object[]{false, "no bottles found in input"});
        }
        collector.tileEntity.m_6596_();
        return MethodResult.of((Object)true);
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    @NotNull
    public LazyOptional<IPeripheral> getPeripheral(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction side) {
        if (world.m_8055_(pos).m_60734_().equals(BlockRegister.xpBottler.get())) {
            XPBottlerPeripheral peripheral = new XPBottlerPeripheral();
            return LazyOptional.of(() -> peripheral);
        }
        return LazyOptional.empty();
    }
}

