/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.google.common.collect.ImmutableList;
import com.hakimen.peripherals.blocks.ScannerBlock;
import com.hakimen.peripherals.blocks.tile_entities.ScannerEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.core.util.ArgumentHelpers;
import dan200.computercraft.shared.media.items.PrintoutItem;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScannerPeripheral
implements IPeripheral,
IPeripheralProvider {
    ScannerEntity entity;

    public String getType() {
        return "scanner";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public Types getStackType() {
        ItemStack stack = this.entity.inventory.getStackInSlot(0);
        if (stack.m_41720_() instanceof WrittenBookItem) {
            return Types.WRITTEN_AND_SIGNED_BOOK;
        }
        if (stack.m_41720_() instanceof WritableBookItem) {
            return Types.WRITTEN_BOOK;
        }
        if (stack.m_41720_() instanceof PrintoutItem) {
            return Types.PRINTED;
        }
        return Types.NONE;
    }

    public static void loadPages(CompoundTag baseTag, Consumer<String> stringConsumer) {
        IntFunction<Object> intPageMapper;
        ListTag pagesTag = baseTag.m_128437_("pages", 8).m_6426_();
        if (Minecraft.m_91087_().m_167974_() && baseTag.m_128425_("filtered_pages", 10)) {
            CompoundTag filteredPagesTag = baseTag.m_128469_("filtered_pages");
            intPageMapper = pageNumber -> {
                String value = String.valueOf(pageNumber);
                return filteredPagesTag.m_128441_(value) ? filteredPagesTag.m_128461_(value) : pagesTag.m_128778_(pageNumber);
            };
        } else {
            Objects.requireNonNull(pagesTag);
            intPageMapper = arg_0 -> ((ListTag)pagesTag).m_128778_(arg_0);
        }
        for (int idx = 0; idx < pagesTag.size(); ++idx) {
            stringConsumer.accept((String)intPageMapper.apply(idx));
        }
    }

    static List<String> loadPages(CompoundTag tag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        ScannerPeripheral.loadPages(tag, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private static List<String> readPagesWrittenBook(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && WrittenBookItem.m_43471_((CompoundTag)tag) ? ScannerPeripheral.loadPages(tag) : ImmutableList.of((Object)Component.Serializer.m_130703_((Component)Component.m_237115_((String)"book.invalid.tag").m_130940_(ChatFormatting.DARK_RED)));
    }

    private static List<String> readPagesWritableBook(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && WritableBookItem.m_43452_((CompoundTag)tag) ? ScannerPeripheral.loadPages(tag) : ImmutableList.of((Object)Component.Serializer.m_130703_((Component)Component.m_237115_((String)"book.invalid.tag").m_130940_(ChatFormatting.DARK_RED)));
    }

    public FormattedText getPageRaw(List<String> pages, int page) {
        String temp = pages.get(page);
        try {
            MutableComponent parsedText = Component.Serializer.m_130701_((String)temp);
            if (parsedText != null) {
                return parsedText;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FormattedText.m_130775_((String)temp);
    }

    @LuaFunction
    public MethodResult getPage(int page) throws LuaException {
        --page;
        ItemStack stack = this.entity.inventory.getStackInSlot(0);
        if (stack.equals(ItemStack.f_41583_)) {
            return MethodResult.of((Object[])new Object[]{false, "No Book"});
        }
        switch (this.getStackType()) {
            case PRINTED: {
                int pages = PrintoutItem.getPageCount((ItemStack)stack);
                ArgumentHelpers.assertBetween((int)page, (int)0, (int)pages, (String)"Expected page number to be %s");
                String[] text = PrintoutItem.getText((ItemStack)stack);
                return MethodResult.of((Object[])new Object[]{true, text[page]});
            }
            case WRITTEN_AND_SIGNED_BOOK: {
                List<String> bookText = ScannerPeripheral.readPagesWrittenBook(stack);
                int pages = WrittenBookItem.m_43477_((ItemStack)stack);
                ArgumentHelpers.assertBetween((int)page, (int)0, (int)pages, (String)"Expected page number to be %s");
                return MethodResult.of((Object[])new Object[]{true, this.getPageRaw(bookText, page).getString()});
            }
            case WRITTEN_BOOK: {
                List<String> bookText = ScannerPeripheral.readPagesWritableBook(stack);
                int pages = bookText.size();
                ArgumentHelpers.assertBetween((int)page, (int)0, (int)pages, (String)"Expected page number to be %s");
                return MethodResult.of((Object[])new Object[]{true, FormattedText.m_130775_((String)bookText.get(page)).getString()});
            }
        }
        return MethodResult.of((Object[])new Object[]{false, "No scannable on scanner"});
    }

    @LuaFunction
    public MethodResult getAuthor() {
        ItemStack stack = this.entity.inventory.getStackInSlot(0);
        if (stack.equals(ItemStack.f_41583_)) {
            return MethodResult.of((Object[])new Object[]{false, "No Book"});
        }
        if (Objects.requireNonNull(this.getStackType()) == Types.WRITTEN_AND_SIGNED_BOOK) {
            return MethodResult.of((Object[])new Object[]{true, stack.m_41784_().m_128461_("author")});
        }
        return MethodResult.of((Object[])new Object[]{false, "No author"});
    }

    @LuaFunction
    public MethodResult getTitle() {
        ItemStack stack = this.entity.inventory.getStackInSlot(0);
        if (stack.equals(ItemStack.f_41583_)) {
            return MethodResult.of((Object[])new Object[]{false, "No Book"});
        }
        switch (this.getStackType()) {
            case WRITTEN_AND_SIGNED_BOOK: {
                return MethodResult.of((Object[])new Object[]{true, stack.m_41784_().m_128461_("title")});
            }
            case PRINTED: {
                return MethodResult.of((Object[])new Object[]{true, PrintoutItem.getTitle((ItemStack)stack)});
            }
        }
        return MethodResult.of((Object[])new Object[]{false, "No Title"});
    }

    @LuaFunction
    public MethodResult getCopyStatus() {
        ItemStack stack = this.entity.inventory.getStackInSlot(0);
        switch (this.getStackType()) {
            case WRITTEN_AND_SIGNED_BOOK: {
                return MethodResult.of((Object[])new Object[]{true, (new String[]{"ORIGINAL", "COPY", "COPY OF COPY"})[WrittenBookItem.m_43473_((ItemStack)stack)]});
            }
        }
        return MethodResult.of((Object[])new Object[]{false, "Not a Written Book"});
    }

    @NotNull
    public LazyOptional<IPeripheral> getPeripheral(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction side) {
        if (world.m_8055_(pos).m_60734_() instanceof ScannerBlock) {
            ScannerPeripheral playerInt = new ScannerPeripheral();
            playerInt.entity = (ScannerEntity)world.m_7702_(pos);
            return LazyOptional.of(() -> playerInt);
        }
        return LazyOptional.empty();
    }

    static enum Types {
        WRITTEN_BOOK,
        PRINTED,
        WRITTEN_AND_SIGNED_BOOK,
        NONE;

    }
}

