/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.PlayerInterfaceBlock;
import com.hakimen.peripherals.blocks.tile_entities.PlayerInterfaceEntity;
import com.hakimen.peripherals.items.PlayerCardItem;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.core.util.ArgumentHelpers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInterfacePeripheral
implements IPeripheral,
IPeripheralProvider {
    PlayerInterfaceEntity entity;

    public String getType() {
        return "player_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public boolean hasCard() {
        return this.entity.inventory.getStackInSlot(0).m_41720_() instanceof PlayerCardItem;
    }

    public boolean cardIsBound() {
        return this.entity.inventory.getStackInSlot(0).m_41784_().m_128425_("Owner", 8);
    }

    public Player getPlayer() {
        UUID ownerUUID = this.entity.inventory.getStackInSlot(0).m_41784_().m_128342_("Bind");
        ServerPlayer player = this.entity.m_58904_().m_7654_().m_6846_().m_11259_(ownerUUID);
        return player;
    }

    public Inventory getInventory() {
        UUID ownerUUID = this.entity.inventory.getStackInSlot(0).m_41784_().m_128342_("Bind");
        ServerPlayer player = this.entity.m_58904_().m_7654_().m_6846_().m_11259_(ownerUUID);
        return player != null ? player.m_150109_() : null;
    }

    @LuaFunction(mainThread=true)
    public MethodResult getPlayerInfo() {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Player player = this.getPlayer();
        if (player == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", player.m_5446_().getString());
        data.put("uuid", player.m_20148_().toString());
        HashMap<String, Double> playerPos = new HashMap<String, Double>();
        playerPos.put("x", player.m_20185_());
        playerPos.put("y", player.m_20186_());
        playerPos.put("z", player.m_20189_());
        data.put("pos", playerPos);
        HashMap<String, Number> hungerData = new HashMap<String, Number>();
        hungerData.put("hunger", player.m_36324_().m_38702_());
        hungerData.put("saturation", Float.valueOf(player.m_36324_().m_38722_()));
        data.put("hunger", hungerData);
        data.put("yaw", Float.valueOf(player.m_5675_(1.0f)));
        data.put("pitch", Float.valueOf(player.m_5686_(1.0f)));
        HashMap effects = new HashMap();
        for (MobEffectInstance effect : player.m_21220_()) {
            HashMap<String, Integer> currentEffect = new HashMap<String, Integer>();
            currentEffect.put("duration", effect.m_19557_() / 20);
            currentEffect.put("amplifier", effect.m_19564_());
            effects.put(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect.m_19544_()).toString(), currentEffect);
        }
        data.put("effects", effects);
        data.put("dimension", player.m_9236_().m_46472_().m_135782_().toString());
        return MethodResult.of(data);
    }

    @LuaFunction(mainThread=true)
    public MethodResult getEquipment() {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Player player = this.getPlayer();
        if (player == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        HashMap<String, Map> allEquipment = new HashMap<String, Map>();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (player.m_6844_(equipmentSlot).m_41619_()) continue;
            allEquipment.put(equipmentSlot.m_20751_(), VanillaDetailRegistries.ITEM_STACK.getDetails((Object)player.m_6844_(equipmentSlot)));
        }
        return MethodResult.of(allEquipment);
    }

    @LuaFunction(mainThread=true)
    public MethodResult list() {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Inventory inventory = this.getInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        HashMap<Integer, Map> result = new HashMap<Integer, Map>();
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
        }
        return MethodResult.of(result);
    }

    @LuaFunction(mainThread=true)
    public MethodResult size() {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Inventory inventory = this.getInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        return MethodResult.of((Object)inventory.m_6643_());
    }

    @javax.annotation.Nullable
    @LuaFunction(mainThread=true)
    public MethodResult getItemDetail(int slot) throws LuaException {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Inventory inventory = this.getInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.m_6643_(), (String)"Slot out of range (%s)");
        ItemStack stack = inventory.m_8020_(slot - 1);
        return MethodResult.of((Object)(stack.m_41619_() ? Boolean.valueOf(false) : VanillaDetailRegistries.ITEM_STACK.getDetails((Object)stack)));
    }

    @LuaFunction(mainThread=true)
    public MethodResult getItemLimit(int slot) throws LuaException {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Inventory inventory = this.getInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.m_6643_(), (String)"Slot out of range (%s)");
        return MethodResult.of((Object)inventory.m_8020_(slot - 1).m_41741_());
    }

    @LuaFunction(mainThread=true)
    public MethodResult pushItems(IComputerAccess computer, String toName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        ItemStack inserted;
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Inventory inventory = this.getInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = this.extractHandler(location.getTarget());
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween((int)fromSlot, (int)1, (int)36, (String)"From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween((int)toSlot.get(), (int)1, (int)to.getSlots(), (String)"To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return MethodResult.of((Object)0);
        }
        ItemStack extracted = inventory.m_7407_(fromSlot - 1, limit.orElse(1).intValue());
        if (toSlot.isPresent() && to.isItemValid(toSlot.get().intValue(), extracted)) {
            ItemStack inserted2 = to.insertItem(toSlot.get() - 1, extracted, false);
            if (inserted2.m_41613_() == 0) {
                return MethodResult.of((Object)extracted.m_41613_());
            }
            inventory.m_36054_(inserted2);
            return MethodResult.of((Object[])new Object[]{false, "Couldn't move items to slot " + (toSlot.get() - 1)});
        }
        for (int i = 0; i < to.getSlots() && (inserted = to.insertItem(i, extracted, false)).m_41613_() != 0; ++i) {
            if (i != to.getSlots() - 1 || inserted.m_41613_() <= 0) continue;
            inventory.m_36054_(inserted);
            return MethodResult.of((Object[])new Object[]{false, "Couldn't move items"});
        }
        return MethodResult.of((Object)extracted.m_41613_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction(mainThread=true)
    public MethodResult pullItems(IComputerAccess computer, String fromName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Inventory inventory = this.getInventory();
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IItemHandler from = this.extractHandler(location.getTarget());
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween((int)fromSlot, (int)1, (int)from.getSlots(), (String)"From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween((int)toSlot.get(), (int)1, (int)36, (String)"To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return MethodResult.of((Object)0);
        }
        ItemStack extracted = from.extractItem(fromSlot - 1, limit.orElse(1).intValue(), true);
        int count = extracted.m_41613_();
        if (!this.canAddItem(inventory, extracted)) return MethodResult.of((Object[])new Object[]{false, "Player inventory is full"});
        extracted = from.extractItem(fromSlot - 1, limit.orElse(1).intValue(), false);
        if (toSlot.isPresent()) {
            ItemStack itemInSlot = inventory.m_8020_(toSlot.get() - 1);
            boolean canPlace = false;
            ItemStack placeStack = ItemStack.f_41583_;
            if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)ItemStack.f_41583_)) {
                canPlace = true;
                placeStack = extracted;
            } else if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)extracted) && itemInSlot.m_41613_() + extracted.m_41613_() <= itemInSlot.m_41741_()) {
                canPlace = true;
                placeStack = itemInSlot;
                placeStack.m_41764_(itemInSlot.m_41613_() + extracted.m_41613_());
            }
            if (!canPlace) return MethodResult.of((Object[])new Object[]{false, "Couldn't move items to slot " + toSlot.get()});
            inventory.m_6836_(toSlot.get() - 1, placeStack);
            return MethodResult.of((Object)count);
        } else {
            inventory.m_36054_(extracted);
        }
        return MethodResult.of((Object)count);
    }

    @LuaFunction(mainThread=true)
    public MethodResult consume(int slot) throws LuaException {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Player player = this.getPlayer();
        Inventory inventory = this.getInventory();
        if (player == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)inventory.m_6643_(), (String)"From slot out of range (%s)");
        if (inventory.m_8020_(slot - 1).m_41720_().m_41472_()) {
            player.m_5584_(player.m_9236_(), inventory.m_8020_(slot - 1));
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object[])new Object[]{false, "Item isn't edible"});
    }

    @LuaFunction
    public MethodResult lookAt(double x, double y, double z) {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Player player = this.getPlayer();
        if (player == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        player.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(x, y, z));
        return MethodResult.of((Object)true);
    }

    @LuaFunction
    public MethodResult displayMessage(String msg, Optional<Boolean> tooltipFlag) {
        if (!this.hasCard()) {
            return MethodResult.of((Object[])new Object[]{false, "No card present"});
        }
        if (!this.cardIsBound()) {
            return MethodResult.of((Object[])new Object[]{false, "Card isn't bound"});
        }
        Player player = this.getPlayer();
        if (player == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player isn't present"});
        }
        player.m_5661_((Component)Component.m_237113_((String)msg), tooltipFlag.orElse(false).booleanValue());
        return MethodResult.of((Object)true);
    }

    public boolean canAddItem(Inventory inventory, ItemStack p_19184_) {
        boolean flag = false;
        for (ItemStack itemstack : inventory.f_35974_) {
            if (!itemstack.m_41619_() && (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)p_19184_) || itemstack.m_41613_() >= itemstack.m_41741_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @javax.annotation.Nullable
    private IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    @NotNull
    public LazyOptional<IPeripheral> getPeripheral(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction side) {
        if (world.m_8055_(pos).m_60734_() instanceof PlayerInterfaceBlock) {
            PlayerInterfacePeripheral playerInt = new PlayerInterfacePeripheral();
            playerInt.entity = (PlayerInterfaceEntity)world.m_7702_(pos);
            return LazyOptional.of(() -> playerInt);
        }
        return LazyOptional.empty();
    }
}

