/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.MagneticCardManiputalorEntity;
import com.hakimen.peripherals.registry.BlockRegister;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagneticCardManiputalorPeripheral
implements IPeripheral,
IPeripheralProvider {
    private MagneticCardManiputalorEntity tileEntity;

    @NotNull
    public String getType() {
        return "magnetic_card_manipulator";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public void attach(@NotNull IComputerAccess computer) {
        super.attach(computer);
        this.tileEntity.computers.add(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        super.detach(computer);
        this.tileEntity.computers.remove(computer);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult readCard() {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            return MethodResult.of((Object)this.tileEntity.inventory.getStackInSlot(0).m_41784_().m_128461_("data"));
        }
        return MethodResult.of((Object[])new Object[]{false, "no card found"});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult writeCard(String data) {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            if (!data.isEmpty()) {
                this.tileEntity.inventory.getStackInSlot(0).m_41784_().m_128359_("data", data);
            } else if (this.tileEntity.inventory.getStackInSlot(0).m_41784_().m_128441_("data")) {
                this.tileEntity.inventory.getStackInSlot(0).m_41784_().m_128473_("data");
            }
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object[])new Object[]{false, "no card found"});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasCard() {
        return MethodResult.of((Object)(!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_) ? 1 : 0));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult ejectCard(IComputerAccess computer) {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            this.tileEntity.m_58904_().m_7967_((Entity)new ItemEntity(this.tileEntity.m_58904_(), (double)this.tileEntity.m_58899_().m_123341_() + 0.5, (double)this.tileEntity.m_58899_().m_123342_() + 0.5, (double)this.tileEntity.m_58899_().m_123343_() + 0.5, this.tileEntity.inventory.extractItem(0, 1, false)));
            computer.queueEvent("card_remove", new Object[0]);
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object)false);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult setLabel(String label) {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            if (label.equals("")) {
                this.tileEntity.inventory.getStackInSlot(0).m_41787_();
            } else {
                this.tileEntity.inventory.getStackInSlot(0).m_41714_((Component)Component.m_237113_((String)label));
            }
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object)false);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getLabel() {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            return MethodResult.of((Object)this.tileEntity.inventory.getStackInSlot(0).m_41786_().getString());
        }
        return MethodResult.of((Object[])new Object[]{false, "no card found"});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult setSecure(boolean sensibility) {
        if (!this.tileEntity.inventory.getStackInSlot(0).m_41720_().equals(Items.f_41852_)) {
            this.tileEntity.inventory.getStackInSlot(0).m_41784_().m_128379_("sensible", sensibility);
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object[])new Object[]{false, "no card found"});
    }

    public LazyOptional<IPeripheral> getPeripheral(Level world, BlockPos pos, Direction side) {
        if (world.m_8055_(pos).m_60734_().equals(BlockRegister.magneticCardManipulator.get())) {
            MagneticCardManiputalorPeripheral peripheral = new MagneticCardManiputalorPeripheral();
            peripheral.tileEntity = (MagneticCardManiputalorEntity)world.m_7702_(pos);
            return LazyOptional.of(() -> peripheral);
        }
        return LazyOptional.empty();
    }
}

