/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoomInterfacePeripheral
implements IPeripheral,
IPeripheralProvider {
    @NotNull
    public String getType() {
        return "loom_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction(mainThread=true)
    public MethodResult paintBanner(IComputerAccess computer, String from, int slotBanner, int slotDye, int pattern) {
        IPeripheral inputPeripheral = computer.getAvailablePeripheral(from);
        if (inputPeripheral == null) {
            return MethodResult.of((Object[])new Object[]{false, "the input " + from + " was not found"});
        }
        IItemHandler input = LoomInterfacePeripheral.extractHandler(inputPeripheral.getTarget());
        --slotDye;
        if (--slotBanner < 0 || slotBanner > input.getSlots()) {
            return MethodResult.of((Object[])new Object[]{false, "banner slot out of range"});
        }
        if (slotDye < 0 || slotDye > input.getSlots()) {
            return MethodResult.of((Object[])new Object[]{false, "dye slot out of range"});
        }
        ItemStack banner = input.getStackInSlot(slotBanner);
        ItemStack dye = input.getStackInSlot(slotDye);
        if (!(banner.m_41720_() instanceof BannerItem)) {
            return MethodResult.of((Object[])new Object[]{false, "the item in " + slotBanner + " is not a banner"});
        }
        if (!(dye.m_41720_() instanceof DyeItem)) {
            return MethodResult.of((Object[])new Object[]{false, "the item in " + slotDye + " is not a dye"});
        }
        if (dye.m_41613_() < banner.m_41613_()) {
            return MethodResult.of((Object[])new Object[]{false, "not enough dye"});
        }
        if (--pattern > BuiltInRegistries.f_256878_.m_123024_().toList().size() || pattern < 0) {
            return MethodResult.of((Object[])new Object[]{false, "invalid pattern, value was " + (pattern + 1) + " expected a value between 1 and " + BuiltInRegistries.f_256878_.m_123024_().toList().size()});
        }
        CompoundTag patternTag = new CompoundTag();
        patternTag.m_128359_("Pattern", ((BannerPattern)BuiltInRegistries.f_256878_.m_123024_().toList().get(pattern)).m_58579_());
        patternTag.m_128405_("Color", DyeColor.getColor((ItemStack)dye).m_41060_());
        input.extractItem(slotDye, banner.m_41613_(), false);
        ListTag ListPatterns = new ListTag();
        CompoundTag blockEntityData = BlockItem.m_186336_((ItemStack)banner);
        if (blockEntityData != null && blockEntityData.m_128425_("Patterns", 9)) {
            ListPatterns = blockEntityData.m_128437_("Patterns", 10);
        } else {
            ListPatterns = new ListTag();
            if (blockEntityData == null) {
                blockEntityData = new CompoundTag();
            }
            blockEntityData.m_128365_("Patterns", (Tag)ListPatterns);
        }
        ListPatterns.add((Object)patternTag);
        BlockItem.m_186338_((ItemStack)banner, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)blockEntityData);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public MethodResult clearBanner(IComputerAccess computer, String from, int slot) {
        IPeripheral inputPeripheral = computer.getAvailablePeripheral(from);
        if (inputPeripheral == null) {
            return MethodResult.of((Object[])new Object[]{false, "the input " + from + " was not found"});
        }
        IItemHandler input = LoomInterfacePeripheral.extractHandler(inputPeripheral.getTarget());
        if (--slot < 0 || slot > input.getSlots()) {
            return MethodResult.of((Object[])new Object[]{false, "slot out of range"});
        }
        ItemStack banner = input.getStackInSlot(slot);
        if (!(banner.m_41720_() instanceof BannerItem)) {
            return MethodResult.of((Object[])new Object[]{false, "not a banner"});
        }
        BlockItem.m_186338_((ItemStack)banner, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)new CompoundTag());
        return MethodResult.of((Object)true);
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        int inserted;
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.m_41619_()) {
            return 0;
        }
        int extractCount = Math.min(extracted.m_41613_(), limit);
        extracted.m_41764_(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int n = inserted = remainder.m_41619_() ? extractCount : extractCount - remainder.m_41613_();
        if (inserted <= 0) {
            return 0;
        }
        from.extractItem(fromSlot, inserted, false);
        return inserted;
    }

    @NotNull
    public LazyOptional<IPeripheral> getPeripheral(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction side) {
        if (world.m_8055_(pos).m_60734_().equals(Blocks.f_50617_)) {
            return LazyOptional.of(() -> this);
        }
        return LazyOptional.empty();
    }
}

