/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.client.containers.CrafterContainer;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrafterPeripheral
implements IPeripheral,
IPeripheralProvider {
    private Level level;

    @NotNull
    public String getType() {
        return "crafter";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult craft(IComputerAccess computer, String fromName, String toName, Map<?, ?> craftingParameters) {
        int i;
        IPeripheral from = computer.getAvailablePeripheral(fromName);
        if (from == null) {
            return MethodResult.of((Object[])new Object[]{false, "the input " + fromName + " was not found"});
        }
        IItemHandler fromHandler = CrafterPeripheral.extractHandler(from.getTarget());
        IPeripheral to = computer.getAvailablePeripheral(toName);
        if (to == null) {
            return MethodResult.of((Object[])new Object[]{false, "the output " + toName + " was not found"});
        }
        IItemHandler toHandler = CrafterPeripheral.extractHandler(to.getTarget());
        CrafterContainer container = new CrafterContainer();
        ArrayList<ItemStack> remainders = new ArrayList<ItemStack>();
        HashMap<Integer, Integer> slotsCounts = new HashMap<Integer, Integer>();
        for (i = 0; i < craftingParameters.keySet().size(); ++i) {
            Number slot;
            Object value = craftingParameters.keySet().toArray()[i];
            if (!(value instanceof Number)) continue;
            Number number = (Number)value;
            Object obj = craftingParameters.get(value);
            if (!(obj instanceof Number) || (slot = (Number)obj).intValue() == 0) continue;
            ItemStack stack = fromHandler.getStackInSlot(slot.intValue() - 1);
            if (slotsCounts.containsKey(slot.intValue())) {
                slotsCounts.put(slot.intValue(), (Integer)slotsCounts.get(slot.intValue()) + 1);
            } else {
                slotsCounts.put(slot.intValue(), 1);
            }
            if (stack.m_41720_().m_41470_()) {
                remainders.add(stack.m_41720_().m_41469_().m_7968_());
            }
            container.m_6836_(number.intValue() - 1, stack);
        }
        for (i = 0; i < slotsCounts.keySet().size(); ++i) {
            Integer k = (Integer)slotsCounts.keySet().stream().toList().get(i);
            Integer v = (Integer)slotsCounts.values().stream().toList().get(i);
            if (fromHandler.getStackInSlot(k - 1).m_41613_() >= v) continue;
            return MethodResult.of((Object[])new Object[]{false, "Not enough resources on slot %d to craft".formatted(k)});
        }
        boolean placed = false;
        boolean canPlaceAllRemainders = true;
        Optional recipe = this.level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)container, this.level);
        if (recipe.isPresent()) {
            for (int i2 = 0; i2 < toHandler.getSlots(); ++i2) {
                int j;
                ItemStack assemble = ((CraftingRecipe)recipe.get()).m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
                ItemStack stack = toHandler.insertItem(i2, assemble, true);
                if (!stack.m_41619_()) continue;
                placed = true;
                toHandler.insertItem(i2, assemble, false);
                for (j = 0; j < remainders.size(); ++j) {
                    ItemStack stack2;
                    int k;
                    for (k = 0; k < fromHandler.getSlots(); ++k) {
                        stack2 = fromHandler.insertItem(k, (ItemStack)remainders.get(k), true);
                        if (stack2.m_41619_()) continue;
                        canPlaceAllRemainders = false;
                        break;
                    }
                    if (!canPlaceAllRemainders) break;
                    for (k = 0; k < fromHandler.getSlots() && !(stack2 = fromHandler.insertItem(k, (ItemStack)remainders.get(k), false)).m_41619_(); ++k) {
                    }
                }
                if (!placed) continue;
                for (j = 0; j < craftingParameters.keySet().size(); ++j) {
                    Number slot;
                    Object value = craftingParameters.keySet().toArray()[j];
                    Object obj = craftingParameters.get(value);
                    if (!(obj instanceof Number) || (slot = (Number)obj).intValue() == 0) continue;
                    fromHandler.extractItem(slot.intValue() - 1, 1, false);
                }
                break;
            }
            if (!placed && !canPlaceAllRemainders) {
                return MethodResult.of((Object[])new Object[]{false, "failed to Craft"});
            }
        }
        return MethodResult.of((Object)true);
    }

    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    @NotNull
    public LazyOptional<IPeripheral> getPeripheral(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction side) {
        this.level = world;
        if (world.m_8055_(pos).m_60734_().equals(Blocks.f_50091_)) {
            return LazyOptional.of(() -> this);
        }
        return LazyOptional.empty();
    }
}

