/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilPeripheral
implements IPeripheral,
IPeripheralProvider {
    @NotNull
    public String getType() {
        return "anvil_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction(mainThread=true)
    public MethodResult combine(IComputerAccess computer, String from, int fromSlot, String resource, int resourceSlot, String xpSource) {
        int i = 0;
        int j = 0;
        int k = 0;
        if (from.matches(resource) && --fromSlot == --resourceSlot) {
            return MethodResult.of((Object[])new Object[]{false, "Can't combine item with itself"});
        }
        IPeripheral input = computer.getAvailablePeripheral(from);
        if (input == null) {
            return MethodResult.of((Object[])new Object[]{false, "the input " + from + " was not found"});
        }
        IItemHandler inputHandler = AnvilPeripheral.extractHandler(input.getTarget());
        if (fromSlot < 0 || fromSlot > inputHandler.getSlots()) {
            return MethodResult.of((Object[])new Object[]{false, "from slot out of range"});
        }
        ItemStack itemstack = inputHandler.getStackInSlot(fromSlot);
        IPeripheral resourcesInput = computer.getAvailablePeripheral(resource);
        if (resourcesInput == null) {
            return MethodResult.of((Object[])new Object[]{false, "the resources input " + resource + " was not found"});
        }
        IItemHandler resourcesInputHandler = AnvilPeripheral.extractHandler(resourcesInput.getTarget());
        if (resourceSlot < 0 || resourceSlot > resourcesInputHandler.getSlots()) {
            return MethodResult.of((Object[])new Object[]{false, "resource slot out of range"});
        }
        ItemStack itemstack2 = resourcesInputHandler.getStackInSlot(resourceSlot);
        IPeripheral xpInput = computer.getAvailablePeripheral(xpSource);
        if (xpInput == null) {
            return MethodResult.of((Object[])new Object[]{false, "the xp input " + xpSource + " was not found"});
        }
        IItemHandler xpInputHandler = AnvilPeripheral.extractHandler(xpInput.getTarget());
        int bottlesNeeded = 8;
        int xpSlot = -1;
        for (int m = 0; m < xpInputHandler.getSlots(); ++m) {
            if (!xpInputHandler.getStackInSlot(m).m_150930_(Items.f_42612_) || xpInputHandler.getStackInSlot(m).m_41613_() < bottlesNeeded) continue;
            xpSlot = m;
            break;
        }
        if (xpSlot < 0) {
            return MethodResult.of((Object[])new Object[]{false, "not enough bottles found"});
        }
        ItemStack itemstack1 = itemstack.m_41777_();
        Map map = EnchantmentHelper.m_44831_((ItemStack)itemstack1);
        j += itemstack.m_41610_() + (itemstack2.m_41619_() ? 0 : itemstack2.m_41610_());
        int repairItemCountCost = 0;
        boolean flag = false;
        boolean bl = flag = itemstack2.m_41720_() == Items.f_42690_ && !EnchantedBookItem.m_41163_((ItemStack)itemstack2).isEmpty();
        if (itemstack1.m_41763_() && itemstack1.m_41720_().m_6832_(itemstack, itemstack2)) {
            int i3;
            int l2 = Math.min(itemstack1.m_41773_(), itemstack1.m_41776_() / 4);
            if (l2 <= 0) {
                return MethodResult.of((Object[])new Object[]{false, "item doesn't need repairing"});
            }
            for (i3 = 0; l2 > 0 && i3 < itemstack2.m_41613_(); ++i3) {
                int j3 = itemstack1.m_41773_() - l2;
                itemstack1.m_41721_(j3);
                ++i;
                l2 = Math.min(itemstack1.m_41773_(), itemstack1.m_41776_() / 4);
            }
            repairItemCountCost = i3;
        } else {
            if (!(flag || itemstack1.m_150930_(itemstack2.m_41720_()) && itemstack1.m_41763_())) {
                return MethodResult.of((Object[])new Object[]{false, "Item can't be combined this way"});
            }
            if (itemstack1.m_41763_() && !flag) {
                int l = itemstack.m_41776_() - itemstack.m_41773_();
                int i1 = itemstack2.m_41776_() - itemstack2.m_41773_();
                int j1 = i1 + itemstack1.m_41776_() * 12 / 100;
                int k1 = l + j1;
                int l1 = itemstack1.m_41776_() - k1;
                if (l1 < 0) {
                    l1 = 0;
                }
                if (l1 < itemstack1.m_41773_()) {
                    itemstack1.m_41721_(l1);
                    i += 2;
                }
            }
            Map map1 = EnchantmentHelper.m_44831_((ItemStack)itemstack2);
            boolean flag2 = false;
            boolean flag3 = false;
            for (Enchantment enchantment1 : map1.keySet()) {
                int j2;
                if (enchantment1 == null) continue;
                int i2 = map.getOrDefault(enchantment1, 0);
                j2 = i2 == (j2 = ((Integer)map1.get(enchantment1)).intValue()) ? j2 + 1 : Math.max(j2, i2);
                boolean flag1 = enchantment1.m_6081_(itemstack);
                if (itemstack.m_150930_(Items.f_42690_)) {
                    flag1 = true;
                }
                for (Enchantment enchantment : map.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.m_44695_(enchantment)) continue;
                    flag1 = false;
                    ++i;
                }
                if (!flag1) {
                    flag3 = true;
                    continue;
                }
                flag2 = true;
                if (j2 > enchantment1.m_6586_()) {
                    j2 = enchantment1.m_6586_();
                }
                map.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.m_44699_()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
                if (flag) {
                    k3 = Math.max(1, k3 / 2);
                }
                i += k3 * j2;
                if (itemstack.m_41613_() <= 1) continue;
                i = 40;
            }
            if (flag3 && !flag2) {
                return MethodResult.of((Object[])new Object[]{false, "enchantments are not compatible"});
            }
        }
        if (flag && !itemstack1.isBookEnchantable(itemstack2)) {
            return MethodResult.of((Object[])new Object[]{false, "item is not enchantable with this book"});
        }
        int k2 = itemstack1.m_41610_();
        if (!itemstack2.m_41619_() && k2 < itemstack2.m_41610_()) {
            k2 = itemstack2.m_41610_();
        }
        if (k != i || k == 0) {
            k2 = AnvilMenu.m_39025_((int)k2);
        }
        itemstack1.m_41742_(k2);
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack1);
        inputHandler.extractItem(fromSlot, 1, false);
        resourcesInputHandler.extractItem(resourceSlot, 1, false);
        xpInputHandler.extractItem(xpSlot, 8, false);
        inputHandler.insertItem(fromSlot, itemstack1, false);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public MethodResult rename(IComputerAccess computer, String from, int slot, String name) throws LuaException {
        --slot;
        IPeripheral input = computer.getAvailablePeripheral(from);
        if (input == null) {
            return MethodResult.of((Object[])new Object[]{false, "the input " + from + " was not found"});
        }
        IItemHandler inputHandler = AnvilPeripheral.extractHandler(input.getTarget());
        if (slot < 0 || slot > inputHandler.getSlots()) {
            return MethodResult.of((Object[])new Object[]{false, "from slot out of range"});
        }
        ItemStack itemstack = inputHandler.getStackInSlot(slot);
        if (ItemStack.m_41656_((ItemStack)itemstack, (ItemStack)ItemStack.f_41583_)) {
            return MethodResult.of((Object[])new Object[]{false, "No item in slot"});
        }
        if (name.matches("")) {
            itemstack.m_41787_();
        } else {
            itemstack.m_41714_((Component)Component.m_237113_((String)name));
        }
        return MethodResult.of((Object)true);
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    @NotNull
    public LazyOptional<IPeripheral> getPeripheral(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction side) {
        if (world.m_8055_(pos).m_60734_().equals(Blocks.f_50322_) || world.m_8055_(pos).m_60734_().equals(Blocks.f_50323_) || world.m_8055_(pos).m_60734_().equals(Blocks.f_50324_)) {
            return LazyOptional.of(() -> this);
        }
        return LazyOptional.empty();
    }
}

