/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.networking;

import com.hakimen.peripherals.registry.ItemRegister;
import dan200.computercraft.shared.computer.blocks.ComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class KeyboardC2SPacket {
    final int key;
    final int type;
    final String text;
    final boolean held;

    public KeyboardC2SPacket(int key, int type, String text, boolean held) {
        this.key = key;
        this.text = text;
        this.type = type;
        this.held = held;
    }

    public KeyboardC2SPacket(FriendlyByteBuf buff) {
        this.key = buff.readInt();
        this.type = buff.readInt();
        this.text = buff.m_130277_();
        this.held = buff.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buff) {
        buff.writeInt(this.key);
        buff.writeInt(this.type);
        buff.m_130070_(this.text);
        buff.writeBoolean(this.held);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ItemStack itemInHand;
            ServerPlayer player = context.getSender();
            ItemStack itemStack = player != null ? (player.m_21205_().m_41720_().equals(ItemRegister.keyboard.get()) ? player.m_21205_() : player.m_21206_()) : (itemInHand = null);
            if (itemInHand != null && itemInHand.m_41784_().m_128425_("Bind", 10)) {
                ServerComputer serverComputer;
                CompoundTag bindTag = itemInHand.m_41784_().m_128469_("Bind");
                int x = bindTag.m_128451_("x");
                int y = bindTag.m_128451_("y");
                int z = bindTag.m_128451_("z");
                ComputerBlockEntity computer = (ComputerBlockEntity)context.getSender().m_9236_().m_7702_(new BlockPos(x, y, z));
                if (computer != null && (serverComputer = computer.getServerComputer()) != null) {
                    switch (this.type) {
                        case 0: {
                            serverComputer.queueEvent("key", new Object[]{this.key, this.held});
                            break;
                        }
                        case 1: {
                            serverComputer.queueEvent("key_up", new Object[]{this.key});
                            break;
                        }
                        case 2: {
                            serverComputer.queueEvent("char", new Object[]{Character.toString(this.key)});
                            break;
                        }
                        case 3: {
                            serverComputer.queueEvent("paste", new Object[]{this.text});
                            break;
                        }
                        case 4: {
                            serverComputer.queueEvent("terminate");
                            break;
                        }
                        case 5: {
                            serverComputer.shutdown();
                            break;
                        }
                        case 6: {
                            serverComputer.reboot();
                        }
                    }
                }
            }
        });
        return true;
    }
}

