/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.client.screen;

import com.hakimen.peripherals.client.containers.KeyboardContainer;
import com.hakimen.peripherals.networking.KeyboardC2SPacket;
import com.hakimen.peripherals.registry.PacketRegister;
import java.util.BitSet;
import net.minecraft.SharedConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class KeyboardScreen
extends AbstractContainerScreen<KeyboardContainer> {
    private float terminateTimer = -1.0f;
    private float rebootTimer = -1.0f;
    private float shutdownTimer = -1.0f;
    private static final float TERMINATE_TIME = 0.5f;
    private static final float KEY_SUPPRESS_DELAY = 0.2f;
    private final BitSet keysDown = new BitSet(256);

    protected void m_7856_() {
        this.f_96541_.f_91067_.m_91601_();
        this.f_96541_.f_91080_ = this;
        KeyMapping.m_90847_();
        super.m_7856_();
    }

    public KeyboardScreen(KeyboardContainer keyboardContainer, Inventory inventory, Component title) {
        super((AbstractContainerMenu)keyboardContainer, inventory, title);
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        gfx.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"item.peripherals.keyboard.close"), this.f_96543_ / 2, this.f_96544_ / 8, 0xFFFFFF);
    }

    protected void m_7286_(GuiGraphics p_283065_, float p_97788_, int p_97789_, int p_97790_) {
    }

    public boolean m_5534_(char ch, int modifiers) {
        if (ch >= ' ' && ch <= '~' || ch >= '\u00a0' && ch <= '\u00ff') {
            PacketRegister.sendToServer(new KeyboardC2SPacket(ch, 2, "", false));
        }
        return true;
    }

    public boolean m_6375_(double p_97748_, double p_97749_, int button) {
        HitResult hit = this.getMinecraft().f_91077_;
        if (hit != null && hit.m_6662_() == HitResult.Type.BLOCK && button == 1) {
            this.getMinecraft().f_91072_.m_233732_(this.getMinecraft().f_91074_, InteractionHand.MAIN_HAND, (BlockHitResult)this.getMinecraft().f_91077_);
        }
        return super.m_6375_(p_97748_, p_97749_, button);
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        if (key == 256) {
            return super.m_7933_(key, scancode, modifiers);
        }
        if (Screen.m_96630_((int)key)) {
            this.doPaste();
            return true;
        }
        if ((modifiers & 2) != 0) {
            switch (key) {
                case 84: {
                    if (!(this.terminateTimer < 0.0f)) break;
                    this.terminateTimer = 0.0f;
                    break;
                }
                case 83: {
                    if (!(this.shutdownTimer < 0.0f)) break;
                    this.shutdownTimer = 0.0f;
                    break;
                }
                case 82: {
                    if (!(this.rebootTimer < 0.0f)) break;
                    this.rebootTimer = 0.0f;
                }
            }
        }
        if (key >= 0 && this.terminateTimer < 0.2f && this.rebootTimer < 0.2f && this.shutdownTimer < 0.2f) {
            boolean repeat = this.keysDown.get(key);
            this.keysDown.set(key);
            PacketRegister.sendToServer(new KeyboardC2SPacket(key, 0, "", repeat));
        }
        return true;
    }

    protected void m_181908_() {
        if (this.terminateTimer >= 0.0f && this.terminateTimer < 0.5f) {
            float f;
            this.terminateTimer += 0.05f;
            if (f > 0.5f) {
                PacketRegister.sendToServer(new KeyboardC2SPacket(0, 4, "", false));
            }
        }
        if (this.shutdownTimer >= 0.0f && this.shutdownTimer < 0.5f) {
            float f;
            this.shutdownTimer += 0.05f;
            if (f > 0.5f) {
                PacketRegister.sendToServer(new KeyboardC2SPacket(0, 5, "", false));
            }
        }
        if (this.rebootTimer >= 0.0f && this.rebootTimer < 0.5f) {
            float f;
            this.rebootTimer += 0.05f;
            if (f > 0.5f) {
                PacketRegister.sendToServer(new KeyboardC2SPacket(0, 6, "", false));
            }
        }
    }

    public boolean m_7920_(int key, int scancode, int modifiers) {
        if (key >= 0 && this.keysDown.get(key)) {
            this.keysDown.set(key, false);
            PacketRegister.sendToServer(new KeyboardC2SPacket(key, 1, "", false));
        }
        switch (key) {
            case 84: {
                this.terminateTimer = -1.0f;
                break;
            }
            case 82: {
                this.rebootTimer = -1.0f;
                break;
            }
            case 83: {
                this.shutdownTimer = -1.0f;
                break;
            }
            case 341: 
            case 345: {
                this.shutdownTimer = -1.0f;
                this.rebootTimer = -1.0f;
                this.terminateTimer = -1.0f;
            }
        }
        return true;
    }

    private void doPaste() {
        String clipboard = Minecraft.m_91087_().f_91068_.m_90876_();
        int carriageReturnIndex = clipboard.indexOf(13);
        int newLineIndex = clipboard.indexOf(10);
        if (carriageReturnIndex >= 0 && newLineIndex >= 0) {
            clipboard = clipboard.substring(0, Math.min(carriageReturnIndex, newLineIndex));
        } else if (carriageReturnIndex >= 0) {
            clipboard = clipboard.substring(0, newLineIndex);
        } else if (newLineIndex >= 0) {
            clipboard = clipboard.substring(0, newLineIndex);
        }
        clipboard = SharedConstants.m_136190_((String)clipboard);
        if (!clipboard.isEmpty()) {
            if (clipboard.length() > 512) {
                clipboard = clipboard.substring(0, 512);
            }
            PacketRegister.sendToServer(new KeyboardC2SPacket(0, 3, clipboard, false));
        }
    }
}

