/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.blocks.tile_entities;

import com.hakimen.peripherals.registry.BlockEntityRegister;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GrinderEntity
extends BlockEntity {
    public final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.inventory);

    public GrinderEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.grinderEntity.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag);
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128391_(this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction dir) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler;
        }
        return super.getCapability(cap, dir);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                GrinderEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return stack.m_41720_() instanceof SwordItem;
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }
}

