/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.events;

import dev.xkmc.modulargolems.content.capability.GolemConfigCapability;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.item.card.ClickEntityFilterCard;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="modulargolems", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierEventListeners {
    @SubscribeEvent
    public static void onGolemSpawn(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof AbstractGolemEntity) {
            AbstractGolemEntity entity2 = (AbstractGolemEntity)entity;
            entity2.getModifiers().forEach((k, v) -> k.onGolemSpawn(entity2, (int)v));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onHurtPre(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (entity instanceof AbstractGolemEntity) {
            AbstractGolemEntity entity2 = (AbstractGolemEntity)entity;
            entity2.getModifiers().forEach((k, v) -> k.onHurtTarget(entity2, event, (int)v));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAttackPre(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof AbstractGolemEntity) {
            AbstractGolemEntity entity2 = (AbstractGolemEntity)entity;
            entity2.getModifiers().forEach((k, v) -> k.onAttackTarget(entity2, event, (int)v));
        }
    }

    @SubscribeEvent
    public static void onAttacked(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractGolemEntity) {
            AbstractGolemEntity entity = (AbstractGolemEntity)livingEntity;
            entity.getModifiers().forEach((k, v) -> k.onAttacked(entity, event, (int)v));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onHurtPost(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractGolemEntity) {
            AbstractGolemEntity entity = (AbstractGolemEntity)livingEntity;
            entity.getModifiers().forEach((k, v) -> k.onHurt(entity, event, (int)v));
        }
    }

    @SubscribeEvent
    public static void onDamaged(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractGolemEntity) {
            AbstractGolemEntity entity = (AbstractGolemEntity)livingEntity;
            entity.getModifiers().forEach((k, v) -> k.onDamaged(entity, event, (int)v));
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        for (Entity e : event.getAffectedEntities()) {
            AbstractGolemEntity golem;
            if (!(e instanceof AbstractGolemEntity) || (golem = (AbstractGolemEntity)e).getModifiers().getOrDefault(GolemModifiers.EXPLOSION_RES.get(), 0) <= 0) continue;
            event.getAffectedBlocks().clear();
            return;
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (!((Boolean)MGConfig.COMMON.doEnemyAggro.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!event.getLevel().m_5776_() && mob instanceof Enemy && !(mob instanceof Creeper)) {
                int priority = 0;
                NearestAttackableTargetGoal ans = null;
                for (WrappedGoal goal : mob.f_21346_.m_148105_()) {
                    Goal goal2 = goal.m_26015_();
                    if (!(goal2 instanceof NearestAttackableTargetGoal)) continue;
                    NearestAttackableTargetGoal target = (NearestAttackableTargetGoal)goal2;
                    if (target.f_26048_ != IronGolem.class) continue;
                    priority = goal.m_26012_();
                    ans = new NearestAttackableTargetGoal(mob, AbstractGolemEntity.class, target.f_26049_, target.f_26136_, target.f_26131_, null);
                    break;
                }
                if (ans != null) {
                    mob.f_21346_.m_25352_(priority, ans);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrop(LivingDropsEvent event) {
        AbstractGolemEntity e;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof AbstractGolemEntity && (e = (AbstractGolemEntity)entity).hasFlag(GolemFlags.PICKUP)) {
            event.getDrops().forEach(x -> x.m_20219_(e.m_20182_()));
        }
    }

    @SubscribeEvent
    public static void onAttachLevelCapabilities(AttachCapabilitiesEvent<Level> event) {
        ServerLevel level;
        Object object = event.getObject();
        if (object instanceof ServerLevel && (level = (ServerLevel)object).m_46472_() == Level.f_46428_) {
            event.addCapability(new ResourceLocation("modulargolems", "command"), (ICapabilityProvider)new GolemConfigCapability(level));
        }
    }

    @SubscribeEvent
    public static void onTargetCardClick(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event.getItemStack().m_41720_() instanceof ClickEntityFilterCard && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            event.setCancellationResult(event.getItemStack().m_41647_(event.getEntity(), le, event.getHand()));
            event.setCanceled(true);
        }
    }
}

