/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.wand;

import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.l2library.util.raytrace.IGlowingTarget;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import dev.xkmc.modulargolems.content.capability.GolemConfigEditor;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.SquadEditor;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.item.card.ConfigCard;
import dev.xkmc.modulargolems.content.item.wand.BaseWandItem;
import dev.xkmc.modulargolems.content.item.wand.GolemInteractItem;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SquadWandItem
extends BaseWandItem
implements GolemInteractItem,
IGlowingTarget {
    private static final int RANGE = 64;

    public SquadWandItem(Item.Properties properties, @Nullable ItemEntry<? extends BaseWandItem> base) {
        super(properties, MGLangData.WAND_SQUAD, null, base);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.m_5776_() && selected && entity instanceof Player) {
            Player player = (Player)entity;
            RayTraceUtil.clientUpdateTarget((Player)player, (double)64.0);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        LivingEntity target;
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_() && (target = RayTraceUtil.serverGetTarget((Player)player)) != null) {
            this.m_6880_(stack, player, target, hand);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public int getDistance(ItemStack itemStack) {
        return 64;
    }

    public InteractionResult m_6880_(ItemStack stack, Player user, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof AbstractGolemEntity)) {
            return InteractionResult.PASS;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)target;
        return SquadWandItem.choose(target.m_9236_(), user, golem) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private static boolean choose(Level level, Player user, AbstractGolemEntity<?, ?> golem) {
        if (!ConfigCard.getFilter(user).test(golem)) {
            return false;
        }
        if (!golem.canModify(user)) {
            return false;
        }
        if (level.m_5776_()) {
            return true;
        }
        if (!(golem instanceof DogGolemEntity)) {
            GolemConfigEntry entry = golem.getConfigEntry(null);
            if (entry != null) {
                SquadEditor editor = new GolemConfigEditor.Writable(level, entry).getSquad();
                UUID capId = editor.getCaptainId();
                UUID golemId = golem.m_20148_();
                if (capId != null && capId.equals(golemId)) {
                    editor.setCaptainId(null);
                } else {
                    editor.setCaptainId(golemId);
                }
            } else {
                return false;
            }
        }
        return false;
    }
}

