/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.core.ModelProvider;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.IGolemModel;
import dev.xkmc.modulargolems.content.item.golem.BEWLRHandle;
import dev.xkmc.modulargolems.content.item.golem.ClientHolderManager;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.golem.IGolemPartItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class GolemBEWLR
extends BlockEntityWithoutLevelRenderer {
    public static final Supplier<BlockEntityWithoutLevelRenderer> INSTANCE = Suppliers.memoize(() -> new GolemBEWLR(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));
    public static final IClientItemExtensions EXTENSIONS = new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return INSTANCE.get();
        }
    };
    private final EntityModelSet entityModelSet;
    private final HashMap<ResourceLocation, IGolemModel<?, ?, ?>> map = new HashMap();

    public GolemBEWLR(BlockEntityRenderDispatcher dispatcher, EntityModelSet set) {
        super(dispatcher, set);
        this.entityModelSet = set;
    }

    public void m_6213_(ResourceManager manager) {
        this.map.clear();
        GolemType.GOLEM_TYPE_TO_MODEL.forEach((k, v) -> this.map.put((ResourceLocation)k, ((ModelProvider)v.get()).generateModel(this.entityModelSet)));
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext type, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        GolemHolder holder;
        BEWLRHandle handle = new BEWLRHandle(stack, type, poseStack, bufferSource, light, overlay);
        poseStack.m_85836_();
        Item item = stack.m_41720_();
        if (item instanceof IGolemPartItem) {
            IGolemPartItem part = (IGolemPartItem)item;
            this.render(handle, part.asPart());
        }
        if ((item = stack.m_41720_()) instanceof GolemHolder && !this.renderEntity(handle, holder = (GolemHolder)item)) {
            this.render(handle, holder);
        }
        poseStack.m_85849_();
    }

    private <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void render(BEWLRHandle handle, GolemHolder<T, P> item) {
        ArrayList<GolemMaterial> list = GolemHolder.getMaterial(handle.stack());
        IGolemPart[] parts = item.getEntityType().values();
        PoseStack stack = handle.poseStack();
        parts[0].setupItemRender(stack, handle.type(), null);
        for (int i = 0; i < parts.length; ++i) {
            ResourceLocation id = list.size() > i ? list.get(i).id() : GolemMaterial.EMPTY;
            this.renderPart(handle, id, item.getEntityType(), parts[i]);
        }
    }

    private <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void render(BEWLRHandle handle, GolemPart<T, P> item) {
        PoseStack stack = handle.poseStack();
        P part = item.getPart();
        part.setupItemRender(stack, handle.type(), part);
        Optional<ResourceLocation> id = GolemPart.getMaterial(handle.stack());
        this.renderPart(handle, id.orElse(GolemMaterial.EMPTY), item.getEntityType(), part);
    }

    private <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>, M extends EntityModel<T>> void renderPart(BEWLRHandle handle, ResourceLocation id, GolemType<T, P> type, P part) {
        EntityModel model = (EntityModel)Wrappers.cast(this.map.get(type.getRegistryName()));
        RenderType render = model.m_103119_(((IGolemModel)model).getTextureLocationInternal(id));
        VertexConsumer vc = ItemRenderer.m_115222_((MultiBufferSource)handle.bufferSource(), (RenderType)render, (boolean)false, (boolean)handle.stack().m_41790_());
        ((IGolemModel)model).renderToBufferInternal(part, handle.poseStack(), vc, handle.light(), handle.overlay(), 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> boolean renderEntity(BEWLRHandle handle, GolemHolder<T, P> item) {
        T golem = ClientHolderManager.getEntityForDisplay(item, handle.stack());
        if (golem == null) {
            return false;
        }
        IGolemPart[] parts = item.getEntityType().values();
        PoseStack stack = handle.poseStack();
        parts[0].setupItemRender(stack, handle.type(), null);
        stack.m_85837_(0.0, 1.501, 0.0);
        stack.m_85841_(1.0f, -1.0f, -1.0f);
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(golem);
        ((AbstractGolemEntity)((Object)golem)).f_19797_ = Proxy.getClientPlayer().f_19797_;
        renderer.m_7392_(golem, 0.0f, Minecraft.m_91087_().getPartialTick(), handle.poseStack(), handle.bufferSource(), handle.light());
        return true;
    }
}

