/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.card;

import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.modulargolems.content.capability.GolemConfigEditor;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.wand.GolemInteractItem;
import dev.xkmc.modulargolems.content.menu.config.ConfigMenuProvider;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class ConfigCard
extends Item
implements GolemInteractItem {
    private static final String KEY_OWNER = "config_owner";
    private final DyeColor color;

    @Nullable
    public static UUID getUUID(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(KEY_OWNER)) {
            return stack.m_41783_().m_128342_(KEY_OWNER);
        }
        return null;
    }

    public static Predicate<AbstractGolemEntity<?, ?>> getFilter(Player player) {
        ItemStack stack = player.m_21206_();
        Item item = stack.m_41720_();
        if (item instanceof ConfigCard) {
            ConfigCard card = (ConfigCard)item;
            UUID uuid = ConfigCard.getUUID(stack);
            if (uuid != null) {
                return e -> Optional.ofNullable(e.getConfigEntry(null)).map(x -> x.getID().equals(uuid) && x.getColor() == card.color.m_41060_()).orElse(true);
            }
        }
        return e -> true;
    }

    private static boolean mayClientEdit(UUID id) {
        LocalPlayer player = Proxy.getClientPlayer();
        return player != null && player.m_20148_().equals(id);
    }

    public ConfigCard(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof AbstractGolemEntity) {
            GolemConfigEntry old;
            AbstractGolemEntity golem = (AbstractGolemEntity)target;
            if (!golem.canModify(player)) {
                return InteractionResult.FAIL;
            }
            if (player.m_9236_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            UUID uuid = ConfigCard.getUUID(stack);
            if (uuid == null) {
                uuid = player.m_20148_();
                stack.m_41784_().m_128362_(KEY_OWNER, uuid);
            }
            if ((old = golem.getConfigEntry(null)) != null && old.getID().equals(uuid) && old.getColor() == this.color.m_41060_()) {
                golem.setConfigCard(null, 0);
            } else {
                golem.setConfigCard(uuid, this.color.m_41060_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        UUID uuid = ConfigCard.getUUID(stack);
        if (uuid == null) {
            uuid = player.m_20148_();
            stack.m_41784_().m_128362_(KEY_OWNER, uuid);
        }
        if (level instanceof ServerLevel) {
            GolemConfigEditor.Writable editor;
            ServerLevel sl = (ServerLevel)level;
            if (player.m_20148_().equals(uuid)) {
                GolemConfigEntry entry = GolemConfigStorage.get(level).getOrCreateStorage(uuid, this.color.m_41060_(), stack.m_41786_());
                entry.setName(stack.m_41786_(), sl);
                entry.heartBeat(sl, (ServerPlayer)player);
                editor = new GolemConfigEditor.Writable(level, entry);
            } else {
                GolemConfigEntry entry = GolemConfigStorage.get(level).getStorage(uuid, this.color.m_41060_());
                editor = entry != null ? new GolemConfigEditor.Writable(level, entry) : null;
            }
            if (editor != null && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ConfigMenuProvider pvd = new ConfigMenuProvider(uuid, this.color.m_41060_(), editor);
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)pvd, pvd::writeBuffer);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag pIsAdvanced) {
        UUID id = ConfigCard.getUUID(stack);
        if (id == null) {
            list.add((Component)MGLangData.CONFIG_INIT.get(new Object[0]));
        } else {
            if (level != null) {
                GolemConfigEntry entry = GolemConfigStorage.get(level).getOrCreateStorage(id, this.color.m_41060_(), (Component)MGLangData.LOADING.get(new Object[0]));
                entry.clientTick(level, false);
                list.add(entry.getDisplayName());
            }
            if (!ConfigCard.mayClientEdit(id)) {
                list.add((Component)MGLangData.CONFIG_OTHER.get(new Object[0]));
            }
            list.add((Component)MGLangData.CONFIG_CARD.get(new Object[0]));
        }
    }
}

