/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.sync;

import dev.xkmc.l2library.util.nbt.NBTObj;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import org.jetbrains.annotations.Nullable;

public class SyncedData {
    public static final Serializer<Integer> INT = new Serializer<Integer>(EntityDataSerializers.f_135028_, IntTag::m_128679_, tag -> {
        Integer n;
        if (tag instanceof NumericTag) {
            NumericTag n2 = (NumericTag)tag;
            n = n2.m_7047_();
        } else {
            n = 0;
        }
        return n;
    });
    public static final Serializer<BlockPos> BLOCK_POS = new Serializer<BlockPos>(EntityDataSerializers.f_135038_, pos -> {
        NBTObj ans = new NBTObj();
        ans.fromBlockPos(pos);
        return ans.tag;
    }, tag -> {
        BlockPos blockPos;
        if (tag instanceof CompoundTag) {
            CompoundTag ct = (CompoundTag)tag;
            blockPos = new NBTObj(ct).toBlockPos();
        } else {
            blockPos = BlockPos.f_121853_;
        }
        return blockPos;
    });
    public static final Serializer<Optional<UUID>> UUID = new Serializer<Optional>(EntityDataSerializers.f_135041_, uuid -> uuid.map(NbtUtils::m_129226_).orElse(null), tag -> Optional.ofNullable(tag).map(NbtUtils::m_129233_));
    private final Definer cls;
    private final List<Data<?>> list = new ArrayList();

    public SyncedData(Definer cls) {
        this.cls = cls;
    }

    public void register(SynchedEntityData data) {
        for (Data<?> entry : this.list) {
            entry.register(data);
        }
    }

    public <T> EntityDataAccessor<T> define(Serializer<T> ser, T init, @Nullable String name) {
        Data<T> data = new Data<T>(ser, init, name);
        this.list.add(data);
        return data.data;
    }

    public void write(CompoundTag tag, SynchedEntityData entityData) {
        for (Data<?> entry : this.list) {
            entry.write(tag, entityData);
        }
    }

    public void read(CompoundTag tag, SynchedEntityData entityData) {
        for (Data<?> entry : this.list) {
            entry.read(tag, entityData);
        }
    }

    public static interface Definer {
        public <T> EntityDataAccessor<T> define(EntityDataSerializer<T> var1);
    }

    private class Data<T> {
        private final Serializer<T> ser;
        private final EntityDataAccessor<T> data;
        private final T init;
        private final String name;

        private Data(Serializer<T> ser, @Nullable T init, String name) {
            this.ser = ser;
            this.data = SyncedData.this.cls.define(ser.ser());
            this.init = init;
            this.name = name;
        }

        private void register(SynchedEntityData data) {
            data.m_135372_(this.data, this.init);
        }

        public void write(CompoundTag tag, SynchedEntityData entityData) {
            if (this.name == null) {
                return;
            }
            Tag ans = this.ser.write(entityData.m_135370_(this.data));
            if (ans != null) {
                tag.m_128365_(this.name, ans);
            }
        }

        public void read(CompoundTag tag, SynchedEntityData entityData) {
            if (this.name == null) {
                return;
            }
            entityData.m_135381_(this.data, this.ser.read(tag.m_128423_(this.name)));
        }
    }

    public record Serializer<T>(EntityDataSerializer<T> ser, Function<T, @Nullable Tag> write, Function<@Nullable Tag, T> read) {
        @Nullable
        public Tag write(T t) {
            return this.write.apply(t);
        }

        public T read(@Nullable Tag tag) {
            return this.read.apply(tag);
        }
    }
}

