/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.ranged;

import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class Estimator {
    private static final double ERR = 1.0E-5;
    private final double gk;
    private final double k;
    private final double vk;
    private final double g;
    private final double v;
    private final double x;
    private final int max;
    private final Vec3 dp;
    private final Vec3 ev;

    public Estimator(double G, double K, Vec3 pos, double V, int maxt, Vec3 ep, Vec3 eV) {
        this.gk = G / K;
        this.g = G;
        this.k = K;
        this.vk = V / K;
        this.v = V;
        this.max = maxt;
        this.ev = eV;
        Vec3 vdp = ep.m_82546_(pos);
        this.dp = vdp.m_82520_(Math.abs(vdp.f_82479_) < 1.0E-5 ? 1.0E-5 : 0.0, 0.0, Math.abs(vdp.f_82481_) < 1.0E-5 ? 1.0E-5 : 0.0);
        this.x = Estimator.dis(this.dp.f_82479_, this.dp.f_82481_);
    }

    public static SolResult solve(Function<Double, Double> f, double v, double min, double max, double err) {
        boolean inc;
        double x0 = min;
        double x1 = max;
        double v0 = f.apply(x0);
        double v1 = f.apply(x1);
        if (Math.abs(v0 - v) < err) {
            return new SucSolRes(x0);
        }
        if (Math.abs(v1 - v) < err) {
            return new SucSolRes(x1);
        }
        if (v0 > v && v1 > v) {
            return SolType.OVER;
        }
        if (v0 < v && v1 < v) {
            return SolType.BELOW;
        }
        boolean bl = inc = v0 < v1;
        while (Math.abs(x1 - x0) > err) {
            double x = (x0 + x1) / 2.0;
            double vm = f.apply(x);
            if (Math.abs(vm - v) < err) {
                return new SucSolRes(x);
            }
            if (v < vm && inc || v > vm && !inc) {
                x1 = x;
                continue;
            }
            x0 = x;
        }
        return new SucSolRes((x0 + x1) / 2.0);
    }

    public static SolResult solve(Function<Double, Double> f2, Function<Double, Double> f1, double v, double x0, double x1, double err) {
        SolResult sr = Estimator.solve(f1, 0.0, x0, x1, err);
        if (sr.getType() == SolType.ZERO) {
            double tip = sr.getVal();
            double max = f2.apply(tip);
            double v0 = f2.apply(x0);
            double v1 = f2.apply(x1);
            if (v > max && max > v0 && max > v1) {
                return SolType.OVER;
            }
            if (v < max && max < v0 && max < v1) {
                return SolType.BELOW;
            }
            if ((v - v0) * (v - max) < 0.0) {
                return Estimator.solve(f2, v, x0, tip, err);
            }
            return Estimator.solve(f2, v, tip, x1, err);
        }
        return Estimator.solve(f2, v, x0, x1, err);
    }

    private static double dis(double a, double b) {
        return Math.sqrt(a * a + b * b);
    }

    public EstiResult getAnswer() {
        if (this.v * this.v - 2.0 * this.g * this.dp.f_82480_ < 0.0) {
            return EstiType.CLOSE;
        }
        EstiResult ans = this.getIdeal();
        double[] data = new double[]{ans.getA(), ans.getT()};
        if (this.estimate(data, 0.1, 0.2, 3.0)) {
            return EstiType.FAIL;
        }
        if (this.estimate(data, 0.01, 0.2, 0.3)) {
            return EstiType.FAIL;
        }
        return new SucEstiRes(data[0], data[1], this);
    }

    public EstiResult getIdeal() {
        SolResult r1;
        double maxt;
        double xt1;
        double xt0 = Math.abs((Math.sqrt(this.v * this.v - 2.0 * this.g * this.dp.f_82480_) + this.v) / this.g);
        double mint = Math.max(0.0, Math.min(xt0, xt1 = Math.abs((-Math.sqrt(this.v * this.v - 2.0 * this.g * this.dp.f_82480_) + this.v) / this.g)) + 1.0E-5);
        SolResult r0 = Estimator.solve(this::get_0, 0.0, mint, maxt = Math.min((double)this.max, Math.max(xt0, xt1) - 1.0E-5), 1.0E-5);
        if (r0.getType() == SolType.ZERO) {
            double bp = r0.getVal();
            SolResult dr0 = Estimator.solve(this::get_1, 0.0, mint, bp, 1.0E-5);
            SolResult dr1 = Estimator.solve(this::get_1, 0.0, bp, maxt, 1.0E-5);
            r1 = dr0.getType() == SolType.ZERO ? dr0 : dr1;
        } else {
            r1 = Estimator.solve(this::get_1, 0.0, mint, maxt, 1.0E-5);
        }
        if (r1.getType() != SolType.ZERO) {
            return EstiType.FAIL;
        }
        double t0 = r1.getVal();
        double a0 = Math.asin(this.dp.f_82480_ / this.v / t0 + this.g * t0 / 2.0 / this.v);
        return new SucEstiRes(a0, t0, this);
    }

    public double getX0(double a, double t) {
        double xt = this.dp.f_82479_ + this.ev.f_82479_ * t;
        double zt = this.dp.f_82481_ + this.ev.f_82481_ * t;
        return this.vk * Math.cos(a) * (1.0 - Math.exp(-this.k * t)) - Math.sqrt(xt * xt + zt * zt);
    }

    public double getY0(double a, double t) {
        return -this.gk * t + (this.vk * Math.sin(a) + this.gk / this.k) * (1.0 - Math.exp(-this.k * t)) - this.dp.f_82480_ - this.ev.f_82480_ * t;
    }

    private boolean estimate(double[] data, double DA, double DT, double ER) {
        double len;
        double a0 = data[0];
        double t0 = data[1];
        double x0 = this.getX0(a0, t0);
        double y0 = this.getY0(a0, t0);
        int count = 0;
        boolean out = false;
        do {
            double d;
            len = Estimator.dis(x0, y0);
            if (!(d > ER)) break;
            ++count;
            double da = x0 * this.getXA(a0, t0) + y0 * this.getYA(a0, t0);
            double dt = x0 * this.getXT(a0, t0) + y0 * this.getYT(a0, t0);
            if (da > 0.0) {
                a0 -= DA;
            }
            if (da < 0.0) {
                a0 += DA;
            }
            if (dt > 0.0) {
                t0 -= DT;
            }
            if (!(dt < 0.0)) continue;
            t0 += DT;
        } while (!(out |= a0 < -1.5707963267948966 || a0 > 1.5707963267948966) && !(out |= t0 < 0.0 || t0 > (double)this.max) && !(Math.abs(Estimator.dis(x0 = this.getX0(a0, t0), y0 = this.getY0(a0, t0)) - len) < 1.0E-5) && count <= 100);
        data[0] = Mth.m_14008_((double)a0, (double)-1.5707963267948966, (double)1.5707963267948966);
        data[1] = Mth.m_14008_((double)t0, (double)0.0, (double)this.max);
        return out;
    }

    private double get_0(double t) {
        double mul = this.dp.f_82480_ / this.v / t + this.g * t / 2.0 / this.v;
        double m = Math.sqrt(1.0 - mul * mul);
        return this.v * m - this.v * t * mul / m * (this.g / 2.0 / this.v - this.dp.f_82480_ / this.v / t / t);
    }

    private double get_1(double t) {
        double mul = this.dp.f_82480_ / this.v / t + this.g * t / 2.0 / this.v;
        return this.v * t * Math.sqrt(1.0 - mul * mul) - this.x;
    }

    private double getXA(double a, double t) {
        return -this.vk * Math.sin(a) * (1.0 - Math.exp(-this.k * t));
    }

    private double getXT(double a, double t) {
        double xt = this.dp.f_82479_ + this.ev.f_82479_ * t;
        double zt = this.dp.f_82481_ + this.ev.f_82481_ * t;
        double ext = ((this.ev.f_82479_ * this.ev.f_82479_ + this.ev.f_82481_ * this.ev.f_82481_) * t + this.dp.f_82479_ * this.ev.f_82479_ + this.dp.f_82481_ * this.ev.f_82481_) / Math.sqrt(xt * xt + zt * zt);
        return Math.cos(a) * this.v * Math.exp(-this.k * t) - ext;
    }

    private double getYA(double a, double t) {
        return this.vk * Math.cos(a) * (1.0 - Math.exp(-this.k * t));
    }

    private double getYT(double a, double t) {
        return (Math.sin(a) * this.v + this.gk) * Math.exp(-this.k * t) - this.gk - this.ev.f_82480_;
    }

    private static class SucSolRes
    implements SolResult {
        private final double val;

        private SucSolRes(double value) {
            this.val = value;
        }

        @Override
        public SolType getType() {
            return SolType.ZERO;
        }

        @Override
        public double getVal() {
            return this.val;
        }
    }

    public static enum SolType implements SolResult
    {
        OVER,
        BELOW,
        ZERO;


        @Override
        public SolType getType() {
            return this;
        }

        @Override
        public double getVal() {
            return 0.0;
        }
    }

    public static interface SolResult {
        public SolType getType();

        public double getVal();
    }

    public static enum EstiType implements EstiResult
    {
        ZERO,
        FAIL,
        CLOSE;


        @Override
        public double getA() {
            return 0.0;
        }

        @Override
        public double getT() {
            return 0.0;
        }

        @Override
        public EstiType getType() {
            return this;
        }

        @Override
        public Vec3 getVec() {
            return Vec3.f_82478_;
        }
    }

    public static interface EstiResult {
        public double getA();

        public double getT();

        public EstiType getType();

        public Vec3 getVec();
    }

    private static class SucEstiRes
    implements EstiResult {
        private final double a;
        private final double t;
        private final Estimator mov;

        private SucEstiRes(double A, double T, Estimator m) {
            this.a = A;
            this.t = T;
            this.mov = m;
        }

        @Override
        public double getA() {
            return this.a;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public EstiType getType() {
            return EstiType.ZERO;
        }

        @Override
        public Vec3 getVec() {
            Vec3 fin = this.mov.dp.m_82549_(this.mov.ev.m_82490_(this.t)).m_82542_(1.0, 0.0, 1.0);
            double l = fin.m_82553_();
            double c = Math.cos(this.a);
            return new Vec3(this.mov.v * c * fin.f_82479_ / l, this.mov.v * Math.sin(this.a), this.mov.v * c * fin.f_82481_ / l);
        }
    }
}

