/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.entity.common.SweepGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumaniodGolemPartType;
import dev.xkmc.modulargolems.content.entity.humanoid.ItemWrapper;
import dev.xkmc.modulargolems.content.entity.ranged.GolemBowAttackGoal;
import dev.xkmc.modulargolems.content.entity.ranged.GolemCrossbowAttackGoal;
import dev.xkmc.modulargolems.content.entity.ranged.GolemShooterHelper;
import dev.xkmc.modulargolems.content.entity.ranged.GolemTridentAttackGoal;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.events.event.GolemBowAttackEvent;
import dev.xkmc.modulargolems.events.event.GolemDamageShieldEvent;
import dev.xkmc.modulargolems.events.event.GolemDisableShieldEvent;
import dev.xkmc.modulargolems.events.event.GolemEquipEvent;
import dev.xkmc.modulargolems.events.event.GolemSweepEvent;
import dev.xkmc.modulargolems.events.event.GolemThrowableEvent;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;

@SerialClass
public class HumanoidGolemEntity
extends SweepGolemEntity<HumanoidGolemEntity, HumaniodGolemPartType>
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(HumanoidGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final GolemBowAttackGoal bowGoal = new GolemBowAttackGoal(this, 1.0, 20, 15.0f);
    private final GolemCrossbowAttackGoal crossbowGoal = new GolemCrossbowAttackGoal(this, 1.0, 15.0f);
    private final GolemMeleeGoal meleeGoal = new GolemMeleeGoal(this);
    private final GolemTridentAttackGoal tridentGoal = new GolemTridentAttackGoal(this, 1.0, 40, 15.0f, this.meleeGoal);
    @SerialClass.SerialField(toClient=true)
    public int shieldCooldown = 0;
    @SerialClass.SerialField
    private ItemStack backupHand = ItemStack.f_41583_;
    @SerialClass.SerialField
    private ItemStack arrowSlot = ItemStack.f_41583_;
    protected boolean rendering;
    protected boolean render_trigger = false;

    public HumanoidGolemEntity(EntityType<HumanoidGolemEntity> type, Level level) {
        super(type, level);
        if (!this.m_9236_().f_46443_) {
            this.reassessWeaponGoal();
            this.groundNavigation.m_26477_(true);
        }
    }

    public void reassessWeaponGoal() {
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_((Goal)this.bowGoal);
            this.f_21345_.m_25363_((Goal)this.crossbowGoal);
            this.f_21345_.m_25363_((Goal)this.tridentGoal);
            InteractionHand hand = this.getWeaponHand();
            ItemStack weapon = this.m_21120_(hand);
            if (!weapon.m_41619_() && GolemShooterHelper.isValidThrowableWeapon(this, weapon, hand).isThrowable()) {
                this.f_21345_.m_25352_(2, (Goal)this.tridentGoal);
                this.f_21345_.m_25352_(3, (Goal)this.meleeGoal);
                return;
            }
            if (!weapon.m_41619_() && weapon.m_41720_() instanceof BowItem) {
                this.bowGoal.setMinAttackInterval(20);
                this.f_21345_.m_25352_(2, (Goal)this.bowGoal);
                return;
            }
            if (!weapon.m_41619_() && weapon.m_41720_() instanceof CrossbowItem) {
                this.f_21345_.m_25352_(2, (Goal)this.crossbowGoal);
                return;
            }
            this.f_21345_.m_25352_(2, (Goal)this.meleeGoal);
        }
    }

    public ItemStack m_6298_(ItemStack pShootable) {
        if (pShootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6442_();
            ItemStack stack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            if (stack.m_41619_() && !this.arrowSlot.m_41619_() && predicate.test(this.arrowSlot)) {
                stack = this.arrowSlot;
            }
            return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)stack);
        }
        return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)ItemStack.f_41583_);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.reassessWeaponGoal();
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
        if (!this.m_9236_().f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    public boolean m_5886_(ProjectileWeaponItem pProjectileWeapon) {
        return true;
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean pIsCharging) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public void m_5811_(LivingEntity pTarget, ItemStack pCrossbowStack, Projectile pProjectile, float pProjectileAngle) {
        this.m_32322_((LivingEntity)this, pTarget, pProjectile, pProjectileAngle, 1.6f);
    }

    public void m_32322_(LivingEntity pUser, LivingEntity pTarget, Projectile pProjectile, float pProjectileAngle, float pVelocity) {
        GolemShooterHelper.shootAimHelper(pTarget, pProjectile);
        pUser.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (pUser.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_32336_(LivingEntity pUser, float pVelocity) {
        InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)pUser, item -> item instanceof CrossbowItem);
        ItemStack itemstack = pUser.m_21120_(interactionhand);
        if (pUser.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            CrossbowItem.m_40887_((Level)pUser.m_9236_(), (LivingEntity)pUser, (InteractionHand)interactionhand, (ItemStack)itemstack, (float)pVelocity, (float)0.0f);
        }
        this.m_5847_();
    }

    public InteractionHand getWeaponHand() {
        ItemStack stack = this.m_21205_();
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (stack.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            hand = InteractionHand.OFF_HAND;
        }
        return hand;
    }

    public void m_6504_(LivingEntity pTarget, float dist) {
        InteractionHand hand = this.getWeaponHand();
        ItemStack stack = this.m_21120_(hand);
        GolemThrowableEvent throwable = GolemShooterHelper.isValidThrowableWeapon(this, stack, hand);
        if (throwable.isThrowable()) {
            Projectile projectile = throwable.createProjectile(this.m_9236_());
            GolemShooterHelper.shootAimHelper(pTarget, projectile);
            this.m_5496_(SoundEvents.f_12520_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            projectile.getPersistentData().m_128405_("DespawnFactor", 20);
            this.m_9236_().m_7967_((Entity)projectile);
            stack.m_41622_(1, (LivingEntity)this, e -> e.m_21190_(InteractionHand.MAIN_HAND));
        } else if (stack.m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 3.0f);
        } else {
            Item projectile = stack.m_41720_();
            if (projectile instanceof BowItem) {
                BowItem bow = (BowItem)projectile;
                ItemStack arrowStack = this.m_6298_(stack);
                if (arrowStack.m_41619_()) {
                    return;
                }
                AbstractArrow arrowEntity = bow.customArrow(this.getArrow(arrowStack, dist));
                boolean infinite = GolemShooterHelper.arrowIsInfinite(arrowStack, stack);
                GolemBowAttackEvent event = new GolemBowAttackEvent(this, stack, hand, arrowEntity, infinite);
                MinecraftForge.EVENT_BUS.post((Event)event);
                arrowEntity = event.getArrow();
                arrowEntity.f_36705_ = event.isNoPickup() ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                if (!event.isNoConsume()) {
                    arrowStack.m_41774_(1);
                }
                GolemShooterHelper.shootAimHelper(pTarget, (Projectile)arrowEntity, event.speed(), event.gravity());
                this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                arrowEntity.getPersistentData().m_128405_("DespawnFactor", 20);
                this.m_9236_().m_7967_((Entity)arrowEntity);
                stack.m_41622_(1, (LivingEntity)this, e -> e.m_21190_(InteractionHand.MAIN_HAND));
            }
        }
    }

    public boolean m_21254_() {
        boolean ans;
        boolean bl = ans = this.shieldCooldown == 0 && this.shieldSlot() != null;
        if (ans && this.rendering) {
            this.render_trigger = true;
        }
        return ans;
    }

    public ItemStack m_21211_() {
        ItemStack ans = super.m_21211_();
        if (this.rendering && this.render_trigger) {
            this.render_trigger = false;
            InteractionHand hand = this.shieldSlot();
            if (hand != null) {
                return this.m_21120_(hand);
            }
        }
        return ans;
    }

    public void m_21166_(EquipmentSlot pSlot) {
        super.m_21166_(pSlot);
        Player player = this.getOwner();
        if (player != null) {
            GolemTriggers.BREAK.trigger((ServerPlayer)player);
        }
    }

    @Override
    public boolean m_7327_(Entity target) {
        boolean can_sweep = this.m_21205_().canPerformAction(ToolActions.SWORD_SWEEP);
        if (!can_sweep) {
            if (super.m_7327_(target)) {
                ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
                stack.m_41622_(1, (LivingEntity)this, self -> self.m_21166_(EquipmentSlot.MAINHAND));
                return true;
            }
        } else if (this.performRangedDamage(target, 0.0f, 0.0)) {
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            stack.m_41622_(1, (LivingEntity)this, self -> self.m_21166_(EquipmentSlot.MAINHAND));
            return true;
        }
        return false;
    }

    @Override
    protected AABB getAttackBoundingBox(Entity target, double range) {
        GolemSweepEvent event = new GolemSweepEvent(this, this.m_21205_(), target, range);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getBox();
    }

    @Override
    protected boolean performDamageTarget(Entity target, float damage, double kb) {
        return super.m_7327_(target);
    }

    @Override
    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (((Boolean)MGConfig.COMMON.strictInteract.get()).booleanValue() && !itemstack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            if (this.canModify(player)) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    this.dropSlot(slot, false);
                }
            }
            if (itemstack.m_41619_()) {
                super.mobInteractImpl(player, hand);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41619_()) {
            return super.mobInteractImpl(player, hand);
        }
        if (itemstack.m_41720_() instanceof GolemHolder || !itemstack.m_41720_().m_142095_() || !this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        GolemEquipEvent event = new GolemEquipEvent(this, itemstack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.canEquip()) {
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.m_21033_(event.getSlot())) {
                this.dropSlot(event.getSlot(), false);
            }
            if (this.m_21033_(event.getSlot())) {
                return InteractionResult.FAIL;
            }
            this.m_8061_(event.getSlot(), itemstack.m_41620_(event.getAmount()));
            int count = (int)Arrays.stream(EquipmentSlot.values()).filter(e -> !this.m_6844_((EquipmentSlot)e).m_41619_()).count();
            GolemTriggers.EQUIP.trigger((ServerPlayer)player, count);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public double m_6049_() {
        return -0.35;
    }

    protected void m_6472_(DamageSource source, float damage) {
        if (damage <= 0.0f) {
            return;
        }
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack itemstack = this.m_6844_(slot);
            if (source.m_269533_(DamageTypeTags.f_268745_) && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem)) continue;
            itemstack.m_41622_((int)damage, (LivingEntity)this, entity -> entity.m_21166_(slot));
        }
    }

    @Nullable
    public InteractionHand shieldSlot() {
        return this.m_6844_(EquipmentSlot.MAINHAND).canPerformAction(ToolActions.SHIELD_BLOCK) ? InteractionHand.MAIN_HAND : (this.m_6844_(EquipmentSlot.OFFHAND).canPerformAction(ToolActions.SHIELD_BLOCK) ? InteractionHand.OFF_HAND : null);
    }

    protected void m_7909_(float damage) {
        InteractionHand hand = this.shieldSlot();
        if (hand == null) {
            return;
        }
        ItemStack stack = this.m_21120_(hand);
        int i = damage < 3.0f ? 0 : 1 + Mth.m_14143_((float)damage);
        GolemDamageShieldEvent event = new GolemDamageShieldEvent(this, stack, hand, damage, i);
        MinecraftForge.EVENT_BUS.post((Event)event);
        i = event.getCost();
        if (i > 0) {
            stack.m_41622_(i, (LivingEntity)this, self -> self.m_21190_(hand));
        }
        if (stack.m_41619_()) {
            this.m_21008_(hand, ItemStack.f_41583_);
            this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        } else {
            this.m_5496_(SoundEvents.f_12346_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        }
    }

    protected void m_6728_(LivingEntity source) {
        super.m_6728_(source);
        InteractionHand hand = this.shieldSlot();
        if (hand == null) {
            return;
        }
        ItemStack stack = this.m_21120_(hand);
        boolean canDisable = source.m_213824_() || source.m_21205_().canDisableShield(stack, (LivingEntity)this, source);
        GolemDisableShieldEvent event = new GolemDisableShieldEvent(this, stack, hand, source, canDisable);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.shouldDisable()) {
            this.shieldCooldown = 100;
            this.m_9236_().m_7605_((Entity)this, (byte)30);
        }
    }

    @Override
    public void m_7822_(byte event) {
        if (event == 30) {
            this.shieldCooldown = 100;
        }
        super.m_7822_(event);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.shieldCooldown = Mth.m_14045_((int)(this.shieldCooldown - 1), (int)0, (int)100);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.attackStep();
    }

    public void attackStep() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.inventoryTick > 0) {
            return;
        }
        this.inventoryTick = 4;
        this.switchWeapon(this.getWrapperOfHand(EquipmentSlot.MAINHAND), !this.backupHand.m_41619_() ? this.getBackupHand() : this.getWrapperOfHand(EquipmentSlot.OFFHAND));
    }

    public ItemWrapper getBackupHand() {
        return ItemWrapper.simple(() -> this.backupHand, e -> {
            this.backupHand = e;
        });
    }

    public ItemWrapper getArrowSlot() {
        return ItemWrapper.simple(() -> this.arrowSlot, e -> {
            this.arrowSlot = e;
        });
    }

    private void switchWeapon(ItemWrapper mainhand, ItemWrapper offhand) {
        LivingEntity target = this.m_5448_();
        ItemStack main = mainhand.getItem();
        ItemStack off = offhand.getItem();
        if (main.m_41720_() instanceof ProjectileWeaponItem) {
            if (!this.m_6298_(main).m_41619_() && off.canPerformAction(ToolActions.SHIELD_BLOCK)) {
                return;
            }
            if (off.m_41619_() || off.m_41720_() instanceof ProjectileWeaponItem || off.m_41720_() instanceof ArrowItem) {
                return;
            }
            if (target == null || !this.meleeGoal.canReachTarget(target)) {
                return;
            }
        } else if (off.m_41720_() instanceof ProjectileWeaponItem) {
            boolean noArrow = this.m_6298_(off).m_41619_();
            if (noArrow) {
                return;
            }
            if (target != null && this.meleeGoal.canReachTarget(target)) {
                return;
            }
        } else if (!main.m_41619_() || off.m_41619_()) {
            return;
        }
        mainhand.setItem(off);
        offhand.setItem(main);
        this.reassessWeaponGoal();
        this.inventoryTick = 10;
    }

    @Override
    public void checkRide(LivingEntity target) {
        if (target instanceof DogGolemEntity || target instanceof AbstractHorse) {
            this.m_20329_((Entity)target);
        }
    }
}

