/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.blazegear;

import com.google.common.collect.ImmutableList;
import dev.xkmc.modulargolems.compat.materials.blazegear.BGCompatRegistry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.util.Arrays;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DuplicatedBlazeArmsModel<T extends AbstractGolemEntity<?, ?>>
extends ListModel<T> {
    private final ModelPart[] blazeSticks = new ModelPart[12];
    private final ImmutableList<ModelPart> parts;
    private float r3 = 7.0f;

    public DuplicatedBlazeArmsModel(ModelPart modelPart) {
        Arrays.setAll(this.blazeSticks, num -> modelPart.m_171324_(DuplicatedBlazeArmsModel.getPartName(num)));
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(Arrays.asList(this.blazeSticks));
        this.parts = builder.build();
    }

    private static String getPartName(int num) {
        return "part" + num;
    }

    public static LayerDefinition createBodyLayer() {
        float f9;
        float f7;
        float f5;
        int k;
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        float f = 0.0f;
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f);
        for (k = 0; k < 4; ++k) {
            f5 = Mth.m_14089_((float)f) * 9.0f;
            f7 = -2.0f + Mth.m_14089_((float)((float)(k * 2) * 0.25f));
            f9 = Mth.m_14031_((float)f) * 9.0f;
            partdefinition.m_171599_(DuplicatedBlazeArmsModel.getPartName(k), cubelistbuilder, PartPose.m_171419_((float)f5, (float)f7, (float)f9));
            f += 1.0f;
        }
        f = 0.7853982f;
        for (k = 4; k < 8; ++k) {
            f5 = Mth.m_14089_((float)f) * 7.0f;
            f7 = 2.0f + Mth.m_14089_((float)((float)(k * 2) * 0.25f));
            f9 = Mth.m_14031_((float)f) * 7.0f;
            partdefinition.m_171599_(DuplicatedBlazeArmsModel.getPartName(k), cubelistbuilder, PartPose.m_171419_((float)f5, (float)f7, (float)f9));
            f += 1.0f;
        }
        f = 0.47123894f;
        for (k = 8; k < 12; ++k) {
            f5 = Mth.m_14089_((float)f) * 5.0f;
            f7 = 11.0f + Mth.m_14089_((float)((float)k * 1.5f * 0.5f));
            f9 = Mth.m_14031_((float)f) * 5.0f;
            partdefinition.m_171599_(DuplicatedBlazeArmsModel.getPartName(k), cubelistbuilder, PartPose.m_171419_((float)f5, (float)f7, (float)f9));
            f += 1.0f;
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public Iterable<ModelPart> m_6195_() {
        return this.parts;
    }

    public void setupAnim(T livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int k;
        int rod = ((AbstractGolemEntity)((Object)livingEntity)).getModifiers().getOrDefault(BGCompatRegistry.BLAZING.get(), 0);
        float ySpeed = 1.0f;
        if (livingEntity.m_9236_().m_46758_(livingEntity.m_20183_())) {
            ySpeed += 1.5f * livingEntity.m_9236_().m_46722_(1.0f);
        }
        float y0 = livingEntity.m_20206_() / 1.8f;
        float dy = -(1.8f - livingEntity.m_20206_()) * 8.0f;
        float y1 = -5.0f;
        float y2 = 0.0f;
        float y3 = 13.1f;
        float r1 = 14.0f;
        float r2 = 12.0f;
        if (livingEntity.m_6047_()) {
            y1 += 3.0f;
            y2 += 4.0f;
            y3 += 0.1f;
            if (this.r3 <= 9.0f) {
                this.r3 += 0.1f;
            }
        } else if (this.r3 >= 7.0f) {
            this.r3 -= 0.1f;
        }
        float f = 0.47123894f + ageInTicks * (float)Math.PI * -0.05f;
        for (k = 8; k < 12; ++k) {
            this.blazeSticks[k].f_104207_ = rod > 0;
            this.blazeSticks[k].f_104201_ = y3 + Mth.m_14089_((float)(((float)k * 1.5f + ageInTicks) * 0.5f)) * ySpeed;
            this.blazeSticks[k].f_104200_ = Mth.m_14089_((float)f) * this.r3 - 1.0f;
            this.blazeSticks[k].f_104202_ = Mth.m_14031_((float)f) * this.r3;
            this.blazeSticks[k].f_104201_ *= y0;
            this.blazeSticks[k].f_104201_ -= dy;
            f += 1.0f;
        }
        --rod;
        f = ageInTicks * (float)Math.PI * -0.1f;
        for (k = 0; k < 4; ++k) {
            this.blazeSticks[k].f_104207_ = rod > 0;
            this.blazeSticks[k].f_104201_ = y1 + Mth.m_14089_((float)(((float)(k * 2) + ageInTicks) * 0.25f)) * ySpeed;
            this.blazeSticks[k].f_104200_ = Mth.m_14089_((float)f) * r1 - 1.0f;
            this.blazeSticks[k].f_104202_ = Mth.m_14031_((float)f) * r1;
            this.blazeSticks[k].f_104201_ *= y0;
            this.blazeSticks[k].f_104201_ -= dy;
            f += 1.0f;
        }
        --rod;
        f = 0.7853982f + ageInTicks * (float)Math.PI * 0.03f;
        for (k = 4; k < 8; ++k) {
            this.blazeSticks[k].f_104207_ = rod > 0;
            this.blazeSticks[k].f_104201_ = y2 + Mth.m_14089_((float)(((float)(k * 2) + ageInTicks) * 0.25f)) * ySpeed;
            this.blazeSticks[k].f_104200_ = Mth.m_14089_((float)f) * r2 - 1.0f;
            this.blazeSticks[k].f_104202_ = Mth.m_14031_((float)f) * r2;
            this.blazeSticks[k].f_104201_ *= y0;
            this.blazeSticks[k].f_104201_ -= dy;
            f += 1.0f;
        }
    }
}

