/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.curio;

import com.tterrag.registrate.util.entry.MenuEntry;
import dev.xkmc.l2tabs.compat.CuriosEventHandler;
import dev.xkmc.l2tabs.init.data.L2TabsLangData;
import dev.xkmc.modulargolems.compat.curio.GolemCurioTab;
import dev.xkmc.modulargolems.compat.curio.GolemCuriosListMenu;
import dev.xkmc.modulargolems.compat.curio.GolemCuriosListScreen;
import dev.xkmc.modulargolems.compat.curio.GolemCuriosMenuPvd;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.menu.registry.EquipmentGroup;
import dev.xkmc.modulargolems.content.menu.registry.GolemTabRegistry;
import dev.xkmc.modulargolems.content.menu.registry.IMenuPvd;
import dev.xkmc.modulargolems.content.menu.tabs.GolemTabToken;
import dev.xkmc.modulargolems.content.menu.tabs.ITabScreen;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CurioCompatRegistry {
    public static CurioCompatRegistry INSTANCE;
    public MenuEntry<GolemCuriosListMenu> menuType;
    public GolemTabToken<EquipmentGroup, GolemCurioTab> tab;

    @Nullable
    public static CurioCompatRegistry get() {
        if (ModList.get().isLoaded("curios")) {
            if (INSTANCE == null) {
                INSTANCE = new CurioCompatRegistry();
            }
            return INSTANCE;
        }
        return null;
    }

    public static void register() {
        CurioCompatRegistry ins = CurioCompatRegistry.get();
        if (ins == null) {
            return;
        }
        ins.registerImpl();
    }

    public static void clientRegister() {
        CurioCompatRegistry ins = CurioCompatRegistry.get();
        if (ins == null) {
            return;
        }
        ins.clientRegisterImpl();
    }

    public static <T> void onJEIRegistry(Consumer<Class<? extends ITabScreen>> consumer) {
        CurioCompatRegistry ins = CurioCompatRegistry.get();
        if (ins == null) {
            return;
        }
        ins.onJEIRegistryImpl(consumer);
    }

    public static IMenuPvd create(AbstractGolemEntity<?, ?> entity) {
        return new GolemCuriosMenuPvd((LivingEntity)entity, 0);
    }

    public static void tryOpen(ServerPlayer player, LivingEntity target) {
        if (CurioCompatRegistry.get() == null) {
            return;
        }
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)target).resolve();
        if (opt.isEmpty()) {
            return;
        }
        if (((ICuriosItemHandler)opt.get()).getSlots() == 0) {
            return;
        }
        GolemCuriosMenuPvd pvd = new GolemCuriosMenuPvd(target, 0);
        CuriosEventHandler.openMenuWrapped((ServerPlayer)player, () -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)pvd, pvd::writeBuffer));
    }

    public void registerImpl() {
        this.menuType = ModularGolems.REGISTRATE.menu("golem_curios", GolemCuriosListMenu::fromNetwork, () -> GolemCuriosListScreen::new).register();
    }

    public void clientRegisterImpl() {
        this.tab = new GolemTabToken(GolemCurioTab::new, () -> Items.f_41852_, (Component)L2TabsLangData.CURIOS.get(new Object[0]));
        GolemTabRegistry.LIST_EQUIPMENT.add(this.tab);
    }

    private void onJEIRegistryImpl(Consumer<Class<? extends ITabScreen>> consumer) {
        consumer.accept(GolemCuriosListScreen.class);
    }

    public ItemStack getSkin(HumanoidGolemEntity le) {
        return CuriosApi.getCuriosInventory((LivingEntity)le).resolve().flatMap(e -> e.getStacksHandler("golem_skin")).map(ICurioStacksHandler::getStacks).map(e -> e.getSlots() == 0 ? null : e.getStackInSlot(0)).orElse(ItemStack.f_41583_);
    }
}

