/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.AbstractModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.ConditionHelper;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookAndConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookOrConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public abstract class CategoryProvider {
    protected BookProvider parent;
    protected String categoryId;
    protected CategoryEntryMap entryMap;
    protected Map<String, String> macros;
    protected ConditionHelper conditionHelper;
    protected BookCategoryModel category;
    protected Map<String, List<BookPageModel>> cachedPages = new Object2ObjectOpenHashMap();

    public CategoryProvider(BookProvider parent, String categoryId) {
        this.parent = parent;
        this.categoryId = categoryId;
        this.entryMap = new CategoryEntryMap();
        this.macros = new Object2ObjectOpenHashMap();
        this.conditionHelper = new ConditionHelper();
        this.category = null;
    }

    public String categoryId() {
        return this.categoryId;
    }

    protected ModonomiconLanguageProvider lang() {
        return this.parent.lang();
    }

    protected ModonomiconLanguageProvider lang(String locale) {
        return this.parent.lang();
    }

    protected ResourceLocation modLoc(String name) {
        return this.parent.modLoc(name);
    }

    protected BookContextHelper context() {
        return this.parent.context();
    }

    protected ConditionHelper condition() {
        return this.parent.condition();
    }

    protected CategoryEntryMap entryMap() {
        return this.entryMap;
    }

    protected void registerMacro(String macro, String value) {
        this.macros.put(macro, value);
    }

    protected Map<String, String> macros() {
        return this.macros;
    }

    protected String macro(String input) {
        for (Map.Entry<String, String> entry : this.macros.entrySet()) {
            input = input.replace(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.parent.defaultMacros().entrySet()) {
            input = input.replace(entry.getKey(), entry.getValue());
        }
        return input;
    }

    protected String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected String entryLink(String text, String category, String entry) {
        return this.format("[{0}](entry://{1}/{2})", text, category, entry);
    }

    protected String categoryLink(String text, String category) {
        return this.format("[{0}](category://{1})", text, category);
    }

    protected String itemLink(ItemLike item) {
        return this.itemLink("", item);
    }

    protected String itemLink(String text, ItemLike item) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
        return this.format("[{0}](item://{1})", text, rl);
    }

    protected String commandLink(String text, String commandId) {
        return this.format("[{0}](command://{1})", text, commandId);
    }

    protected String entryLinkDummy(String text, String category, String entry) {
        return this.format("[{0}]()", text, category, entry);
    }

    protected String categoryLinkDummy(String text, String category) {
        return this.format("[{0}]()", text, category);
    }

    protected BookEntryModel entry(String location, ResourceLocation texture) {
        return this.entry(location).withIcon(texture);
    }

    protected BookEntryModel entry(String location, ResourceLocation texture, int width, int height) {
        return this.entry(location).withIcon(texture, width, height);
    }

    protected BookEntryModel entry(String location, ItemLike icon) {
        return this.entry(location).withIcon(icon);
    }

    protected BookEntryModel entry(char location, ResourceLocation texture) {
        return this.entry(location).withIcon(texture);
    }

    protected BookEntryModel entry(char location, ResourceLocation texture, int width, int height) {
        return this.entry(location).withIcon(texture, width, height);
    }

    protected BookEntryModel entry(char location, ItemLike icon) {
        return this.entry(location).withIcon(icon);
    }

    protected BookEntryModel entry(char location) {
        return this.entry().withLocation(this.entryMap().get(Character.valueOf(location)));
    }

    protected BookEntryModel entry(String location) {
        return this.entry().withLocation(this.entryMap().get(location));
    }

    protected BookEntryModel entry() {
        BookEntryModel entry = BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription());
        if (this.cachedPages.containsKey(this.context().entry())) {
            entry.withPages(this.cachedPages.get(this.context().entry()));
            this.cachedPages.remove(this.context().entry());
        }
        return entry;
    }

    protected <T extends BookPageModel> T page(T model) {
        this.cachedPages.computeIfAbsent(this.context().entry(), k -> new ArrayList()).add(model);
        return model;
    }

    protected <T extends BookPageModel> T page(String page, Supplier<T> modelSupplier) {
        this.context().page(page);
        BookPageModel model = (BookPageModel)modelSupplier.get();
        this.cachedPages.computeIfAbsent(this.context().entry(), k -> new ArrayList()).add(model);
        return (T)model;
    }

    protected BookEntryParentModel parent(BookEntryModel parentEntry) {
        return BookEntryParentModel.create(parentEntry.getId());
    }

    public BookAndConditionModel and(BookConditionModel ... children) {
        return this.condition().and(children);
    }

    public BookOrConditionModel or(BookConditionModel ... children) {
        return this.condition().or(children);
    }

    protected void add(String key, String value) {
        this.lang().add(key, this.macro(value));
    }

    protected void add(AbstractModonomiconLanguageProvider translation, String key, String value) {
        translation.add(key, this.macro(value));
    }

    protected void add(String key, String pattern, Object ... args) {
        this.add(key, this.format(pattern, args));
    }

    protected void add(AbstractModonomiconLanguageProvider translation, String key, String pattern, Object ... args) {
        this.add(translation, key, this.format(pattern, args));
    }

    protected BookEntryModel add(BookEntryModel entry) {
        this.category.withEntry(entry);
        return entry;
    }

    protected List<BookEntryModel> add(List<BookEntryModel> entries) {
        this.category.withEntries(entries);
        return entries;
    }

    public BookCategoryModel generate() {
        this.context().category(this.categoryId);
        this.entryMap().setMap(this.generateEntryMap());
        this.category = this.generateCategory();
        this.generateEntries();
        return this.category;
    }

    protected abstract String[] generateEntryMap();

    protected abstract void generateEntries();

    protected abstract BookCategoryModel generateCategory();
}

