/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.setup;

import mcjty.lib.McJtyLib;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.network.Networking;
import mcjty.lib.preferences.PreferencesDispatcher;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.setup.DefaultModSetup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ModSetup
extends DefaultModSetup {
    public static final ResourceLocation PREFERENCES_CAPABILITY_KEY = new ResourceLocation("mcjtylib", "preferences");
    public static boolean patchouli = false;
    public static Capability<PreferencesProperties> PREFERENCES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PreferencesProperties>(){});

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityContainerProvider.register(event);
        CapabilityInfusable.register(event);
        CapabilityPowerInformation.register(event);
        CapabilityModuleSupport.register(event);
        PreferencesProperties.register(event);
    }

    @Override
    public void init(FMLCommonSetupEvent e) {
        super.init(e);
        Networking.registerMessages();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @Override
    protected void setupModCompat() {
        patchouli = ModList.get().isLoaded("patchouli");
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START && !event.player.m_20193_().f_46443_) {
                McJtyLib.getPreferencesProperties(event.player).ifPresent(handler -> handler.tick((ServerPlayer)event.player));
            }
        }

        @SubscribeEvent
        public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player) {
                if (!event.getCapabilities().containsKey(PREFERENCES_CAPABILITY_KEY) && !((Entity)event.getObject()).getCapability(PREFERENCES_CAPABILITY).isPresent()) {
                    event.addCapability(PREFERENCES_CAPABILITY_KEY, (ICapabilityProvider)new PreferencesDispatcher());
                } else {
                    throw new IllegalStateException(((Entity)event.getObject()).toString());
                }
            }
        }
    }
}

