/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.SpatialDisorientation;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.SpatialDisorientationMahoujinEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.SpatialStaffRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class SpatialDisorientationStaff
extends ItemBase {
    public static HashMap<UUID, SpatialDisorientationStorage> staffs = new HashMap();

    public SpatialDisorientationStaff() {
        super("spatial_disorientation_staff", 1, 20);
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        float r = 1.0f;
        float g = 0.7372549f;
        float b = 0.12941177f;
        float a = 0.95f;
        if (player instanceof Player) {
            SpatialDisorientationStorage storage;
            if (staffs.containsKey(player.m_20148_())) {
                storage = staffs.get(player.m_20148_());
            } else {
                storage = new SpatialDisorientationStorage();
                staffs.put(player.m_20148_(), storage);
            }
            if (storage.target != null) {
                storage.target.m_20334_(0.0, 0.0, 0.0);
                if (!player.m_9236_().f_46443_) {
                    if (storage.mahoujin == null) {
                        if (PlayerManaManager.drainMana((Player)player, MTConfig.SPATIAL_DISORIENTATION_MANA_COST_ST, false, false) == MTConfig.SPATIAL_DISORIENTATION_MANA_COST_ST) {
                            SpatialDisorientationMahoujinEntity m = new SpatialDisorientationMahoujinEntity(player.m_9236_(), (Player)player, r, g, b, a);
                            m.sizer(storage.target.m_20205_() * 2.0f);
                            m.setRotationSpeed(0.25f);
                            storage.mahoujin = m;
                            this.reangle((Player)player, storage.target.m_20182_(), 2.125f, storage);
                            storage.target.m_9236_().m_7967_((Entity)m);
                        }
                    } else if (storage.mahoujin.getRotationSpeed() < 8.0f) {
                        storage.mahoujin.setRotationSpeed(storage.mahoujin.getRotationSpeed() + 0.1f);
                    }
                    this.reangle((Player)player, storage.target.m_20182_(), 2.125f, storage);
                }
            } else if (storage.location != null) {
                if (!player.m_9236_().f_46443_) {
                    if (storage.mahoujin == null) {
                        if (PlayerManaManager.hasMana((Player)player, MTConfig.SPATIAL_DISORIENTATION_MANA_COST_AOE * 10)) {
                            SpatialDisorientationMahoujinEntity m = new SpatialDisorientationMahoujinEntity(player.m_9236_(), (Player)player, r, g, b, a);
                            m.sizer(3.5f);
                            m.setRotationSpeed(0.25f);
                            storage.mahoujin = m;
                            this.reangle((Player)player, storage.location, 2.125f, storage);
                            player.m_9236_().m_7967_((Entity)m);
                        }
                    } else {
                        if (storage.mahoujin.getRotationSpeed() < 8.0f) {
                            storage.mahoujin.setRotationSpeed(storage.mahoujin.getRotationSpeed() + 0.1f);
                        }
                        this.reangle((Player)player, storage.location, 2.125f, storage);
                    }
                    if (count % 20 == 0 && PlayerManaManager.drainMana((Player)player, MTConfig.SPATIAL_DISORIENTATION_MANA_COST_AOE, false, false) == MTConfig.SPATIAL_DISORIENTATION_MANA_COST_AOE) {
                        PlayerManaManager.updateClientMahou((ServerPlayer)player, Utils.getPlayerMahou((Player)player));
                    } else if (count % 20 == 0) {
                        player.m_21253_();
                    }
                }
                if (storage.mahoujin != null && storage.mahoujin.getRotationSpeed() >= 8.0f && count % 4 == 0) {
                    double radius = MTConfig.SPATIAL_DISORIENTATION_AOE_RADIUS;
                    List entities = storage.mahoujin.m_9236_().m_6443_(Entity.class, new AABB(storage.location.f_82479_ - radius, storage.location.f_82480_ - radius, storage.location.f_82481_ - radius, storage.location.f_82479_ + radius, storage.location.f_82480_ + radius, storage.location.f_82481_ + radius), Entity::m_6084_);
                    for (Entity tmp : entities) {
                        Vec3 vec = Vec3.m_82498_((float)player.f_19858_, (float)player.f_19857_);
                        float speed = storage.mahoujin.getRotationSpeed() * 1.2f;
                        this.boop(tmp, (float)Math.min((double)speed, MTConfig.SPATIAL_DISORIENTATION_SPEED), vec.f_82479_, vec.f_82480_, vec.f_82481_);
                    }
                }
            }
        }
    }

    private void reangle(Player player, Vec3 target, float distance, SpatialDisorientationStorage storage) {
        if (storage.mahoujin != null && player != null && target != null) {
            storage.mahoujin.angleCircleAroundBlock(90.0f - player.f_19857_, player.f_19858_ + 90.0f, distance, new Vec3(target.f_82479_, target.f_82480_, target.f_82481_));
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.f_19812_ = true;
        entity.m_6853_(false);
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = entity.m_20184_();
        double motionX = motion.f_82479_;
        double motionY = motion.f_82480_;
        double motionZ = motion.f_82481_;
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX = x / (double)f * (double)strength;
        motionZ = z / (double)f * (double)strength;
        motionY = y / (double)f * (double)strength;
        entity.m_20334_(motionX, motionY, motionZ);
        if (!(!(entity instanceof LivingEntity) || entity instanceof Player && ((Player)entity).m_21255_() || MTConfig.SPATIAL_DISORIENTATION_AIR_RESISTANCE)) {
            EffectUtil.buff((LivingEntity)entity, ModEffects.FLUNG, false, 900, false);
        }
        entity.f_19864_ = true;
    }

    public int getRemainingUseDuration(ItemStack stack, int charge) {
        return this.m_8105_(stack) - charge;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        staffs.remove(player.m_20148_());
        SpatialDisorientationStorage storage = new SpatialDisorientationStorage();
        staffs.put(player.m_20148_(), storage);
        ItemStack stack = player.m_21120_(hand);
        Entity t = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.m_9236_(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR));
        if (t instanceof LivingEntity || t instanceof PrimedTnt) {
            storage.target = t;
            storage.location = null;
        } else {
            storage.target = null;
            HitResult result = player.m_19907_((double)MTConfig.GLOBAL_LOOK_RANGE, 0.0f, false);
            storage.location = !(result instanceof BlockHitResult) ? player.m_20154_().m_82541_().m_82490_(10.0).m_82549_(player.m_20299_(1.0f)) : new Vec3((double)((BlockHitResult)result).m_82425_().m_123341_() + 0.5, (double)(((BlockHitResult)result).m_82425_().m_123342_() + 5), (double)((BlockHitResult)result).m_82425_().m_123343_() + 0.5);
        }
        player.m_6672_(hand);
        storage.firstBounce = true;
        storage.mahoujin = null;
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        SpatialDisorientationStorage storage;
        super.m_5551_(stack, worldIn, entityLiving, timeLeft);
        if (staffs.containsKey(entityLiving.m_20148_())) {
            storage = staffs.get(entityLiving.m_20148_());
        } else {
            storage = new SpatialDisorientationStorage();
            staffs.put(entityLiving.m_20148_(), storage);
        }
        if (storage.mahoujin != null) {
            if (storage.target != null) {
                LivingEntity player = entityLiving;
                Vec3 vec = Vec3.m_82498_((float)player.f_19858_, (float)player.f_19857_);
                if (!storage.target.m_9236_().f_46443_ && player instanceof ServerPlayer && storage.target instanceof Pig && ((Pig)storage.target).m_20197_().contains(player)) {
                    ModTriggers.FLYING_PIGS.trigger((ServerPlayer)player);
                }
                this.boop(storage.target, (float)Math.min((double)(storage.mahoujin.getRotationSpeed() * 1.2f), MTConfig.SPATIAL_DISORIENTATION_SPEED), vec.f_82479_, vec.f_82480_, vec.f_82481_);
            }
            storage.mahoujin.m_146870_();
        }
    }

    public static Predicate<Entity> getProjectionLookPredicate() {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity e) {
                return e instanceof LivingEntity;
            }
        };
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(SpatialStaffRenderer::new);
    }

    public class SpatialDisorientationStorage {
        public Entity target = null;
        public SpatialDisorientationMahoujinEntity mahoujin = null;
        public Vec3 location = null;
        public boolean firstBounce = false;
    }
}

