/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.clarent.Clarent;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class GateWeaponProjectileEntity
extends Arrow {
    public static final String entityName = "gate_weapon_projectile_entity";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> PROGRESS = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(GateWeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float progress = 0.0f;
    public float lastProgress = 0.0f;

    public GateWeaponProjectileEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)ModEntities.GATE_WEAPON_PROJECTILE.get(), worldIn);
        this.f_19811_ = true;
    }

    public GateWeaponProjectileEntity(Level worldIn) {
        super((EntityType)ModEntities.GATE_WEAPON_PROJECTILE.get(), worldIn);
        this.f_19811_ = true;
        this.setStack(new ItemStack((ItemLike)Items.f_42383_));
    }

    public GateWeaponProjectileEntity(Level worldIn, double x, double y, double z, ItemStack stack, Entity e, float speed) {
        this(worldIn);
        this.f_19811_ = true;
        this.m_6034_(x, y, z);
        this.setStack(stack);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.m_5602_(e);
        this.setSpeed(speed);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_R2, (Object)Float.valueOf(r2));
        this.f_19804_.m_135381_(COLOR_G2, (Object)Float.valueOf(g2));
        this.f_19804_.m_135381_(COLOR_B2, (Object)Float.valueOf(b2));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getTColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_R2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B2)).floatValue()};
    }

    public GateWeaponProjectileEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ITEM, (Object)new ItemStack((ItemLike)Items.f_42383_));
        this.m_20088_().m_135372_(PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf((float)MTConfig.TREASURY_PROJECTION_SPEED));
        super.m_8097_();
    }

    public void m_7380_(CompoundTag nbt) {
        if (this.getStack() != null) {
            nbt.m_128365_("stackNBT", (Tag)this.getStack().serializeNBT());
        }
        nbt.m_128350_("progress", this.progress);
        float[] colors = this.getTColor();
        nbt.m_128350_(TAG_COLOR_R, colors[0]);
        nbt.m_128350_(TAG_COLOR_G, colors[1]);
        nbt.m_128350_(TAG_COLOR_B, colors[2]);
        nbt.m_128350_(TAG_COLOR_A, colors[3]);
        nbt.m_128350_(TAG_COLOR_R2, colors[4]);
        nbt.m_128350_(TAG_COLOR_G2, colors[5]);
        nbt.m_128350_(TAG_COLOR_B2, colors[6]);
        super.m_7380_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("stackNBT")) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt.m_128423_("stackNBT")));
            stack.m_41764_(1);
            this.setStack(stack);
        }
        this.progress = nbt.m_128457_("progress");
        this.setColor(nbt.m_128457_(TAG_COLOR_R), nbt.m_128457_(TAG_COLOR_G), nbt.m_128457_(TAG_COLOR_B), nbt.m_128457_(TAG_COLOR_A), nbt.m_128457_(TAG_COLOR_R2), nbt.m_128457_(TAG_COLOR_G2), nbt.m_128457_(TAG_COLOR_B2));
        super.m_7378_(nbt);
    }

    protected ItemStack m_7941_() {
        return this.getStack();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float v) {
        this.progress = v;
    }

    public static boolean shouldAvoid(Entity shooter, Entity target) {
        if (target instanceof LivingEntity && shooter instanceof Player) {
            return ContractMahoujinTileEntity.isImmuneToSpell(shooter.m_9236_(), shooter.m_20148_(), target) || GeasEffect.hasGeas((Player)shooter, (LivingEntity)target);
        }
        return false;
    }

    protected void m_5790_(EntityHitResult result) {
        double d = this.m_20184_().m_82553_();
        double damage = Mth.m_14165_((double)d);
        Entity entity = result.m_82443_();
        if (this.m_9236_() instanceof ServerLevel && !GateWeaponProjectileEntity.shouldAvoid(this.m_19749_(), entity)) {
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerLevel)this.m_9236_(), "faker");
            fake_player.m_21008_(InteractionHand.MAIN_HAND, this.m_7941_());
            fake_player.m_6853_(true);
            fake_player.m_21204_().m_22178_(this.m_7941_().m_41638_(EquipmentSlot.MAINHAND));
            fake_player.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.getStack().m_41720_() instanceof Clarent && this.m_19749_() instanceof Player) {
                    int mana = ClarentEffect.getManaCostClarent(this.getStack(), (Player)this.m_19749_());
                    PlayerManaManager.donateManaToFakePlayer(fake_player, (Player)this.m_19749_(), mana);
                }
                fake_player.f_20922_ = 1000;
                fake_player.m_5706_(entity);
                this.m_7761_(livingEntity);
                Entity shooter = null;
                if (this.m_19749_() != null && this.m_9236_() != null && (shooter = this.m_19749_()) != null && entity != shooter && livingEntity instanceof Player && shooter instanceof ServerPlayer) {
                    ((ServerPlayer)shooter).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
            }
        }
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    public void m_8119_() {
        this.m_6901_();
        this.m_6901_();
        this.lastProgress = this.getProgress();
        float progressCap = this.getProgressCap();
        if (this.getProgress() > progressCap) {
            super.m_8119_();
            if (this.f_36703_ && MTConfig.TREASURY_PROJECTION_DESPAWN_AFTER_LAND) {
                this.m_146870_();
            }
        } else {
            if (this.f_36703_) {
                this.setProgress(this.getProgressCap() + 1.0f);
            }
            float speed = this.getProgressSpeed();
            this.setProgress(this.getProgress() + progressCap / speed);
            Vec3 z = this.m_20184_();
            z = z.m_82541_().m_82490_((double)(progressCap / speed));
            z = z.m_82549_(this.m_20182_());
            this.m_6034_(z.f_82479_, z.f_82480_, z.f_82481_);
        }
    }

    public void m_6123_(Player player) {
    }

    public float getSpeed() {
        return ((Float)this.m_20088_().m_135370_(SPEED)).floatValue();
    }

    public void setSpeed(float s) {
        this.m_20088_().m_135381_(SPEED, (Object)Float.valueOf(s));
    }

    public ItemStack getStack() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM);
    }

    public void setStack(ItemStack stack) {
        this.m_20088_().m_135381_(ITEM, (Object)stack);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AABB m_6921_() {
        return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void setProgress() {
        this.setProgress(this.progress);
    }

    public float getProgressCap() {
        return 4.0f;
    }

    public float getProgressSpeed() {
        return (float)Math.max(MTConfig.TREASURY_PROJECTION_SPEED_MIN, (double)this.getSpeed());
    }
}

