/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.loadmyresources.pack;

import de.keksuccino.loadmyresources.LoadMyResources;
import java.io.File;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlags;

public class PackHandler {
    public static final String PACK_NAME = "loadmyresources.hiddenpack";
    public static final int PACK_FORMAT = 8;
    public static final String PACK_DESCRIPTION = "LMR Resources";
    public static final ResourceLocation DUMMY_PACK_META = new ResourceLocation("loadmyresources", "dummy.pack.mcmeta");
    public static File resourcesDirectory = new File(LoadMyResources.getGameDirectory(), "resources/");

    public static void init() {
        if (LoadMyResources.config != null) {
            resourcesDirectory = new File(LoadMyResources.getGameDirectory(), LoadMyResources.config.getOrDefault("resource_path", "resources/"));
        } else {
            LoadMyResources.LOGGER.error("[LOAD MY RESOURCES] ERROR: Config not loaded! Can't get resource path! Path set to default 'resources/'!");
        }
        LoadMyResources.LOGGER.info("[LOAD MY RESOURCES] PackHandler initialized!");
    }

    public static void prepareResourcesFolder() {
        if (!resourcesDirectory.isDirectory()) {
            resourcesDirectory.mkdirs();
        }
    }

    public static Pack createPack(Pack.ResourcesSupplier resources) {
        Pack.Info info = new Pack.Info((Component)Component.m_237113_((String)PACK_DESCRIPTION), 1, 8, FeatureFlags.f_244377_, true);
        return Pack.m_245512_((String)PACK_NAME, (Component)Component.m_237113_((String)PACK_NAME), (boolean)true, (Pack.ResourcesSupplier)resources, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)PackSource.f_10527_);
    }
}

