/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.loadmyresources;

import de.keksuccino.loadmyresources.pack.LMRRepositorySource;
import de.keksuccino.loadmyresources.pack.PackHandler;
import de.keksuccino.loadmyresources.utils.config.Config;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="loadmyresources")
public class LoadMyResources {
    public static final String VERSION = "1.0.4";
    public static final File HOME_DIR = new File(LoadMyResources.getGameDirectory(), "config/loadmyresources/");
    public static final Logger LOGGER = LogManager.getLogger();
    public static Config config;

    public LoadMyResources() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            if (!HOME_DIR.exists()) {
                HOME_DIR.mkdirs();
            }
            LoadMyResources.updateConfig();
            PackHandler.init();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterResourcePacks);
        } else {
            LOGGER.warn("## WARNING ## 'Load My Resources' is a client mod and has no effect when loaded on a server!");
        }
    }

    private void onRegisterResourcePacks(AddPackFindersEvent e) {
        e.addRepositorySource((RepositorySource)new LMRRepositorySource());
        LOGGER.info("[LOAD MY RESOURCES] Pack registered!");
    }

    public static void updateConfig() {
        try {
            config = new Config(HOME_DIR.getAbsolutePath() + "/config.cfg");
            config.registerValue("resource_path", "resources/", "general", "The path to load resources from.");
            config.syncConfig();
            config.clearUnusedValues();
        }
        catch (Exception e) {
            LoadMyResources.printStackTrace(e);
        }
    }

    public static void printStackTrace(Exception e) {
        for (StackTraceElement s : e.getStackTrace()) {
            LOGGER.error(s.toString());
        }
    }

    public static File getGameDirectory() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return Minecraft.m_91087_().f_91069_;
        }
        return new File("");
    }
}

