/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserGuiGraphics;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketGhostSlot;
import com.direwolf20.laserio.common.network.packets.PacketUpdateFilter;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilterCountScreen
extends AbstractContainerScreen<FilterCountContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/filtercount.png");
    protected final FilterCountContainer container;
    private ItemStack filter;
    private boolean isAllowList;
    private boolean isCompareNBT;

    public FilterCountScreen(FilterCountContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.filter = container.filterItem;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics = new LaserGuiGraphics(Minecraft.m_91087_(), guiGraphics.m_280091_());
        this.updateItemCounts();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (MiscTools.inBounds(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, mouseX, mouseY)) {
            if (this.isCompareNBT) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.nbttrue"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.nbtfalse"), mouseX, mouseY);
            }
        }
    }

    public void updateItemCounts() {
        FilterCountHandler handler = this.container.handler;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            stack.m_41764_(this.container.getStackSize(i));
        }
    }

    public void m_7856_() {
        super.m_7856_();
        Minecraft minecraft = Minecraft.m_91087_();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(minecraft.m_167982_(), minecraft.m_167973_());
        ArrayList<ToggleButton> leftWidgets = new ArrayList<ToggleButton>();
        this.isAllowList = FilterCount.getAllowList(this.filter);
        this.isCompareNBT = FilterCount.getCompareNBT(this.filter);
        ResourceLocation[] nbtTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/matchnbtfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/matchnbttrue.png")};
        leftWidgets.add(new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, nbtTextures, this.isCompareNBT ? 1 : 0, button -> {
            this.isCompareNBT = !this.isCompareNBT;
            ((ToggleButton)button).setTexturePosition(this.isCompareNBT ? 1 : 0);
        }));
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.m_142416_((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        PacketHandler.sendToServer(new PacketUpdateFilter(this.isAllowList, this.isCompareNBT));
        super.m_7379_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6375_(double x, double y, int btn) {
        if (this.f_97734_ == null || !(this.f_97734_ instanceof FilterBasicSlot)) {
            return super.m_6375_(x, y, btn);
        }
        ItemStack stack = ((FilterCountContainer)this.f_97732_).m_142621_();
        if (!stack.m_41619_()) {
            stack = stack.m_41777_();
            this.f_97734_.m_5852_(stack);
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.container.filterItem)) {
                return true;
            }
            PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, stack, stack.m_41613_()));
            this.container.handler.setStackInSlotSave(this.f_97734_.f_40219_, stack);
        } else {
            int amt;
            ItemStack slotStack = this.f_97734_.m_7993_();
            if (slotStack.m_41619_()) {
                return true;
            }
            if (btn == 2) {
                slotStack.m_41764_(0);
                PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_()));
                return true;
            }
            int n = amt = btn == 0 ? 1 : -1;
            if (Screen.m_96638_()) {
                amt *= 10;
            }
            if (Screen.m_96637_()) {
                amt *= 64;
            }
            if (amt + slotStack.m_41613_() > 4096) {
                amt = 4096 - slotStack.m_41613_();
            }
            slotStack.m_41769_(amt);
            PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_()));
            this.container.handler.setStackInSlotSave(this.f_97734_.f_40219_, slotStack);
        }
        return true;
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.f_97734_ == null || !(this.f_97734_ instanceof FilterBasicSlot)) {
            return super.m_6050_(mouseX, mouseY, delta);
        }
        ItemStack slotStack = this.f_97734_.m_7993_();
        if (slotStack.m_41619_()) {
            return true;
        }
        int amt = (int)delta;
        if (Screen.m_96638_()) {
            amt *= 10;
        }
        if (Screen.m_96637_()) {
            amt *= 64;
        }
        if (amt + slotStack.m_41613_() > 4096) {
            amt = 4096 - slotStack.m_41613_();
        }
        if (slotStack.m_41613_() + amt <= 0) {
            amt = slotStack.m_41613_() * -1 + 1;
        }
        slotStack.m_41769_(amt);
        PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_()));
        return true;
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.m_237110_((String)("laserio." + key), (Object[])args);
    }
}

