/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;

public abstract class OreChain
extends WorldSearch.BlockChain {
    protected int count = 0;
    protected final Miscellaneous miscellaneous;
    protected final Random random;

    protected OreChain(LevelAccessor level, BlockPos startPos, int maxLength, Miscellaneous miscellaneous, Random random) {
        super(level, startPos, maxLength);
        this.miscellaneous = miscellaneous;
        this.random = random;
    }

    public abstract boolean replaceWithOre(BlockPos var1);

    public OreChain generate() {
        this.count = 0;
        this.build();
        return this;
    }

    public int getCount() {
        return this.count;
    }

    protected Collection<Direction> getDirections() {
        GameWorld.Directions directions = GameWorld.Directions.of();
        for (Direction.Axis axis : Direction.Axis.values()) {
            Direction.Plane plane = axis.m_122480_();
            if (!this.isValidPlane(plane)) continue;
            plane.m_122557_().forEach(arg_0 -> ((GameWorld.Directions)directions).add(arg_0));
            this.getGroupingDirection(axis).ifPresent(arg_0 -> ((GameWorld.Directions)directions).add(arg_0));
        }
        return directions.shuffle(this.random).toList();
    }

    protected Optional<Direction> getGroupingDirection(Direction.Axis axis) {
        List chain = this.getChain().elements();
        if (chain.isEmpty()) {
            return Optional.empty();
        }
        BlockPos pos = (BlockPos)chain.get(chain.size() - 1);
        int delta = pos.m_123304_(axis) - this.startPos.m_123304_(axis);
        if (delta == 0) {
            return Optional.empty();
        }
        Direction.AxisDirection axisDirection = delta > 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE;
        return Optional.of(Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)axis));
    }

    protected boolean isValidPlane(Direction.Plane plane) {
        float props = this.miscellaneous.proportions;
        switch (plane) {
            case VERTICAL: {
                return props < 1.0f ? CommonMath.Random.result((float)props) : true;
            }
            case HORIZONTAL: {
                return props > 1.0f ? CommonMath.Random.result((float)(1.0f / props)) : true;
            }
        }
        return false;
    }

    protected boolean isValidPath(BlockPos pos) {
        return this.getLastFound().map(p -> p.equals((Object)pos)).orElse(false);
    }

    protected Optional<BlockPos> getLastFound() {
        int lastIndex = this.getFound().size() - 1;
        return lastIndex >= 0 ? Optional.of((BlockPos)this.getFound().get(lastIndex)) : Optional.empty();
    }

    protected boolean onValidFound(BlockPos pos) {
        if (this.replaceWithOre(pos)) {
            ++this.count;
        }
        return true;
    }
}

