/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.landmines;

import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.landmines.LandmineType;
import com.supermartijn642.landmines.LandminesClient;
import com.supermartijn642.landmines.generators.LandmineBlockStateGenerator;
import com.supermartijn642.landmines.generators.LandmineLanguageGenerator;
import com.supermartijn642.landmines.generators.LandmineLootTableGenerator;
import com.supermartijn642.landmines.generators.LandmineModelGenerator;
import com.supermartijn642.landmines.generators.LandmineRecipeGenerator;
import com.supermartijn642.landmines.generators.LandmineTagGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod(value="landmines")
public class Landmines {
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"landmines", LandmineType.EXPLOSIVE::getItem);
    @RegistryEntryAcceptor(namespace="landmines", identifier="trigger_sound", registry=RegistryEntryAcceptor.Registry.SOUND_EVENTS)
    public static SoundEvent trigger_sound;

    public Landmines() {
        Landmines.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> LandminesClient::register);
        Landmines.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"landmines");
        for (LandmineType type : LandmineType.values()) {
            handler.registerBlockCallback(type::registerBlock);
            handler.registerBlockEntityTypeCallback(type::registerBlockEntity);
            handler.registerItemCallback(type::registerItem);
        }
        handler.registerSoundEvent("trigger_sound", SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("landmines", "trigger_sound")));
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"landmines");
        handler.addGenerator(LandmineModelGenerator::new);
        handler.addGenerator(LandmineBlockStateGenerator::new);
        handler.addGenerator(LandmineLanguageGenerator::new);
        handler.addGenerator(LandmineLootTableGenerator::new);
        handler.addGenerator(LandmineRecipeGenerator::new);
        handler.addGenerator(LandmineTagGenerator::new);
    }
}

