/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.landmines;

import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.landmines.LandmineBlock;
import com.supermartijn642.landmines.LandmineBlockEntity;
import com.supermartijn642.landmines.LandmineEffect;
import com.supermartijn642.landmines.Landmines;
import com.supermartijn642.landmines.LandminesConfig;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public enum LandmineType {
    EXPLOSIVE(LandminesConfig.explosionReusable, false, null, null, LandmineEffect.EXPLOSION, "Explosive", "Explodes when triggered."),
    POTION(LandminesConfig.potionReusable, false, stack -> stack.m_41720_() == Items.f_42736_ || stack.m_41720_() == Items.f_42739_, Items.f_42589_, LandmineEffect.POTION, "Potion", "Throws a potion when triggered."),
    LAUNCH(LandminesConfig.launchReusable, true, null, null, LandmineEffect.LAUNCH, "Launch", "Launches players and mobs into the air when triggered."),
    TELEPORT(LandminesConfig.teleportReusable, false, stack -> stack.m_41720_() == Items.f_42730_, Items.f_42730_, LandmineEffect.TELEPORT, "Teleport", "Teleports players and mobs when triggered."),
    FIRE(LandminesConfig.fireReusable, false, stack -> stack.m_41720_() == Items.f_42613_, Items.f_42613_, LandmineEffect.FIRE, "Fire", "Sets players and mobs on fire when triggered."),
    SNOW(LandminesConfig.snowReusable, false, stack -> stack.m_41720_() == Items.f_41981_, Items.f_41981_, LandmineEffect.SNOW, "Snow", "Spawns snow when triggered."),
    ZOMBIE(LandminesConfig.zombieReusable, false, null, null, LandmineEffect.ZOMBIE, "Zombie", "Spawns zombies when triggered."),
    LEVITATION(LandminesConfig.levitationReusable, true, null, null, LandmineEffect.LEVITATION, "Levitation", "Gives players and mobs levitation when triggered."),
    LIGHTNING(LandminesConfig.lightningReusable, true, null, null, LandmineEffect.LIGHTNING, "Lightning", "Strikes lightning when triggered."),
    ARROWS(LandminesConfig.arrowsReusable, false, stack -> stack.m_41720_() == Items.f_42412_, Items.f_42412_, LandmineEffect.ARROWS, "Arrow", "Shoots out arrows when triggered."),
    FAKE(LandminesConfig.fakeReusable, false, null, null, LandmineEffect.NOTHING, "Fake", "A fake landmine disguised as an Explosive Landmine.");

    private BaseBlockEntityType<LandmineBlockEntity> blockEntityType;
    private LandmineBlock block;
    private BaseBlockItem item;
    public final Supplier<Boolean> reusable;
    public final boolean instantTrigger;
    public final Predicate<ItemStack> itemFilter;
    public final Item tooltipItem;
    public final LandmineEffect effect;
    public final String englishTranslation;
    public final String englishDescription;

    private LandmineType(Supplier<Boolean> reusable, boolean instantTrigger, Predicate<ItemStack> itemFilter, Item tooltipItem, LandmineEffect effect, String englishTranslation, String englishDescription) {
        this.reusable = reusable;
        this.instantTrigger = instantTrigger;
        this.itemFilter = itemFilter;
        this.tooltipItem = tooltipItem;
        this.effect = effect;
        this.englishTranslation = englishTranslation;
        this.englishDescription = englishDescription;
    }

    public String getSuffix() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public LandmineBlock getBlock() {
        return this.block;
    }

    public LandmineBlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        return new LandmineBlockEntity(this, pos, state);
    }

    public BaseBlockEntityType<LandmineBlockEntity> getBlockEntityType() {
        return this.blockEntityType;
    }

    public BaseBlockItem getItem() {
        return this.item;
    }

    public void registerBlock(RegistrationHandler.Helper<Block> helper) {
        if (this.block != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        this.block = new LandmineBlock(this);
        helper.register(this.getSuffix() + "_landmine", (Object)this.block);
    }

    public void registerBlockEntity(RegistrationHandler.Helper<BlockEntityType<?>> helper) {
        if (this.blockEntityType != null) {
            throw new IllegalStateException("Block entities have already been registered!");
        }
        if (this.block == null) {
            throw new IllegalStateException("Blocks must be registered before registering block entity types!");
        }
        this.blockEntityType = BaseBlockEntityType.create(this::getBlockEntity, (Block[])new Block[]{this.block});
        helper.register(this.getSuffix() + "_landmine_tile_entity", this.blockEntityType);
    }

    public void registerItem(RegistrationHandler.Helper<Item> helper) {
        if (this.item != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.block == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        this.item = new BaseBlockItem((Block)this.block, ItemProperties.create().group((CreativeModeTab)Landmines.GROUP));
        helper.register(this.getSuffix() + "_landmine", (Object)this.item);
    }
}

