/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.landmines;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.landmines.LandmineBlock;
import com.supermartijn642.landmines.LandmineBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;

public class LandmineRenderer
implements CustomBlockEntityRenderer<LandmineBlockEntity> {
    private static final int TRANSITION_TIME = 10;
    private static final int BLINK_TIME = 8;

    public void render(LandmineBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, LandmineRenderer.getRenderOffset(entity, partialTicks), 0.0);
        BlockState state = entity.getRenderBlockState();
        if (entity.getState() != LandmineBlockEntity.LandmineState.UNARMED) {
            state = (BlockState)state.m_61124_((Property)LandmineBlock.ON, (Comparable)Boolean.valueOf(entity.renderTransitionTicks / 8 % 2 == 0));
        }
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), ModelData.EMPTY)) {
            ClientUtils.getBlockRenderer().m_110937_().renderModel(poseStack.m_85850_(), bufferSource.m_6299_(renderType), state, model, 0.0f, 0.0f, 0.0f, combinedLight, combinedOverlay, ModelData.EMPTY, renderType);
        }
        poseStack.m_85849_();
    }

    private static double getRenderOffset(LandmineBlockEntity entity, float partialTicks) {
        double targetPosition = LandmineRenderer.getTargetPosition(entity.getState());
        double fromPosition = LandmineRenderer.getTargetPosition(entity.getLastState());
        return fromPosition + (targetPosition - fromPosition) * (double)Math.min(1.0f, ((float)entity.renderTransitionTicks + partialTicks) / 10.0f);
    }

    private static double getTargetPosition(LandmineBlockEntity.LandmineState state) {
        return state == LandmineBlockEntity.LandmineState.UNARMED ? 0.0 : (state == LandmineBlockEntity.LandmineState.ARMED ? -0.125 : (state == LandmineBlockEntity.LandmineState.TRIGGERED ? 0.0 : 0.0));
    }
}

