/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.landmines;

import com.supermartijn642.landmines.LandminesConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public interface LandmineEffect {
    public static final LandmineEffect NOTHING = (level, pos, stack) -> {};
    public static final LandmineEffect EXPLOSION = (level, pos, stack) -> {
        if (!level.f_46443_) {
            level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3.0f, LandminesConfig.explosionCausesFire.get().booleanValue(), LandminesConfig.explosionBreakBlocks.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        }
    };
    public static final LandmineEffect POTION = (level, pos, stack) -> {
        if (!level.f_46443_) {
            boolean isWater;
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            List mobEffects = PotionUtils.m_43547_((ItemStack)stack);
            boolean bl = isWater = potion == Potions.f_43599_ && mobEffects.isEmpty();
            if (isWater) {
                area = new AABB(pos).m_82377_(4.0, 2.0, 4.0);
                List entities = level.m_6443_(LivingEntity.class, area, LivingEntity::m_6126_);
                for (LivingEntity entity : entities) {
                    double distance = area.m_82399_().m_82531_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    if (!(distance < 16.0) || !entity.m_6126_()) continue;
                    entity.m_6469_(entity.m_269291_().m_269104_((Entity)entity, null), 1.0f);
                }
            } else if (!mobEffects.isEmpty()) {
                if (stack.m_41720_() == Items.f_42739_) {
                    AreaEffectCloud effectCloud = new AreaEffectCloud(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
                    effectCloud.m_19712_(3.0f);
                    effectCloud.m_19732_(-0.5f);
                    effectCloud.m_19740_(10);
                    effectCloud.m_19738_(-effectCloud.m_19743_() / (float)effectCloud.m_19748_());
                    effectCloud.m_19722_(potion);
                    for (MobEffectInstance effectInstance : PotionUtils.m_43571_((ItemStack)stack)) {
                        effectCloud.m_19716_(new MobEffectInstance(effectInstance));
                    }
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null && tag.m_128425_("CustomPotionColor", 99)) {
                        effectCloud.m_19714_(tag.m_128451_("CustomPotionColor"));
                    }
                    level.m_7967_((Entity)effectCloud);
                } else {
                    area = new AABB(pos).m_82377_(4.0, 2.0, 4.0);
                    List entities = level.m_45976_(LivingEntity.class, area);
                    for (LivingEntity entity : entities) {
                        double distance;
                        if (!entity.m_5801_() || !((distance = area.m_82399_().m_82531_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())) < 16.0)) continue;
                        double closenessFactor = 1.0 - Math.sqrt(distance) / 4.0;
                        for (MobEffectInstance effectInstance : mobEffects) {
                            MobEffect effect = effectInstance.m_19544_();
                            if (effect.m_8093_()) {
                                effect.m_19461_(null, null, entity, effectInstance.m_19564_(), closenessFactor);
                                continue;
                            }
                            int duration = (int)(closenessFactor * (double)effectInstance.m_19557_() + 0.5);
                            if (duration <= 20) continue;
                            entity.m_7292_(new MobEffectInstance(effect, duration, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_()));
                        }
                    }
                }
            }
            int i = potion.m_43491_() ? 2007 : 2002;
            level.m_46796_(i, pos, PotionUtils.m_43575_((ItemStack)stack));
        }
    };
    public static final LandmineEffect LAUNCH = (level, pos, stack) -> {
        level.m_45976_(Entity.class, new AABB(pos).m_82400_(0.3)).forEach(entity -> entity.m_5997_(0.0, LandminesConfig.launchForce.get().doubleValue(), 0.0));
        level.m_5594_(null, pos, SoundEvents.f_12312_, SoundSource.BLOCKS, 1.0f, 0.8f);
    };
    public static final LandmineEffect TELEPORT = (level, pos, stack) -> {
        if (!level.f_46443_) {
            double range = LandminesConfig.teleportRange.get();
            level.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(0.7)).forEach(entity -> {
                double entityX = entity.m_20185_();
                double entityY = entity.m_20186_();
                double entityZ = entity.m_20189_();
                for (int i = 0; i < 16; ++i) {
                    double teleportX = entity.m_20185_() + (level.m_213780_().m_188500_() - 0.5) * 2.0 * range;
                    double teleportY = Mth.m_14008_((double)(entity.m_20186_() + (level.m_213780_().m_188500_() - 0.5) * 2.0 * range), (double)0.0, (double)(level.m_141928_() - 1));
                    double teleportZ = entity.m_20189_() + (level.m_213780_().m_188500_() - 0.5) * 2.0 * range;
                    if (entity.m_20159_()) {
                        entity.m_8127_();
                    }
                    if (!entity.m_20984_(teleportX, teleportY, teleportZ, true)) continue;
                    SoundEvent soundEvent = entity instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                    level.m_6263_(null, entityX, entityY, entityZ, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                    entity.m_5496_(soundEvent, 1.0f, 1.0f);
                    break;
                }
            });
        }
    };
    public static final LandmineEffect FIRE = (level, pos, stack) -> level.m_45976_(Entity.class, new AABB(pos).m_82400_(0.7)).forEach(entity -> {
        if (!(entity instanceof Player) || !((Player)entity).m_7500_()) {
            entity.m_20254_(LandminesConfig.fireDuration.get().intValue());
        }
    });
    public static final LandmineEffect SNOW = (level, pos, stack) -> {
        if (!level.f_46443_) {
            int maxRange = LandminesConfig.snowRange.get();
            for (int x = -maxRange; x <= maxRange; ++x) {
                for (int y = 1; y >= -1; --y) {
                    for (int z = -maxRange; z <= maxRange; ++z) {
                        int distance = x * x + z * z;
                        if (distance > maxRange * maxRange || !level.m_46859_(pos.m_7918_(x, y, z))) continue;
                        int layers = level.m_213780_().m_188503_(Math.min(7, Math.max(1, (int)Math.ceil(((double)maxRange - Math.sqrt(distance)) / (double)maxRange * 7.0))) + 1) + 1;
                        BlockState state = Blocks.f_50125_.m_49966_();
                        if (!(state = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(level.m_213780_().m_188503_(layers) + 1))).m_60710_((LevelReader)level, pos.m_7918_(x, y, z))) continue;
                        level.m_7731_(pos.m_7918_(x, y, z), state, 3);
                    }
                }
            }
        }
    };
    public static final LandmineEffect ZOMBIE = (level, pos, stack) -> {
        if (!level.f_46443_) {
            int spawnRange = LandminesConfig.zombieRange.get();
            int spawns = 0;
            int targetSpawns = LandminesConfig.zombieCount.get();
            for (int attempts = 0; attempts < Math.max(20, targetSpawns * 3); ++attempts) {
                Entity zombie;
                int z;
                int y;
                int x = (int)((level.m_213780_().m_188500_() - 0.5) * 2.0 * (double)spawnRange);
                BlockPos spawnPos = pos.m_7918_(x, y = level.m_213780_().m_188503_(5) - 2, z = (int)((level.m_213780_().m_188500_() - 0.5) * 2.0 * (double)spawnRange));
                if (level.m_8055_(spawnPos.m_7495_()).m_60812_((BlockGetter)level, spawnPos.m_7495_()).m_83281_() || !level.m_8055_(spawnPos).m_60812_((BlockGetter)level, spawnPos).m_83281_() || !level.m_8055_(spawnPos.m_7494_()).m_60812_((BlockGetter)level, spawnPos.m_7494_()).m_83281_() || (zombie = EntityType.f_20501_.m_20592_((ServerLevel)level, (ItemStack)null, null, spawnPos, MobSpawnType.TRIGGERED, true, false)) == null || ++spawns != targetSpawns) continue;
                return;
            }
        }
    };
    public static final LandmineEffect LEVITATION = (level, pos, stack) -> {
        int duration = LandminesConfig.levitationDuration.get();
        level.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(0.7)).forEach(entity -> entity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, duration, 1, true, false)));
    };
    public static final LandmineEffect LIGHTNING = (level, pos, stack) -> {
        if (!level.f_46443_) {
            EntityType.f_20465_.m_20592_((ServerLevel)level, (ItemStack)null, null, pos, MobSpawnType.TRIGGERED, true, false);
        }
    };
    public static final LandmineEffect ARROWS = (level, pos, stack) -> {
        if (!level.f_46443_) {
            int arrows = LandminesConfig.arrowsCount.get();
            for (int i = 0; i < arrows; ++i) {
                double angle = Math.PI * 2 / (double)arrows * (double)i;
                Arrow entity = new Arrow(level, (double)pos.m_123341_() + 0.5 + Math.cos(angle), (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5 + Math.sin(angle));
                entity.m_20334_(0.2 * Math.cos(angle) + level.m_213780_().m_188500_() * 0.2 - 0.1, 0.2 + level.m_213780_().m_188500_() * 0.2 - 0.1, 0.2 * Math.sin(angle) + level.m_213780_().m_188500_() * 0.2 - 0.1);
                entity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                level.m_7967_((Entity)entity);
            }
        }
    };

    public void applyEffect(Level var1, BlockPos var2, ItemStack var3);
}

