/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.landmines;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.landmines.LandmineBlock;
import com.supermartijn642.landmines.LandmineType;
import com.supermartijn642.landmines.Landmines;
import com.supermartijn642.landmines.LandminesConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class LandmineBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    public final LandmineType f_58855_;
    private LandmineState state;
    private LandmineState lastState;
    public boolean collision;
    public int cooldown;
    private ItemStack stack;
    public int renderTransitionTicks;

    public LandmineBlockEntity(LandmineType type, BlockPos pos, BlockState state) {
        super(type.getBlockEntityType(), pos, state);
        this.lastState = this.state = LandmineState.UNARMED;
        this.stack = ItemStack.f_41583_;
        this.renderTransitionTicks = 0;
        this.f_58855_ = type;
    }

    public void update() {
        if (this.state == LandmineState.ARMED) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        } else if (this.state == LandmineState.TRIGGERED) {
            if (!this.collision) {
                this.trigger();
            } else {
                this.collision = false;
            }
        }
        ++this.renderTransitionTicks;
    }

    public boolean onRightClick(Player player, InteractionHand hand) {
        if (this.state == LandmineState.UNARMED) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_()) {
                if (player.m_6047_()) {
                    if (this.f_58855_.itemFilter == null || !this.stack.m_41619_()) {
                        this.updateState(LandmineState.ARMED);
                        this.cooldown = LandminesConfig.activationDelay.get();
                        this.dataChanged();
                        return true;
                    }
                    if (this.f_58855_.tooltipItem != null && !this.f_58857_.f_46443_) {
                        player.m_5661_((Component)TextComponents.translation((String)"landmines.require_item", (Object[])new Object[]{TextComponents.block((Block)this.f_58855_.getBlock()).get(), TextComponents.item((Item)this.f_58855_.tooltipItem).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.YELLOW).get(), true);
                    }
                } else if (!this.stack.m_41619_()) {
                    player.m_21008_(hand, this.stack);
                    this.stack = ItemStack.f_41583_;
                    this.dataChanged();
                    return true;
                }
            } else if (this.stack.m_41619_() && this.f_58855_.itemFilter != null && this.f_58855_.itemFilter.test(stack)) {
                this.stack = stack.m_41777_();
                this.stack.m_41764_(1);
                stack.m_41774_(1);
                player.m_21008_(hand, stack);
                this.dataChanged();
                return true;
            }
        }
        return false;
    }

    public void onEntityCollide(Entity entity) {
        if (this.state == LandmineState.ARMED) {
            if (this.cooldown > 0) {
                return;
            }
            this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, Landmines.trigger_sound, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (this.f_58855_.instantTrigger) {
                this.trigger();
            } else {
                this.updateState(LandmineState.TRIGGERED);
                this.collision = true;
                this.dataChanged();
            }
        } else if (this.state == LandmineState.TRIGGERED) {
            this.collision = true;
        }
    }

    private void trigger() {
        ItemStack stack = this.stack;
        if (this.f_58855_.reusable.get().booleanValue()) {
            this.updateState(LandmineState.UNARMED);
            this.stack = ItemStack.f_41583_;
            this.collision = false;
        } else if (this.m_58900_().m_60734_() instanceof LandmineBlock) {
            this.f_58857_.m_7471_(this.m_58899_(), false);
        }
        this.f_58855_.effect.applyEffect(this.f_58857_, this.m_58899_(), stack);
    }

    private void updateState(LandmineState state) {
        this.lastState = this.state;
        this.state = state;
        this.renderTransitionTicks = 0;
        this.m_6596_();
    }

    public boolean hasShape() {
        return this.state == LandmineState.UNARMED;
    }

    public LandmineState getState() {
        return this.state;
    }

    public LandmineState getLastState() {
        return this.lastState;
    }

    public BlockState getRenderBlockState() {
        return (BlockState)this.f_58855_.getBlock().m_49966_().m_61124_((Property)LandmineBlock.ON, (Comparable)Boolean.valueOf(this.state == LandmineState.UNARMED && (this.f_58855_.itemFilter == null || !this.stack.m_41619_())));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public AABB getRenderBoundingBox() {
        return BlockShape.createBlockShape((double)3.0, (double)-2.0, (double)3.0, (double)13.0, (double)1.125, (double)13.0).offset(this.m_58899_()).simplify();
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("state", this.state.index);
        compound.m_128405_("lastState", this.lastState.index);
        compound.m_128379_("collision", this.collision);
        compound.m_128405_("cooldown", this.cooldown);
        compound.m_128365_("stack", (Tag)this.stack.serializeNBT());
        compound.m_128405_("renderTransitionTicks", this.renderTransitionTicks);
        return compound;
    }

    protected void readData(CompoundTag compound) {
        this.state = LandmineState.fromIndex(compound.m_128451_("state"));
        this.lastState = LandmineState.fromIndex(compound.m_128451_("lastState"));
        this.collision = compound.m_128471_("collision");
        this.cooldown = compound.m_128451_("cooldown");
        this.stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("stack"));
        this.renderTransitionTicks = compound.m_128451_("renderTransitionTicks");
    }

    public static enum LandmineState {
        UNARMED(0),
        ARMED(1),
        TRIGGERED(2);

        private final int index;

        private LandmineState(int index) {
            this.index = index;
        }

        private static LandmineState fromIndex(int index) {
            for (LandmineState state : LandmineState.values()) {
                if (state.index != index) continue;
                return state;
            }
            return null;
        }
    }
}

