/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.landmines;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.landmines.LandmineBlockEntity;
import com.supermartijn642.landmines.LandmineType;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LandmineBlock
extends BaseBlock
implements EntityHoldingBlock,
SimpleWaterloggedBlock {
    private static final BlockShape SHAPE = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)0.75, (double)13.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)5.0, (double)0.75, (double)5.0, (double)11.0, (double)1.25, (double)11.0)});
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");
    public final LandmineType type;

    public LandmineBlock(LandmineType type) {
        super(false, BlockProperties.create().mapColor(MapColor.f_283818_).sound(SoundType.f_56743_).destroyTime(0.5f).explosionResistance(0.5f));
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity entity = level.m_7702_(pos);
        return entity instanceof LandmineBlockEntity && !((LandmineBlockEntity)entity).hasShape() ? BlockShape.empty().getUnderlying() : SHAPE.getUnderlying();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor level, BlockPos pos, BlockPos pos2) {
        return state.m_60710_((LevelReader)level, pos) ? super.m_7417_(state, direction, state2, level, pos, pos2) : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return LandmineBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return this.type.getBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON, BlockStateProperties.f_61362_});
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LandmineBlockEntity) {
            ((LandmineBlockEntity)blockEntity).onEntityCollide(entity);
        }
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof LandmineBlockEntity) {
            return ((LandmineBlockEntity)entity).onRightClick(player, hand) ? BaseBlock.InteractionFeedback.SUCCESS : BaseBlock.InteractionFeedback.PASS;
        }
        return super.interact(state, level, pos, player, hand, hitSide, hitLocation);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof LandmineBlockEntity) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((LandmineBlockEntity)entity).getStack());
            }
            super.m_6810_(state, level, pos, newState, p_196243_5_);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BlockShape.empty().getUnderlying();
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)("landmines." + this.type.getSuffix() + ".info")).color(ChatFormatting.GRAY).get());
        if (this.type.itemFilter != null && this.type.tooltipItem != null) {
            info.accept((Component)TextComponents.translation((String)"landmines.info.item", (Object[])new Object[]{TextComponents.item((Item)this.type.tooltipItem).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        }
        info.accept((Component)TextComponents.translation((String)"landmines.info.reusable", (Object[])new Object[]{TextComponents.translation((String)("landmines.info.reusable." + this.type.reusable.get())).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
    }
}

