/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters;

import com.github.L_Ender.cataclysm.client.sound.IABossMusicPlayer;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.Internal_Animation_Monster;
import com.github.L_Ender.cataclysm.init.ModTag;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class IABoss_monster
extends Internal_Animation_Monster
implements Enemy {
    protected boolean dropAfterDeathAnim = false;
    private static final byte MUSIC_PLAY_ID = 67;
    private static final byte MUSIC_STOP_ID = 68;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] socketPosArray;

    public IABoss_monster(EntityType entity, Level world) {
        super(entity, world);
        if (world.f_46443_) {
            this.socketPosArray = new Vec3[0];
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, damage);
        }
        damage = Math.min(this.DamageCap(), damage);
        return super.m_6469_(source, damage);
    }

    public float DamageCap() {
        return Float.MAX_VALUE;
    }

    public static void setConfigattribute(LivingEntity entity, double hpconfig, double dmgconfig) {
        AttributeInstance attackDamageAttr;
        AttributeInstance maxHealthAttr = entity.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            double difference = maxHealthAttr.m_22115_() * hpconfig - maxHealthAttr.m_22115_();
            maxHealthAttr.m_22118_(new AttributeModifier(UUID.fromString("3e3044eb-f8eb-4da6-9826-83136bd309a8"), "Health config multiplier", difference, AttributeModifier.Operation.ADDITION));
            entity.m_21153_(entity.m_21233_());
        }
        if ((attackDamageAttr = entity.m_21051_(Attributes.f_22281_)) != null) {
            double difference = attackDamageAttr.m_22115_() * dmgconfig - attackDamageAttr.m_22115_();
            attackDamageAttr.m_22118_(new AttributeModifier(UUID.fromString("d74ebed2-2c4c-47d0-8d3d-32a3ab305d1b"), "Attack config multiplier", difference, AttributeModifier.Operation.ADDITION));
        }
    }

    public double calculateRange(DamageSource damagesource) {
        return damagesource.m_7639_() != null ? this.m_20280_(damagesource.m_7639_()) : -1.0;
    }

    @Override
    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.m_20189_() - first.m_20189_(), second.m_20185_() - first.m_20185_()) * 57.29577951308232 + 90.0;
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player && this.m_5448_() != null;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            if (this.canPlayMusic()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 67) {
            IABossMusicPlayer.playBossMusic(this);
        } else if (id == 68) {
            IABossMusicPlayer.stopBossMusic(this);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20270_((Entity)player) < 2500.0f;
    }

    @Override
    protected void onDeathAIUpdate() {
    }

    @Override
    public void m_6667_(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.f_20890_) {
            Entity entity = cause.m_7639_();
            LivingEntity livingentity = this.m_21232_();
            if (this.f_20897_ >= 0 && livingentity != null) {
                livingentity.m_5993_((Entity)this, this.f_20897_, cause);
            }
            if (this.m_5803_()) {
                this.m_5796_();
            }
            this.f_20890_ = true;
            this.m_21231_().m_19296_();
            if (this.m_9236_() instanceof ServerLevel && (entity == null || entity.m_214076_((ServerLevel)this.m_9236_(), (LivingEntity)this))) {
                this.m_146850_(GameEvent.f_223707_);
                this.m_21268_(livingentity);
                this.AfterDefeatBoss(livingentity);
                if (!this.dropAfterDeathAnim) {
                    this.m_6668_(cause);
                }
            }
            this.killDataCause = cause;
            this.killDataRecentlyHit = this.f_20889_;
            this.killDataAttackingPlayer = this.f_20888_;
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_20124_(Pose.DYING);
        }
    }

    protected void AfterDefeatBoss(@Nullable LivingEntity p_21269_) {
    }

    public void circleEntity(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vec3 movePos = target.m_20182_().m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        this.m_21573_().m_26519_(movePos.f_82479_, movePos.f_82480_, movePos.f_82481_, (double)(speed * moveSpeedMultiplier));
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        List<LivingEntity> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            if (!entity.m_6087_() || entity.f_19794_) continue;
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.m_20334_(-0.1 * Math.cos(angle), entity.m_20184_().f_82480_, -0.1 * Math.sin(angle));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSocketPosArray(int index, Vec3 pos) {
        if (this.socketPosArray != null && this.socketPosArray.length > index) {
            this.socketPosArray[index] = pos;
        }
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    @Override
    public void m_7334_(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.m_5803_() || this.m_20365_(entityIn) || entityIn.f_19794_ || this.f_19794_ || !((d2 = Mth.m_14005_((double)(d0 = entityIn.m_20185_() - this.m_20185_()), (double)(d1 = entityIn.m_20189_() - this.m_20189_()))) >= (double)0.01f))) {
            d2 = Mth.m_14116_((float)((float)d2));
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.m_20160_() && this.canBePushedByEntity(entityIn)) {
                this.m_5997_(-d0, 0.0, -d1);
            }
            if (!entityIn.m_20160_()) {
                entityIn.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public SoundEvent getBossMusic() {
        return null;
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return ModTag.EFFECTIVE_FOR_BOSSES_LOOKUP.contains(p_34192_.m_19544_()) && super.m_7301_(p_34192_);
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    protected boolean m_7341_(Entity p_31508_) {
        return false;
    }
}

