/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container.component;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.lwjgl.opengl.GL11;

public class GuiCraftingPlan
extends AbstractWidget {
    private static final int ELEMENT_WIDTH = 221;
    private static final int ELEMENT_HEIGHT = 16;
    private static final int ELEMENT_HEIGHT_TOTAL = 18;
    protected static final int TICK_DELAY = 30;
    private final AbstractContainerScreen parentGui;
    private final int guiLeft;
    private final int guiTop;
    private final List<Element> elements;
    private final List<Element> visibleElements;
    private final boolean valid;
    private final WidgetScrollBar scrollBar;
    private final String label;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;
    private int firstRow;

    public GuiCraftingPlan(AbstractContainerScreen parentGui, ITerminalCraftingPlan<?> craftingPlan, int guiLeft, int guiTop, int x, int y, int visibleRows) {
        super(x, y, 0, 0, (Component)Component.m_237113_((String)""));
        this.parentGui = parentGui;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.elements = GuiCraftingPlan.getElements(craftingPlan);
        this.visibleElements = Lists.newArrayList(this.elements);
        this.valid = craftingPlan.getStatus().isValid();
        this.scrollBar = new WidgetScrollBar(guiLeft + x + 227, guiTop + y + 0, 178, (Component)Component.m_237115_((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, visibleRows);
        this.scrollBar.setTotalRows(this.visibleElements.size());
        this.label = L10NHelpers.localize((String)craftingPlan.getUnlocalizedLabel(), (Object[])new Object[0]);
        this.tickDuration = craftingPlan.getTickDuration();
        this.channel = craftingPlan.getChannel();
        this.initiatorName = craftingPlan.getInitiatorName();
    }

    public void inheritVisualizationState(GuiCraftingPlan guiCraftingPlan) {
        float lastScroll = guiCraftingPlan.scrollBar.getCurrentScroll();
        this.scrollBar.scrollTo(lastScroll);
        IntOpenHashSet disabledElementIds = new IntOpenHashSet();
        for (Element element : guiCraftingPlan.elements) {
            if (element.isEnabled()) continue;
            disabledElementIds.add(element.getId());
        }
        for (Element element : this.elements) {
            if (!disabledElementIds.contains(element.getId())) continue;
            element.setEnabled(false);
        }
        this.refreshList();
    }

    protected void refreshList() {
        this.visibleElements.clear();
        GuiCraftingPlan.addActiveElements(this.elements.get(0), this.visibleElements);
        this.scrollBar.setTotalRows(this.visibleElements.size());
    }

    protected static void addActiveElements(Element root, List<Element> elements) {
        if (root.isEnabled()) {
            elements.add(root);
            for (Element child : root.getChildren()) {
                GuiCraftingPlan.addActiveElements(child, elements);
            }
        }
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = Math.max(0, firstRow);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void m_87963_(GuiGraphics guiGraphics, int p_268034_, int p_268009_, float p_268085_) {
    }

    protected List<Element> getVisibleElements() {
        return this.visibleElements.subList(this.firstRow, Math.min(this.visibleElements.size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    protected int getAbsoluteElementIndent(Element element) {
        return element.getIndent() * 8;
    }

    public void drawGuiContainerLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int offsetY = 0;
        for (Element element : this.getVisibleElements()) {
            this.drawElement(guiGraphics, element, this.getAbsoluteElementIndent(element), guiLeft + this.m_252754_(), guiTop + this.m_252907_() + offsetY, 221, 16, layer, partialTick, mouseX, mouseY);
            offsetY += 18;
        }
    }

    protected int getTick() {
        return (int)Minecraft.m_91087_().f_91073_.m_46467_() / 30;
    }

    private void drawElement(GuiGraphics guiGraphics, Element element, int indent, int x, int y, int width, int height, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            guiGraphics.m_280509_(x, y, x + width, y + height + 1, element.getColor());
        }
        int xOriginal = x;
        x += indent;
        if (!element.getChildren().isEmpty() && layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            Image image = element.getChildren().get(0).isEnabled() ? Images.ARROW_DOWN : Images.ARROW_RIGHT;
            image.draw(guiGraphics, x, y);
        }
        x += 16;
        int tick = this.getTick();
        for (List<IPrototypedIngredient<?, ?>> alternatives : element.getOutputs()) {
            IPrototypedIngredient<?, ?> output = alternatives.get(tick % alternatives.size());
            IngredientComponent ingredientComponent = output.getComponent();
            long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
            int finalX = x;
            int finalY = y;
            ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY).ifPresent(h -> h.drawInstance(guiGraphics, output.getPrototype(), quantity, GuiHelpers.quantityToScaledString((long)quantity), this.parentGui, layer, partialTick, finalX, finalY, mouseX, mouseY, null));
            x += GuiHelpers.SLOT_SIZE_INNER;
        }
        x = xOriginal + width - 50;
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            if (element.getStorageQuantity() > 0L) {
                GuiCraftingPlan.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.f_50087_), x, y, 0.45f);
                RenderHelpers.drawScaledString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.stored", (Object[])new Object[]{element.getStorageQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
                y += 8;
            }
            if (element.getCraftQuantity() > 0L) {
                GuiCraftingPlan.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.f_50091_), x, y, 0.45f);
                RenderHelpers.drawScaledString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.crafting", (Object[])new Object[]{element.getCraftQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
                y += 8;
            }
            if (element.getMissingQuantity() > 0L) {
                GuiCraftingPlan.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.f_50375_), x, y, 0.45f);
                RenderHelpers.drawScaledString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.missing", (Object[])new Object[]{element.getMissingQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GuiHelpers.renderTooltipOptional((AbstractContainerScreen)this.parentGui, (PoseStack)guiGraphics.m_280168_(), (int)x, (int)y, (int)50, (int)GuiHelpers.SLOT_SIZE, (int)mouseX, (int)mouseY, () -> {
                String unlocalizedName = "gui.integratedterminals.craftingplan.status." + element.getStatus().name().toLowerCase(Locale.ENGLISH);
                return Optional.of(Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)unlocalizedName), Component.m_237115_((String)(unlocalizedName + ".desc"))}));
            });
        }
    }

    protected static void renderItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y, float scale) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        RenderSystem.applyModelViewMatrix();
        GuiGraphicsExtended renderItem = new GuiGraphicsExtended(guiGraphics);
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        Lighting.m_84931_();
        GlStateManager._enableDepthTest();
        GL11.glEnable((int)2929);
        guiGraphics.m_280480_(itemStack, 0, 0);
        renderItem.renderItemDecorations(Minecraft.m_91087_().f_91062_, itemStack, 0, 0, "");
        Lighting.m_84930_();
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static String getDurationString(long tickDuration) {
        long durationMs = tickDuration * 1000L / 20L;
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.duration", (Object[])new Object[]{DurationFormatUtils.formatDuration((long)durationMs, (String)"H:mm:ss", (boolean)true)});
    }

    public void drawGuiContainerBackgroundLayer(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, this.label, this.guiLeft + this.m_252754_() + 110 + 8, this.guiTop + this.m_252907_() - 13, 0xFFFFFF);
        if (this.tickDuration >= 0L) {
            String durationString = GuiCraftingPlan.getDurationString(this.tickDuration);
            RenderHelpers.drawScaledString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)fontRenderer, (String)durationString, (int)(this.guiLeft + this.m_252754_() + 200), (int)(this.guiTop + this.m_252907_() - 14), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        }
        if (this.channel != -1) {
            String channelString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", (Object[])new Object[]{this.channel});
            RenderHelpers.drawScaledString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)fontRenderer, (String)channelString, (int)(this.guiLeft + this.m_252754_() + 200), (int)(this.guiTop + this.m_252907_() - 8), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        }
        if (this.initiatorName != null) {
            String initiatorString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.owner", (Object[])new Object[]{this.initiatorName});
            RenderHelpers.drawScaledString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)fontRenderer, (String)initiatorString, (int)(this.guiLeft + this.m_252754_() - 4), (int)(this.guiTop + this.m_252907_() - 14), (float)0.5f, (int)0xFFFFFF, (boolean)true, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        }
        this.drawGuiContainerLayer(guiGraphics, this.guiLeft, this.guiTop, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND, partialTicks, mouseX, mouseY);
        this.scrollBar.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawGuiContainerLayer(guiGraphics, 0, 0, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND, 0.0f, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.scrollBar.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        return this.scrollBar.m_7979_(mouseX, mouseY, mouseButton, offsetX, offsetY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        int offsetY = 0;
        for (Element element : this.getVisibleElements()) {
            int x = this.guiLeft + this.m_252754_() + this.getAbsoluteElementIndent(element);
            int y = this.guiTop + this.m_252907_() + offsetY;
            offsetY += 18;
            if (!RenderHelpers.isPointInRegion((Rectangle)new Rectangle(x, y, 221, 16), (Point)new Point((int)mouseX, (int)mouseY))) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            for (Element child : element.getChildren()) {
                child.setEnabled(!child.isEnabled());
            }
            this.refreshList();
            return true;
        }
        return false;
    }

    public static List<Element> getElements(ITerminalCraftingPlan<?> craftingPlan) {
        ArrayList elements = Lists.newArrayList();
        GuiCraftingPlan.addElements(null, 0, craftingPlan, elements);
        return elements;
    }

    protected static void addElements(@Nullable Element parent, int indent, ITerminalCraftingPlan<?> craftingPlan, List<Element> elements) {
        boolean valid = craftingPlan.getStatus().isValid() || !craftingPlan.getStorageIngredients().isEmpty() || !craftingPlan.getDependencies().isEmpty();
        int elementId = Objects.hash(craftingPlan.getId()) * 100;
        Element currentElement = new Element(elementId++, indent, craftingPlan.getOutputs().stream().map(Collections::singletonList).collect(Collectors.toList()), 0L, valid ? craftingPlan.getCraftingQuantity() : 0L, valid ? 0L : craftingPlan.getCraftingQuantity(), craftingPlan.getStatus().getColor(), craftingPlan.getStatus());
        if (parent != null) {
            parent.addChild(currentElement);
        }
        elements.add(currentElement);
        if (craftingPlan.getStatus() == TerminalCraftingJobStatus.PENDING_INPUTS) {
            for (List<IPrototypedIngredient<?, ?>> list : craftingPlan.getLastMissingIngredients()) {
                List<List<IPrototypedIngredient<?, ?>>> outputs = Collections.singletonList(list.stream().map(prototypedIngredient -> {
                    IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
                    Object instance = matcher.withQuantity(prototypedIngredient.getPrototype(), matcher.getQuantity(prototypedIngredient.getPrototype()) * craftingPlan.getCraftingQuantity());
                    return new PrototypedIngredient(prototypedIngredient.getComponent(), instance, prototypedIngredient.getCondition());
                }).collect(Collectors.toList()));
                elements.add(currentElement.addChild(new Element(elementId++, indent + 1, outputs, 0L, 0L, craftingPlan.getCraftingQuantity(), TerminalCraftingJobStatus.INVALID.getColor(), TerminalCraftingJobStatus.INVALID)));
            }
        } else if (craftingPlan.getStatus() != TerminalCraftingJobStatus.CRAFTING) {
            for (IPrototypedIngredient iPrototypedIngredient : craftingPlan.getStorageIngredients()) {
                elements.add(currentElement.addChild(new Element(elementId++, indent + 1, Collections.singletonList(Collections.singletonList(iPrototypedIngredient)), iPrototypedIngredient.getComponent().getMatcher().getQuantity(iPrototypedIngredient.getPrototype()), 0L, 0L, TerminalCraftingJobStatus.FINISHED.getColor(), TerminalCraftingJobStatus.FINISHED)));
            }
        }
        for (ITerminalCraftingPlan iTerminalCraftingPlan : craftingPlan.getDependencies()) {
            GuiCraftingPlan.addElements(currentElement, indent + 1, iTerminalCraftingPlan, elements);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public static class Element {
        private final int id;
        private final int indent;
        private final List<List<IPrototypedIngredient<?, ?>>> outputs;
        private final long storageQuantity;
        private final long craftQuantity;
        private final long missingQuantity;
        private final int color;
        private final List<Element> children;
        private final TerminalCraftingJobStatus status;
        private boolean enabled;

        public Element(int id, int indent, List<List<IPrototypedIngredient<?, ?>>> outputs, long storageQuantity, long craftQuantity, long missingQuantity, int color, TerminalCraftingJobStatus status) {
            this.id = id;
            this.indent = indent;
            this.outputs = outputs;
            this.storageQuantity = storageQuantity;
            this.craftQuantity = craftQuantity;
            this.missingQuantity = missingQuantity;
            this.color = color;
            this.status = status;
            this.children = Lists.newArrayList();
            this.enabled = true;
        }

        public int getId() {
            return this.id;
        }

        public int getIndent() {
            return this.indent;
        }

        public List<List<IPrototypedIngredient<?, ?>>> getOutputs() {
            return this.outputs;
        }

        public long getStorageQuantity() {
            return this.storageQuantity;
        }

        public long getCraftQuantity() {
            return this.craftQuantity;
        }

        public long getMissingQuantity() {
            return this.missingQuantity;
        }

        public int getColor() {
            return this.color;
        }

        public Element addChild(Element element) {
            this.children.add(element);
            return element;
        }

        public List<Element> getChildren() {
            return this.children;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public TerminalCraftingJobStatus getStatus() {
            return this.status;
        }
    }
}

