/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.dannyboythomas.hole_filler_mod.util.IH;
import com.dannyboythomas.hole_filler_mod.util.ShulkerStack;
import java.util.Vector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ShulkerContent {
    Vector<ShulkerStack> contents = new Vector();

    public ShulkerContent(ItemStack shulker) {
        if (!IH.IsShulkerBox(shulker)) {
            return;
        }
        this.contents = new Vector();
        CompoundTag bet = shulker.m_41784_().m_128469_("BlockEntityTag");
        ListTag list = bet.m_128437_("Items", 10);
        boolean total = false;
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemNBT = list.m_128728_(i);
            String id = itemNBT.m_128461_("id");
            byte count = itemNBT.m_128445_("Count");
            byte slot = itemNBT.m_128445_("Slot");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
            ItemStack stack = new ItemStack((ItemLike)item, (int)count);
            this.contents.add(new ShulkerStack(stack, slot));
        }
    }

    public int Take(Item item, int count) {
        int toRemove = count;
        for (int i = 0; i < this.contents.size(); ++i) {
            ShulkerStack content = this.contents.get(i);
            if (content.stack.m_41720_() != item) continue;
            int toTake = Math.min(toRemove, content.stack.m_41613_());
            content.stack.m_41774_(toTake);
            toRemove -= toTake;
        }
        return toRemove;
    }

    public void SaveItems(ItemStack shulker) {
        CompoundTag nbt = shulker.m_41784_();
        CompoundTag entity = nbt.m_128469_("BlockEntityTag");
        entity.m_128365_("Items", (Tag)this.ItemsNBT());
        nbt.m_128365_("BlockEntityTag", (Tag)entity);
        shulker.m_41751_(nbt);
    }

    public ListTag ItemsNBT() {
        ListTag list = new ListTag();
        for (int i = 0; i < this.contents.size(); ++i) {
            CompoundTag itemNBT = this.contents.get(i).ToNBT();
            if (itemNBT == null) continue;
            list.add((Object)itemNBT);
        }
        return list;
    }
}

