/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.util;

import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.util.ShulkerContent;
import com.dannyboythomas.hole_filler_mod.util.smart.OneWayBlocks;
import com.dannyboythomas.hole_filler_mod.util.smart.SimilarBlockPattern;
import com.dannyboythomas.hole_filler_mod.util.smart.SimilarBlocks;
import java.util.Locale;
import java.util.Vector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.registries.ForgeRegistries;

public class IH {
    public static Block TryTakeSimilarBlock(boolean isCreativeMode, Block block, Container inv, boolean perform, boolean overridePriority) {
        if (isCreativeMode) {
            return block;
        }
        if (block == null) {
            return null;
        }
        block = OneWayBlocks.Get(block);
        SimilarBlockPattern pattern = SimilarBlocks.Get(block);
        Vector<Block> blocks = pattern.BlocksByPriority(block, overridePriority);
        for (int i = 0; i < blocks.size(); ++i) {
            Block check = blocks.get(i);
            ItemStack stack = new ItemStack((ItemLike)check.m_5456_(), 1);
            if (!IH.HasStack(inv, stack, true)) continue;
            if (perform) {
                IH.Take(inv, stack, isCreativeMode, true);
            }
            return check;
        }
        ItemStack actualStack = new ItemStack((ItemLike)block, 1);
        if (IH.HasStack(inv, actualStack, true)) {
            if (perform) {
                IH.Take(inv, actualStack, isCreativeMode, true);
            }
            return block;
        }
        return null;
    }

    public static boolean IsShulkerBox(ItemStack check) {
        Block block = Block.m_49814_((Item)check.m_41720_());
        String name = check.m_41786_().getString().toLowerCase(Locale.ROOT).trim();
        if (name.length() < 2) {
            return false;
        }
        boolean valid = name.substring(0, 2).contains("..");
        return block instanceof ShulkerBoxBlock && valid;
    }

    public static boolean HasStack(Container inv, ItemStack stack, boolean checkShulker) {
        if (stack == null || inv == null) {
            return true;
        }
        if (((Boolean)ConfigHoleFiller.is_dirt_free.get()).booleanValue() && stack.m_41720_() == Blocks.f_50493_.m_5456_()) {
            return true;
        }
        int req = stack.m_41613_();
        int total = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack slot = inv.m_8020_(i);
            if (slot != null && !slot.m_41619_()) {
                if (checkShulker && IH.IsShulkerBox(slot)) {
                    total += IH.GetCountInShulker(slot, stack);
                }
                if (IH.IsSameItemIgnoreDurability(slot, stack)) {
                    total += slot.m_41613_();
                }
            }
            if (total < req) continue;
            return true;
        }
        return total >= req;
    }

    public static int GetCountInShulker(ItemStack shulkerStack, ItemStack check) {
        if (!IH.IsShulkerBox(shulkerStack)) {
            return 0;
        }
        CompoundTag bet = shulkerStack.m_41784_().m_128469_("BlockEntityTag");
        ListTag list = bet.m_128437_("Items", 10);
        int total = 0;
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemNBT = list.m_128728_(i);
            String id = itemNBT.m_128461_("id");
            byte count = itemNBT.m_128445_("Count");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
            ItemStack stack = new ItemStack((ItemLike)item, (int)count);
            if (!IH.IsSameItemIgnoreDurability(check, stack)) continue;
            total += count;
        }
        return total;
    }

    public static boolean Take(Container inv, ItemStack stack, boolean creative, boolean checkShulker) {
        if (((Boolean)ConfigHoleFiller.is_dirt_free.get()).booleanValue() && stack.m_41720_() == Blocks.f_50493_.m_5456_()) {
            return true;
        }
        if (creative) {
            return true;
        }
        if (inv == null || stack == null) {
            return false;
        }
        if (IH.HasStack(inv, stack, checkShulker)) {
            int toRemove = stack.m_41613_();
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack check = inv.m_8020_(i);
                if (check == null || check.m_41619_()) continue;
                if (checkShulker && IH.IsShulkerBox(check)) {
                    int taken = IH.TakeFromShulker(check, stack.m_41720_(), toRemove);
                    toRemove -= taken;
                }
                if (IH.IsSameItemIgnoreDurability(check, stack)) {
                    int checkCount = check.m_41613_();
                    int toTake = Math.min(checkCount, toRemove);
                    toRemove -= toTake;
                    check.m_41774_(toTake);
                }
                if (toRemove > 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static int TakeFromShulker(ItemStack shulker, Item item, int count) {
        if (!IH.IsShulkerBox(shulker)) {
            return 0;
        }
        int available = IH.GetCountInShulker(shulker, new ItemStack((ItemLike)item, 1));
        int toTake = Math.min(count, available);
        ShulkerContent content = new ShulkerContent(shulker);
        content.Take(item, toTake);
        content.SaveItems(shulker);
        return toTake;
    }

    public static boolean IsSameItemIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() == stack2.m_41720_();
    }
}

