/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.blocks.BlockLight;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.init.ModBlocks;
import com.dannyboythomas.hole_filler_mod.init.ModTiles;
import com.dannyboythomas.hole_filler_mod.tiles.TileHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.util.HoleData;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.dannyboythomas.hole_filler_mod.util.IH;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileHoleFillerLight
extends TileHoleFillerBase {
    public static int minLightLevel = 8;
    boolean actuallyTake = false;

    public TileHoleFillerLight(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.HOLE_FILLER_LIGHT.get(), pos, state);
    }

    @Override
    HoleUtil.FillerType GetFillerType() {
        return HoleUtil.FillerType.light;
    }

    @Override
    public Block GetBlockToPlace(Vec3i vec) {
        return (Block)ModBlocks.light_block.get();
    }

    @Override
    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128405_("min_light_level", minLightLevel);
        nbt.m_128379_("taken", this.actuallyTake);
        return super.save(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        minLightLevel = nbt.m_128451_("min_light_level");
        this.actuallyTake = nbt.m_128471_("taken");
        super.m_142466_(nbt);
    }

    @Override
    public void DropInventory(Player player, boolean includeSelf) {
    }

    public void SetMinLightLevel(int level) {
        minLightLevel = level < 8 ? 8 : level;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        boolean canRunOnServer;
        if (level.f_46443_) {
            return;
        }
        TileHoleFillerBase te = (TileHoleFillerBase)level.m_7702_(pos);
        ++te.timer;
        boolean throwerOnline = te.thrower != null && te.thrower.m_20194_().m_6846_().m_11314_().contains(te.thrower);
        boolean bl = canRunOnServer = te.creativeMode || throwerOnline;
        if (te.running && canRunOnServer & te.timer % 1 == 0) {
            te.Fill();
            if (te.holedata.emptyVolume.size() <= 0) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
        if (te.timer > 4800) {
            level.m_46597_(pos, te.GetBlockToPlace((Vec3i)pos).m_49966_());
        }
    }

    @Override
    public void Start() {
        if (this.thrower == null) {
            return;
        }
        Inventory inv = this.thrower.m_150109_();
        ItemStack toTake = new ItemStack((ItemLike)Items.f_42000_, 1);
        if (this.creativeMode || inv != null && IH.HasStack((Container)inv, toTake, true)) {
            boolean useGravity = false;
            this.thrower.m_5661_((Component)Component.m_237113_((String)"Calculating...."), true);
            this.holedata = new HoleData(this.f_58857_, (Vec3i)this.f_58858_, minLightLevel, this.thrower);
            this.running = true;
            this.LogThrow();
        } else {
            if (!this.thrower.m_150110_().f_35937_) {
                ItemEntity entity = new ItemEntity(this.f_58857_, this.thrower.m_20185_(), this.thrower.m_20186_(), this.thrower.m_20189_(), new ItemStack((ItemLike)this.GetThrowableItem(), 1));
                this.f_58857_.m_7967_((Entity)entity);
            }
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
            this.EndPlacement("Missing Resources");
        }
    }

    @Override
    public void Fill() {
        if (this.holedata == null || this.thrower == null) {
            return;
        }
        Inventory inv = this.thrower.m_150109_();
        int blocksPerTick = (Integer)ConfigHoleFiller.fill_speed.get();
        int min = Math.min(blocksPerTick, this.holedata.emptyVolume.size());
        int prevVolume = this.holedata.emptyVolume.size();
        int torchesToTake = min / (Integer)ConfigHoleFiller.torch_places_n_light_sources.get();
        for (int i = 0; i < min; ++i) {
            Vec3i vec = this.holedata.emptyVolume.firstElement();
            boolean bl = this.actuallyTake = (prevVolume + i) % (Integer)ConfigHoleFiller.torch_places_n_light_sources.get() == 0;
            if (this.TakeAndPlace((Container)inv, this.GetBlockToPlace(vec))) continue;
            this.EndPlacement("Missing Resources: Torch");
        }
        if (min > 0) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public boolean TakeAndPlace(Container inv, Block block) {
        ItemStack toTake = new ItemStack((ItemLike)Items.f_42000_, 1);
        Vec3i vec = this.holedata.emptyVolume.firstElement();
        if ((this.creativeMode || !this.actuallyTake || inv != null && IH.HasStack(inv, toTake, true)) && this.f_58857_.m_46859_(new BlockPos(vec)) && (this.creativeMode || !this.actuallyTake || IH.Take(inv, toTake, this.creativeMode, true))) {
            this.f_58857_.m_46597_(new BlockPos(vec), ((BlockLight)((Object)ModBlocks.light_block.get())).m_49966_());
            this.f_58857_.m_7260_(new BlockPos(vec), ((BlockLight)((Object)ModBlocks.light_block.get())).m_49966_(), ((BlockLight)((Object)ModBlocks.light_block.get())).m_49966_(), 11);
            this.holedata.emptyVolume.remove(0);
            return true;
        }
        this.holedata.emptyVolume.remove(0);
        return false;
    }
}

