/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.tiles;

import com.dannyboythomas.hole_filler_mod.HoleFillerMod;
import com.dannyboythomas.hole_filler_mod.blocks.BlockCuring;
import com.dannyboythomas.hole_filler_mod.blocks.BlockHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.blocks.BlockVeinBreakable;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.init.ModBlocks;
import com.dannyboythomas.hole_filler_mod.init.ModItems;
import com.dannyboythomas.hole_filler_mod.init.ModTiles;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleData;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.dannyboythomas.hole_filler_mod.util.IH;
import com.dannyboythomas.hole_filler_mod.util.smart.CuringState;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class TileHoleFillerBase
extends BlockEntity {
    public int timer = 0;
    public Block blockToPlace;
    public boolean creativeMode;
    public Player thrower;
    public HoleData holedata;
    public BlockHitResult blockHitResult;
    public boolean running = false;

    public TileHoleFillerBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public TileHoleFillerBase(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.HOLE_FILLER.get(), pos, state);
    }

    public CompoundTag save(CompoundTag nbt) {
        if (this.holedata != null) {
            nbt = this.holedata.Write(nbt);
        }
        if (this.blockToPlace != null) {
            String blockName = H.GetRegistryName(this.blockToPlace);
            nbt.m_128359_("block_to_place", blockName);
        }
        nbt.m_128359_("thrower", H.GetPlayerIDString(this.thrower));
        nbt.m_128379_("creative", this.creativeMode);
        nbt.m_128379_("running", this.running);
        nbt.m_128405_("timer", this.timer);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        BlockState state = this.m_58900_();
        this.holedata = HoleData.Read(state, nbt, (Vec3i)this.f_58858_);
        this.blockToPlace = H.BlockFromName(nbt.m_128461_("block_to_place"));
        try {
            UUID playerID = UUID.fromString(nbt.m_128461_("thrower"));
            this.thrower = H.GetPlayerFromID(this.f_58857_, playerID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.creativeMode = nbt.m_128471_("creative");
        this.running = nbt.m_128471_("running");
        this.timer = nbt.m_128451_("timer");
        super.m_142466_(nbt);
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.save(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    public void LogThrow() {
        if (this.holedata.preVolume.size() <= 0) {
            return;
        }
        String playerX = H.TwoDP(this.thrower.m_20185_());
        String playerY = H.TwoDP(this.thrower.m_20186_());
        String playerZ = H.TwoDP(this.thrower.m_20189_());
        String pos = "(" + playerX + ", " + playerY + ", " + playerZ + ")";
        HoleFillerMod.LOGGER.info(this.thrower.m_5446_().getString() + " threw a " + new ItemStack((ItemLike)this.GetThrowableItem(), 1).m_41611_().getString() + " from " + pos + ".\n Impact position: " + this.f_58858_ + ". Hole Size: " + this.holedata.preVolume.size() + ". Creative: " + this.creativeMode);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        boolean canRunOnServer;
        if (level.f_46443_) {
            return;
        }
        TileHoleFillerBase te = (TileHoleFillerBase)level.m_7702_(pos);
        ++te.timer;
        boolean throwerOnline = te.thrower != null && te.thrower.m_20194_().m_6846_().m_11314_().contains(te.thrower);
        boolean bl = canRunOnServer = te.creativeMode || throwerOnline;
        if (te.running && canRunOnServer) {
            te.Fill();
        }
        if (te.timer > 4800) {
            te.FailedSoKillVein();
        }
        te.TickCuringStates();
    }

    void PrintData() {
        System.out.println((Object)this);
        System.out.println(this.f_58858_);
        System.out.println("thrower:  " + this.thrower);
        System.out.println("running:  " + this.running);
        System.out.println("data:  " + this.holedata.filledVolume);
    }

    void TickCuringStates() {
        Block block;
        if (this.holedata == null) {
            return;
        }
        boolean allConverted = this.holedata.TickCuringStates(this.f_58857_, this.thrower);
        if (allConverted && this.thrower != null && (block = this.GetBlockToPlace((Vec3i)this.f_58858_)) != null) {
            this.f_58857_.m_46597_(this.f_58858_, this.GetBlockToPlace((Vec3i)this.f_58858_).m_49966_());
        }
    }

    HoleUtil.FillerType GetFillerType() {
        return HoleUtil.FillerType.simple;
    }

    Item GetThrowableItem() {
        if (this.GetFillerType() == HoleUtil.FillerType.balanced) {
            return (Item)ModItems.throwable_hole_filler_balanced.get();
        }
        if (this.GetFillerType() == HoleUtil.FillerType.smart) {
            return (Item)ModItems.throwable_hole_filler_smart.get();
        }
        if (this.GetFillerType() == HoleUtil.FillerType.water) {
            return (Item)ModItems.throwable_hole_filler_water.get();
        }
        if (this.GetFillerType() == HoleUtil.FillerType.lava) {
            return (Item)ModItems.throwable_hole_filler_lava.get();
        }
        if (this.GetFillerType() == HoleUtil.FillerType.light) {
            return (Item)ModItems.throwable_hole_filler_light.get();
        }
        if (this.GetFillerType() == HoleUtil.FillerType.dark) {
            return (Item)ModItems.throwable_hole_filler_dark.get();
        }
        return (Item)ModItems.throwable_hole_filler.get();
    }

    public HoleData GenerateData(boolean gravity) {
        return new HoleData(this.f_58857_, (Vec3i)this.f_58858_, this.GetFillerType(), gravity, this.thrower);
    }

    public void Start() {
        if (this.thrower == null) {
            return;
        }
        Inventory inv = this.thrower.m_150109_();
        if (this.creativeMode || inv != null && IH.HasStack((Container)inv, H.Single(this.GetBlockToPlace((Vec3i)this.f_58858_)), true)) {
            boolean useGravity = this.GetBlockToPlace((Vec3i)this.f_58858_) != null && this.GetBlockToPlace((Vec3i)this.f_58858_) instanceof FallingBlock;
            this.thrower.m_5661_((Component)Component.m_237113_((String)"Calculating...."), true);
            this.holedata = this.GenerateData(useGravity);
            if (IH.Take((Container)inv, H.Single(this.GetBlockToPlace((Vec3i)this.f_58858_)), this.creativeMode, true)) {
                this.running = true;
            }
            this.LogThrow();
        } else {
            if (!this.thrower.m_150110_().f_35937_) {
                ItemEntity entity = new ItemEntity(this.f_58857_, this.thrower.m_20185_(), this.thrower.m_20186_(), this.thrower.m_20189_(), new ItemStack((ItemLike)this.GetThrowableItem(), 1));
                this.f_58857_.m_7967_((Entity)entity);
            }
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
            this.EndPlacement("Missing Resources");
        }
    }

    void EndPlacement(String message) {
        this.running = false;
        if (this.thrower != null & message != null) {
            this.thrower.m_5661_((Component)Component.m_237113_((String)message), true);
        }
    }

    public void Fill() {
        if (this.holedata == null || this.thrower == null) {
            return;
        }
        Inventory inv = this.thrower.m_150109_();
        int blocksPerTick = (Integer)ConfigHoleFiller.fill_speed.get();
        int min = Math.min(blocksPerTick, this.holedata.emptyVolume.size());
        for (int i = 0; i < min; ++i) {
            Vec3i vec = this.holedata.emptyVolume.firstElement();
            if (this.TakeAndPlace((Container)inv, this.GetBlockToPlace(vec))) continue;
            this.EndPlacement("Missing Resources: " + H.Single(this.GetBlockToPlace(vec)).m_41786_().getString());
        }
        if (min > 0) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean TakeAndPlace(Container inv, Block block) {
        if (block == null) {
            return false;
        }
        Vec3i vec = this.holedata.emptyVolume.firstElement();
        if ((this.creativeMode || inv != null && IH.HasStack(inv, H.Single(block), true)) && HoleUtil.IsReplaceableBlock(this.f_58857_, new BlockPos(vec)) && (this.creativeMode || IH.Take(inv, H.Single(block), this.creativeMode, true))) {
            this.holedata.filledVolume.put(vec, new CuringState(vec, block));
            this.f_58857_.m_46597_(new BlockPos(vec), ((BlockCuring)((Object)ModBlocks.curing_block.get())).m_49966_());
            this.holedata.emptyVolume.remove(0);
            return true;
        }
        this.holedata.emptyVolume.remove(0);
        return false;
    }

    public void DropInventory(Player player, boolean includeSelf) {
        if (this.creativeMode || player.m_150110_().f_35937_ || this.holedata == null) {
            return;
        }
        int count = this.holedata.filledVolume.size() + (includeSelf ? 1 : 0);
        for (int i = 0; i < count; ++i) {
            H.Drop(this.f_58857_, this.creativeMode, this.GetBlockToPlace(new Vec3i((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())), player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
    }

    public Block GetBlockToPlace(Vec3i pos) {
        return Blocks.f_50493_;
    }

    public void Kill() {
        this.EndPlacement("Killed By Server");
        this.holedata.filledVolume.keySet().stream().forEach(vec -> this.f_58857_.m_7731_(new BlockPos(vec), Blocks.f_50016_.m_49966_(), 2));
        this.f_58857_.m_7731_(this.m_58899_(), Blocks.f_50016_.m_49966_(), 2);
    }

    private void FailedSoKillVein() {
        HoleUtil.FloodFill(this.f_58857_, this.f_58858_, block -> block instanceof BlockVeinBreakable && !(block instanceof BlockHoleFillerBase)).stream().forEach(pos -> {
            if (pos != this.f_58858_) {
                this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            }
        });
        this.f_58857_.m_7731_(this.f_58858_, Blocks.f_50016_.m_49966_(), 2);
    }
}

