/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.renderer;

import com.dannyboythomas.hole_filler_mod.items.ItemThrowableHoleFillerLava;
import com.dannyboythomas.hole_filler_mod.items.ItemThrowableHoleFillerWater;
import com.dannyboythomas.hole_filler_mod.renderer.MyRenderType;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;

public class WorldOverlayRenderer {
    public static List<Vec3i> coords = new ArrayList<Vec3i>();
    public static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("hole_filler_mod", "block/overlay_block");
    public static float timePassedSinceLastOverlayUpdate = 0.0f;

    public static float OverlayRefreshRate() {
        return 0.5f;
    }

    public static void render(RenderLevelStageEvent event, ItemStack item) {
        timePassedSinceLastOverlayUpdate += event.getPartialTick() / 20.0f;
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        if (timePassedSinceLastOverlayUpdate >= WorldOverlayRenderer.OverlayRefreshRate()) {
            int range = 48;
            LocalPlayer player = mc.f_91074_;
            Level world = player.m_9236_();
            coords.clear();
            Vec3 look = player.m_20154_();
            Vec3 start = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
            Vec3 end = new Vec3(player.m_20185_() + look.f_82479_ * (double)range, player.m_20186_() + (double)player.m_20192_() + look.f_82480_ * (double)range, player.m_20189_() + look.f_82481_ * (double)range);
            ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult lookingAt = world.m_45547_(context);
            if (lookingAt.m_6662_() != HitResult.Type.BLOCK || world.m_46859_(lookingAt.m_82425_())) {
                return;
            }
            BlockPos pos = lookingAt.m_82425_().m_121955_(lookingAt.m_82434_().m_122436_());
            coords = item.m_41720_() instanceof ItemThrowableHoleFillerLava || item.m_41720_() instanceof ItemThrowableHoleFillerWater ? HoleUtil.GetWaterHole(world, (Vec3i)pos, (Player)player) : HoleUtil.GetHole(world, (Vec3i)pos, (Player)player);
            timePassedSinceLastOverlayUpdate %= WorldOverlayRenderer.OverlayRefreshRate();
            coords.remove(0);
        }
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        PoseStack matrix = event.getPoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        coords.forEach(e -> {
            matrix.m_85836_();
            matrix.m_252880_((float)(e.m_123341_() + 1), (float)e.m_123342_(), (float)e.m_123343_());
            matrix.m_252880_(-0.005f, -0.005f, -0.005f);
            matrix.m_85841_(1.01f, 1.01f, 1.01f);
            WorldOverlayRenderer.RenderBlock(matrix);
            matrix.m_85849_();
        });
        matrix.m_85849_();
    }

    public static void RenderBlock(PoseStack matrixStack) {
        BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Block block = Blocks.f_50147_;
        renderer.renderSingleBlock(block.m_49966_(), matrixStack, (MultiBufferSource)buffer, 15, 15, ModelData.EMPTY, MyRenderType.BlockOverlay());
    }
}

