/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.items;

import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.data.HFMSavedData;
import com.dannyboythomas.hole_filler_mod.entities.EntityThrowableHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.entities.EntityThrowableHoleFillerLight;
import com.dannyboythomas.hole_filler_mod.items.ItemThrowableHoleFiller;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemThrowableHoleFillerLight
extends ItemThrowableHoleFiller {
    public ItemThrowableHoleFillerLight(Item.Properties properties) {
        super(properties);
    }

    @Override
    public String Color() {
        return "\u00a7e ";
    }

    @Override
    boolean CanThrow(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public EntityThrowableHoleFillerBase GetThrowableEntity(Player player, Level world) {
        return new EntityThrowableHoleFillerLight((LivingEntity)player, world);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerEntity, InteractionHand hand) {
        ItemStack stack = playerEntity.m_21120_(hand);
        Random random = new Random();
        world.m_6263_((Player)null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.15f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!playerEntity.m_6144_()) {
            HFMSavedData data = (HFMSavedData)playerEntity.m_20194_().m_129783_().m_8895_().m_164861_(HFMSavedData::Load, HFMSavedData::Create, "hole_filler_mod");
            ItemStack single = stack.m_41777_();
            single.m_41764_(1);
            if (this.CanThrow(playerEntity, single) && this.HasPermission(playerEntity)) {
                UUID playerID = playerEntity.m_36316_().getId();
                single.m_41784_().m_128359_("thrower", playerID.toString());
                single.m_41784_().m_128379_("creative", playerEntity.m_150110_().f_35937_);
                EntityThrowableHoleFillerBase ent = this.GetThrowableEntity(playerEntity, world);
                ent.m_37446_(single);
                ent.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 1.5f, 1.0f);
                world.m_7967_((Entity)ent);
                stack.m_41774_(1);
            } else {
                playerEntity.m_5661_((Component)Component.m_237113_((String)"Missing Resource"), true);
            }
        } else {
            int minLightLevel = 8;
            int prevLightLevel = stack.m_41784_().m_128451_("light_level");
            prevLightLevel = prevLightLevel < minLightLevel ? minLightLevel : prevLightLevel;
            int newLightLevel = prevLightLevel >= 15 ? minLightLevel : prevLightLevel + 1;
            stack.m_41784_().m_128405_("light_level", newLightLevel);
            playerEntity.m_5661_((Component)Component.m_237113_((String)("Light Level: \u00a7e" + newLightLevel)), true);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96639_()) {
            tooltip.add((Component)Component.m_237113_((String)"\u00a77A hole filled with 'Curing Blocks', can be undone within").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.undo_timer.get()))).m_7220_((Component)Component.m_237113_((String)" \u00a77seconds by breaking any Curing Block")));
            tooltip.add((Component)Component.m_237113_((String)"   "));
            tooltip.add((Component)Component.m_237113_((String)"\u00a77Ctrl + Alt to preview."));
        } else if (Screen.m_96638_()) {
            int minLightLevel = 8;
            int prevLightLevel = stack.m_41784_().m_128451_("light_level");
            prevLightLevel = prevLightLevel < minLightLevel ? minLightLevel : prevLightLevel;
            tooltip.add((Component)Component.m_237113_((String)"Light Level:").m_7220_((Component)Component.m_237113_((String)(this.Color() + prevLightLevel))));
            tooltip.add((Component)Component.m_237113_((String)"Diameter:").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.max_hole_diameter.get()))).m_7220_((Component)Component.m_237113_((String)" blocks")));
            tooltip.add((Component)Component.m_237113_((String)"Fill:").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.max_hole_volume.get()))).m_7220_((Component)Component.m_237113_((String)" blocks")));
            tooltip.add((Component)Component.m_237113_((String)"Speed:").m_7220_((Component)Component.m_237113_((String)(this.Color() + (Integer)ConfigHoleFiller.fill_speed.get() * 20))).m_7220_((Component)Component.m_237113_((String)" blocks/second")));
            tooltip.add((Component)Component.m_237113_((String)"Timer:").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.undo_timer.get()))).m_7220_((Component)Component.m_237113_((String)" seconds")));
            tooltip.add((Component)Component.m_237113_((String)"1x Torch =").m_7220_((Component)Component.m_237113_((String)(this.Color() + ConfigHoleFiller.torch_places_n_light_sources.get()))).m_7220_((Component)Component.m_237113_((String)"x Lights")));
            tooltip.add((Component)Component.m_237113_((String)"   "));
            tooltip.add((Component)Component.m_237113_((String)"\u00a77Shift + Right Click to change minimum light level"));
            tooltip.add((Component)Component.m_237113_((String)"   "));
            tooltip.add((Component)Component.m_237113_((String)("Restricted:" + this.Color() + ConfigHoleFiller.restricted_use.get())));
        } else {
            tooltip.add((Component)Component.m_237113_((String)("Hold" + this.Color() + "'Shift'\u00a7r for info.")));
            tooltip.add((Component)Component.m_237113_((String)"Hold\u00a77 'Alt'\u00a7r for shared info."));
        }
    }
}

