/*
 * Decompiled with CFR 0.152.
 */
package com.dannyboythomas.hole_filler_mod.entities;

import com.dannyboythomas.hole_filler_mod.HoleFillerMod;
import com.dannyboythomas.hole_filler_mod.StartUpCommon;
import com.dannyboythomas.hole_filler_mod.blocks.BlockHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.blocks.BlockLight;
import com.dannyboythomas.hole_filler_mod.config.ConfigHoleFiller;
import com.dannyboythomas.hole_filler_mod.entities.EntityThrowableHoleFillerBase;
import com.dannyboythomas.hole_filler_mod.init.ModItems;
import com.dannyboythomas.hole_filler_mod.util.H;
import com.dannyboythomas.hole_filler_mod.util.HoleData;
import com.dannyboythomas.hole_filler_mod.util.HoleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityThrowableHoleFillerDark
extends EntityThrowableHoleFillerBase {
    public EntityThrowableHoleFillerDark(LivingEntity entity, Level world) {
        super(StartUpCommon.holeThrowerDarkEntityType, entity, world);
    }

    public EntityThrowableHoleFillerDark(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    BlockHoleFillerBase SpawnBlock() {
        return null;
    }

    @Override
    protected Item m_7881_() {
        return (Item)ModItems.throwable_hole_filler_dark.get();
    }

    @Override
    protected void m_8060_(BlockHitResult res) {
        Level level = this.m_9236_();
        BlockPos pos = HoleUtil.BlockPosFromImpact(res);
        Vec3 entityPos = res.m_82450_();
        if (HoleFillerMod.DEBUG_MODE) {
            int radius = (Integer)ConfigHoleFiller.max_hole_diameter.get() / 2;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        Vec3i offset = new Vec3i(i, j, k);
                        BlockPos target = pos.m_121955_(offset);
                        double distance = H.Magnitude(offset);
                        if (!(distance <= (double)radius)) continue;
                        level.m_46597_(target, Blocks.f_50016_.m_49966_());
                    }
                }
            }
            for (int depth = (int)entityPos.f_82480_; depth >= -124; --depth) {
                level.m_7731_(new BlockPos((int)entityPos.f_82479_, depth, (int)entityPos.f_82481_), Blocks.f_50016_.m_49966_(), 2);
            }
        }
        if (HoleUtil.IsReplaceableBlock(level, pos)) {
            Player thrower = H.GetPlayerFromIDString(level, this.m_7846_().m_41784_().m_128461_("thrower"));
            HoleData data = new HoleData(level, (Vec3i)pos, HoleUtil.FillerType.dark, false, thrower);
            boolean creative = this.m_7846_().m_41784_().m_128471_("creative");
            Player player = H.GetPlayerFromIDString(level, this.m_7846_().m_41784_().m_128461_("thrower"));
            int total = 0;
            for (int i = 0; i < data.emptyVolume.size(); ++i) {
                Vec3i vec = data.emptyVolume.get(i);
                Block block = level.m_8055_(new BlockPos(vec)).m_60734_();
                if (block instanceof BlockLight) {
                    ++total;
                }
                level.m_7731_(new BlockPos(vec), Blocks.f_50016_.m_49966_(), 11);
            }
            if (player != null && !creative) {
                int torchReturn = (int)((double)(total / (Integer)ConfigHoleFiller.torch_places_n_light_sources.get()) * (Double)ConfigHoleFiller.torch_return_rate.get());
                H.Drop(level, creative, Blocks.f_50081_, torchReturn, player.m_20185_(), player.m_20186_(), player.m_20189_());
            }
        } else {
            level.m_7967_((Entity)new ItemEntity(level, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)this.m_7881_(), 1)));
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }
}

