/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.flopper.blockentity.BlockEntityFlopper;
import org.joml.Matrix4f;

public class RenderBlockEntityFlopper
implements BlockEntityRenderer<BlockEntityFlopper> {
    public RenderBlockEntityFlopper(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityFlopper tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile != null) {
            FluidStack fluid = tile.getTank().getFluid();
            RenderHelpers.renderFluidContext((FluidStack)fluid, (PoseStack)matrixStack, () -> {
                float height = (float)fluid.getAmount() * 0.3125f / (float)tile.getTank().getCapacity() + 0.6875f;
                int brightness = Math.max(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
                int l2 = brightness >> 16 & 0xFFFF;
                int i3 = brightness & 0xFFFF;
                TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)tile.getTank().getFluid(), (Direction)Direction.UP);
                IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
                Triple color = Helpers.intToRGB((int)renderProperties.getTintColor(fluid.getFluid().m_76145_(), (BlockAndTintGetter)tile.m_58904_(), tile.m_58899_()));
                VertexConsumer vb = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)icon.m_247685_()));
                Matrix4f matrix = matrixStack.m_85850_().m_252922_();
                vb.m_252986_(matrix, 0.125f, height, 0.125f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
                vb.m_252986_(matrix, 0.125f, height, 0.875f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
                vb.m_252986_(matrix, 0.875f, height, 0.875f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
                vb.m_252986_(matrix, 0.875f, height, 0.125f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            });
        }
    }
}

