/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidHandlerBlock
implements IFluidHandler {
    private final BlockState state;
    private final Level world;
    private final BlockPos blockPos;

    public FluidHandlerBlock(BlockState state, Level world, BlockPos blockPos) {
        this.state = state;
        this.world = world;
        this.blockPos = blockPos;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Block block = this.state.m_60734_();
        if (block instanceof LiquidBlock && (Integer)this.state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
            return new FluidStack((Fluid)((LiquidBlock)block).getFluid(), 1000);
        }
        if (this.state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)this.state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return new FluidStack((Fluid)Fluids.f_76193_, 1000);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        Block block = this.state.m_60734_();
        if (block instanceof LiquidBlock && ((LiquidBlock)block).getFluid() == resource.getFluid()) {
            return this.drain(resource.getAmount(), action);
        }
        if (this.state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)this.state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && block instanceof SimpleWaterloggedBlock) {
            return this.drain(resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Block block = this.state.m_60734_();
        if (block instanceof LiquidBlock && (Integer)this.state.m_61143_((Property)LiquidBlock.f_54688_) == 0 && maxDrain >= 1000) {
            if (action.execute()) {
                this.world.m_7731_(this.blockPos, Blocks.f_50016_.m_49966_(), 11);
            }
            return new FluidStack((Fluid)((LiquidBlock)block).getFluid(), 1000);
        }
        if (this.state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)this.state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && block instanceof SimpleWaterloggedBlock && maxDrain >= 1000) {
            if (action.execute()) {
                ((SimpleWaterloggedBlock)block).m_142598_((LevelAccessor)this.world, this.blockPos, this.state);
            }
            return new FluidStack((Fluid)Fluids.f_76193_, 1000);
        }
        return FluidStack.EMPTY;
    }
}

