/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.fluid.Tank;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.flopper.RegistryEntries;
import org.cyclops.flopper.block.BlockFlopper;
import org.cyclops.flopper.block.BlockFlopperConfig;
import org.cyclops.flopper.blockentity.FluidHandlerBlock;

public class BlockEntityFlopper
extends CyclopsBlockEntity {
    private Tank tank = new SingleUseTank(BlockFlopperConfig.capacityMb){

        protected void sendUpdate() {
            super.sendUpdate();
            BlockEntityFlopper.this.sendUpdate();
        }
    };
    @NBTPersist
    private int transferCooldown = -1;

    public BlockEntityFlopper(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_FLOPPER, blockPos, blockState);
        this.addCapabilityInternal(ForgeCapabilities.FLUID_HANDLER, LazyOptional.of(this::getTank));
    }

    public Tank getTank() {
        return this.tank;
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    public int getTransferCooldown() {
        return this.transferCooldown;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.tank.readFromNBT(tag.m_128469_("tank"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag tagTank = new CompoundTag();
        this.tank.writeToNBT(tagTank);
        tag.m_128365_("tank", (Tag)tagTank);
    }

    protected Direction getFacing() {
        return (Direction)this.m_58904_().m_8055_(this.m_58899_()).m_61143_((Property)BlockFlopper.FACING);
    }

    protected boolean pushFluidsToTank() {
        Direction targetSide = this.getFacing().m_122424_();
        BlockPos targetPos = this.m_58899_().m_121945_(this.getFacing());
        return BlockEntityHelpers.getCapability((BlockGetter)this.f_58857_, (BlockPos)targetPos, (Direction)targetSide, (Capability)ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)BlockFlopperConfig.pushFluidRate, (boolean)true).isEmpty()).orElse(false);
    }

    protected boolean pullFluidsFromTank() {
        BlockPos targetPos = this.m_58899_().m_121945_(Direction.UP);
        return BlockEntityHelpers.getCapability((BlockGetter)this.f_58857_, (BlockPos)targetPos, (Direction)Direction.DOWN, (Capability)ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)fluidHandler, (int)BlockFlopperConfig.pullFluidRate, (boolean)true).isEmpty()).orElse(false);
    }

    protected boolean pushFluidsToWorld() {
        boolean isDestReplaceable;
        BlockPos targetPos = this.m_58899_().m_121945_(this.getFacing());
        BlockState destBlockState = this.f_58857_.m_8055_(targetPos);
        boolean isDestNonSolid = !destBlockState.m_280296_();
        boolean bl = isDestReplaceable = destBlockState.m_60811_() == PushReaction.DESTROY;
        if (this.f_58857_.m_46859_(targetPos) || isDestNonSolid && isDestReplaceable && !destBlockState.m_278721_()) {
            FluidStack fluidStack = this.tank.getFluid();
            if (!this.f_58857_.m_6042_().f_63857_() || !fluidStack.getFluid().getFluidType().isVaporizedOnPlacement(this.f_58857_, this.f_58858_, fluidStack)) {
                return this.getFluidBlockHandler(fluidStack.getFluid(), this.f_58857_, targetPos).map(fluidHandler -> {
                    FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)Integer.MAX_VALUE, (boolean)true);
                    if (!moved.isEmpty()) {
                        SoundEvent soundevent;
                        if (BlockFlopperConfig.worldPullPushSounds && (soundevent = moved.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL)) != null) {
                            this.f_58857_.m_5594_(null, this.f_58858_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                            this.f_58857_.m_46586_(this.f_58858_, Blocks.f_50016_, this.f_58858_);
                        }
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        }
        return false;
    }

    private Optional<IFluidHandler> getFluidBlockHandler(Fluid fluid, Level world, BlockPos targetPos) {
        if (!fluid.getFluidType().canBePlacedInLevel((BlockAndTintGetter)world, targetPos, fluid.m_76145_())) {
            return Optional.empty();
        }
        BlockState state = fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)world, targetPos, fluid.m_76145_());
        return Optional.of(new BlockWrapper(state, world, targetPos));
    }

    protected boolean pullFluidsFromWorld() {
        BlockPos targetPos = this.m_58899_().m_121945_(Direction.UP);
        BlockState destBlockState = this.f_58857_.m_8055_(targetPos);
        return this.wrapFluidBlock(destBlockState, this.f_58857_, targetPos).map(fluidHandler -> {
            FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true);
            if (!moved.isEmpty()) {
                SoundEvent soundevent;
                if (BlockFlopperConfig.worldPullPushSounds && (soundevent = moved.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)) != null) {
                    this.f_58857_.m_5594_(null, this.f_58858_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                    this.f_58857_.m_46586_(this.f_58858_, Blocks.f_50016_, this.f_58858_);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private LazyOptional<IFluidHandler> wrapFluidBlock(BlockState blockState, Level world, BlockPos targetPos) {
        if (blockState.m_60734_() instanceof LiquidBlock || blockState.m_60734_() instanceof SimpleWaterloggedBlock) {
            return LazyOptional.of(() -> new FluidHandlerBlock(blockState, world, targetPos));
        }
        return LazyOptional.empty();
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntityFlopper> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityFlopper blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (level != null && !level.f_46443_) {
                blockEntity.setTransferCooldown(blockEntity.getTransferCooldown() - 1);
                if (!this.isOnTransferCooldown(blockEntity)) {
                    blockEntity.setTransferCooldown(0);
                    this.updateHopper(level, pos, blockState, blockEntity);
                }
            }
        }

        private boolean isOnTransferCooldown(BlockEntityFlopper blockEntity) {
            return blockEntity.getTransferCooldown() > 0;
        }

        protected boolean updateHopper(Level level, BlockPos pos, BlockState blockState, BlockEntityFlopper blockEntity) {
            if (level != null && !level.f_46443_) {
                if (!this.isOnTransferCooldown(blockEntity) && ((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)BlockFlopper.ENABLED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                    boolean worked = false;
                    boolean workedWorld = false;
                    if (!blockEntity.getTank().isEmpty()) {
                        boolean bl = BlockFlopperConfig.pushFluidRate > 0 && blockEntity.pushFluidsToTank() || (workedWorld = BlockFlopperConfig.pushFluidsWorld && blockEntity.pushFluidsToWorld()) ? true : (worked = false);
                    }
                    if (!blockEntity.getTank().isFull()) {
                        boolean bl = BlockFlopperConfig.pullFluidRate > 0 && blockEntity.pullFluidsFromTank() || (workedWorld = BlockFlopperConfig.pullFluidsWorld && blockEntity.pullFluidsFromWorld() || workedWorld) || worked ? true : (worked = false);
                    }
                    if (worked) {
                        blockEntity.setTransferCooldown(workedWorld ? BlockFlopperConfig.workWorldCooldown : BlockFlopperConfig.workCooldown);
                        blockEntity.m_6596_();
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
    }
}

